/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.ttest;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;

public class TTestStats
implements Writeable {
    public final long count;
    public final double sum;
    public final double sumOfSqrs;

    public TTestStats(long count, double sum, double sumOfSqrs) {
        this.count = count;
        this.sum = sum;
        this.sumOfSqrs = sumOfSqrs;
    }

    public TTestStats(StreamInput in) throws IOException {
        this.count = in.readVLong();
        this.sum = in.readDouble();
        this.sumOfSqrs = in.readDouble();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        out.writeDouble(this.sum);
        out.writeDouble(this.sumOfSqrs);
    }

    public double variance() {
        double v = (this.sumOfSqrs - this.sum * this.sum / (double)this.count) / (double)(this.count - 1L);
        return v < 0.0 ? 0.0 : v;
    }

    public double average() {
        return this.sum / (double)this.count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TTestStats that = (TTestStats)o;
        return this.count == that.count && Double.compare(that.sum, this.sum) == 0 && Double.compare(that.sumOfSqrs, this.sumOfSqrs) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.count, this.sum, this.sumOfSqrs);
    }

    public static class Reducer
    implements Consumer<TTestStats> {
        private long count = 0L;
        CompensatedSum compSum = new CompensatedSum(0.0, 0.0);
        CompensatedSum compSumOfSqrs = new CompensatedSum(0.0, 0.0);

        @Override
        public void accept(TTestStats stat) {
            this.count += stat.count;
            this.compSum.add(stat.sum);
            this.compSumOfSqrs.add(stat.sumOfSqrs);
        }

        public TTestStats result() {
            return new TTestStats(this.count, this.compSum.value(), this.compSumOfSqrs.value());
        }
    }
}

