/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.rate;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.SizedBucketAggregator;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.rate.InternalRate;
import org.elasticsearch.xpack.analytics.rate.RateMode;

public abstract class AbstractRateAggregator
extends NumericMetricsAggregator.SingleValue {
    protected final ValuesSource valuesSource;
    private final DocValueFormat format;
    private final Rounding.DateTimeUnit rateUnit;
    protected final RateMode rateMode;
    private final SizedBucketAggregator sizedBucketAggregator;
    protected final boolean computeWithDocCount;
    protected DoubleArray sums;
    protected DoubleArray compensations;

    public AbstractRateAggregator(String name, ValuesSourceConfig valuesSourceConfig, Rounding.DateTimeUnit rateUnit, RateMode rateMode, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = valuesSourceConfig.getValuesSource();
        this.format = valuesSourceConfig.format();
        if (this.valuesSource != null) {
            this.sums = this.bigArrays().newDoubleArray(1L, true);
            this.compensations = this.bigArrays().newDoubleArray(1L, true);
            if (rateMode == null) {
                rateMode = RateMode.SUM;
            }
        }
        this.rateUnit = rateUnit;
        this.rateMode = rateMode;
        this.sizedBucketAggregator = this.findSizedBucketAncestor();
        this.computeWithDocCount = valuesSourceConfig.fieldContext() == null && valuesSourceConfig.script() == null;
    }

    private SizedBucketAggregator findSizedBucketAncestor() {
        SizedBucketAggregator sizedBucketAggregator = null;
        for (Aggregator ancestor = this.parent; ancestor != null; ancestor = ancestor.parent()) {
            if (!(ancestor instanceof SizedBucketAggregator)) continue;
            sizedBucketAggregator = (SizedBucketAggregator)ancestor;
            break;
        }
        if (sizedBucketAggregator == null) {
            throw new IllegalArgumentException("The rate aggregation can only be used inside a date histogram aggregation or composite aggregation with one date histogram value source");
        }
        return sizedBucketAggregator;
    }

    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public double metric(long owningBucketOrd) {
        if (this.sizedBucketAggregator == null || this.valuesSource == null || owningBucketOrd >= this.sums.size()) {
            return 0.0;
        }
        return this.sums.get(owningBucketOrd) / this.divisor(owningBucketOrd);
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalRate(this.name, this.sums.get(bucket), this.divisor(bucket), this.format, this.metadata());
    }

    private double divisor(long owningBucketOrd) {
        if (this.sizedBucketAggregator == this.parent) {
            return this.sizedBucketAggregator.bucketSize(owningBucketOrd, this.rateUnit);
        }
        return this.sizedBucketAggregator.bucketSize(this.rateUnit);
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalRate(this.name, 0.0, 1.0, this.format, this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.sums, this.compensations});
    }
}

