/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.analytics.AnalyticsUsage;
import org.elasticsearch.xpack.analytics.action.AnalyticsInfoTransportAction;
import org.elasticsearch.xpack.analytics.action.AnalyticsUsageTransportAction;
import org.elasticsearch.xpack.analytics.action.TransportAnalyticsStatsAction;
import org.elasticsearch.xpack.analytics.aggregations.AnalyticsAggregatorFactory;
import org.elasticsearch.xpack.analytics.boxplot.BoxplotAggregationBuilder;
import org.elasticsearch.xpack.analytics.boxplot.InternalBoxplot;
import org.elasticsearch.xpack.analytics.cumulativecardinality.CumulativeCardinalityPipelineAggregationBuilder;
import org.elasticsearch.xpack.analytics.cumulativecardinality.InternalSimpleLongValue;
import org.elasticsearch.xpack.analytics.mapper.HistogramFieldMapper;
import org.elasticsearch.xpack.analytics.movingPercentiles.MovingPercentilesPipelineAggregationBuilder;
import org.elasticsearch.xpack.analytics.multiterms.InternalMultiTerms;
import org.elasticsearch.xpack.analytics.multiterms.MultiTermsAggregationBuilder;
import org.elasticsearch.xpack.analytics.normalize.NormalizePipelineAggregationBuilder;
import org.elasticsearch.xpack.analytics.rate.InternalRate;
import org.elasticsearch.xpack.analytics.rate.RateAggregationBuilder;
import org.elasticsearch.xpack.analytics.stringstats.InternalStringStats;
import org.elasticsearch.xpack.analytics.stringstats.StringStatsAggregationBuilder;
import org.elasticsearch.xpack.analytics.topmetrics.InternalTopMetrics;
import org.elasticsearch.xpack.analytics.topmetrics.TopMetricsAggregationBuilder;
import org.elasticsearch.xpack.analytics.topmetrics.TopMetricsAggregatorFactory;
import org.elasticsearch.xpack.analytics.ttest.InternalTTest;
import org.elasticsearch.xpack.analytics.ttest.PairedTTestState;
import org.elasticsearch.xpack.analytics.ttest.TTestAggregationBuilder;
import org.elasticsearch.xpack.analytics.ttest.TTestState;
import org.elasticsearch.xpack.analytics.ttest.UnpairedTTestState;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.analytics.action.AnalyticsStatsAction;

public class AnalyticsPlugin
extends Plugin
implements SearchPlugin,
ActionPlugin,
MapperPlugin {
    private final AnalyticsUsage usage = new AnalyticsUsage();

    public List<SearchPlugin.PipelineAggregationSpec> getPipelineAggregations() {
        ArrayList<SearchPlugin.PipelineAggregationSpec> pipelineAggs = new ArrayList<SearchPlugin.PipelineAggregationSpec>();
        pipelineAggs.add(new SearchPlugin.PipelineAggregationSpec("cumulative_cardinality", CumulativeCardinalityPipelineAggregationBuilder::new, this.usage.track(AnalyticsStatsAction.Item.CUMULATIVE_CARDINALITY, CumulativeCardinalityPipelineAggregationBuilder.PARSER)).addResultReader("simple_long_value", InternalSimpleLongValue::new));
        pipelineAggs.add(new SearchPlugin.PipelineAggregationSpec("moving_percentiles", MovingPercentilesPipelineAggregationBuilder::new, this.usage.track(AnalyticsStatsAction.Item.MOVING_PERCENTILES, MovingPercentilesPipelineAggregationBuilder.PARSER)));
        pipelineAggs.add(new SearchPlugin.PipelineAggregationSpec("normalize", NormalizePipelineAggregationBuilder::new, this.usage.track(AnalyticsStatsAction.Item.NORMALIZE, NormalizePipelineAggregationBuilder.PARSER)));
        return pipelineAggs;
    }

    public List<SearchPlugin.AggregationSpec> getAggregations() {
        return Arrays.asList(new SearchPlugin.AggregationSpec("string_stats", StringStatsAggregationBuilder::new, this.usage.track(AnalyticsStatsAction.Item.STRING_STATS, StringStatsAggregationBuilder.PARSER)).addResultReader(InternalStringStats::new).setAggregatorRegistrar(StringStatsAggregationBuilder::registerAggregators), new SearchPlugin.AggregationSpec("boxplot", BoxplotAggregationBuilder::new, this.usage.track(AnalyticsStatsAction.Item.BOXPLOT, BoxplotAggregationBuilder.PARSER)).addResultReader(InternalBoxplot::new).setAggregatorRegistrar(BoxplotAggregationBuilder::registerAggregators), new SearchPlugin.AggregationSpec("top_metrics", TopMetricsAggregationBuilder::new, this.usage.track(AnalyticsStatsAction.Item.TOP_METRICS, TopMetricsAggregationBuilder.PARSER)).addResultReader(InternalTopMetrics::new).setAggregatorRegistrar(TopMetricsAggregationBuilder::registerAggregators), new SearchPlugin.AggregationSpec("t_test", TTestAggregationBuilder::new, this.usage.track(AnalyticsStatsAction.Item.T_TEST, TTestAggregationBuilder.PARSER)).addResultReader(InternalTTest::new).setAggregatorRegistrar(TTestAggregationBuilder::registerUsage), new SearchPlugin.AggregationSpec("rate", RateAggregationBuilder::new, this.usage.track(AnalyticsStatsAction.Item.RATE, RateAggregationBuilder.PARSER)).addResultReader(InternalRate::new).setAggregatorRegistrar(RateAggregationBuilder::registerAggregators), new SearchPlugin.AggregationSpec("multi_terms", MultiTermsAggregationBuilder::new, this.usage.track(AnalyticsStatsAction.Item.MULTI_TERMS, MultiTermsAggregationBuilder.PARSER)).addResultReader(InternalMultiTerms::new).setAggregatorRegistrar(MultiTermsAggregationBuilder::registerAggregators));
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)XPackUsageFeatureAction.ANALYTICS, AnalyticsUsageTransportAction.class), new ActionPlugin.ActionHandler((ActionType)XPackInfoFeatureAction.ANALYTICS, AnalyticsInfoTransportAction.class), new ActionPlugin.ActionHandler((ActionType)AnalyticsStatsAction.INSTANCE, TransportAnalyticsStatsAction.class));
    }

    public List<Setting<?>> getSettings() {
        return Collections.singletonList(TopMetricsAggregatorFactory.MAX_BUCKET_SIZE);
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        return Collections.singletonMap("histogram", HistogramFieldMapper.PARSER);
    }

    public List<Consumer<ValuesSourceRegistry.Builder>> getAggregationExtentions() {
        return List.of(AnalyticsAggregatorFactory::registerPercentilesAggregator, AnalyticsAggregatorFactory::registerPercentileRanksAggregator, AnalyticsAggregatorFactory::registerHistoBackedSumAggregator, AnalyticsAggregatorFactory::registerHistoBackedValueCountAggregator, AnalyticsAggregatorFactory::registerHistoBackedAverageAggregator, AnalyticsAggregatorFactory::registerHistoBackedHistogramAggregator, AnalyticsAggregatorFactory::registerHistoBackedMinggregator, AnalyticsAggregatorFactory::registerHistoBackedMaxggregator, AnalyticsAggregatorFactory::registerHistoBackedRangeAggregator);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        return Collections.singletonList(this.usage);
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Arrays.asList(new NamedWriteableRegistry.Entry(TTestState.class, "P", PairedTTestState::new), new NamedWriteableRegistry.Entry(TTestState.class, "U", UnpairedTTestState::new));
    }
}

