/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.modelsnapshots;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.UpgradeJobModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestUpgradeJobModelSnapshotAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_ml/anomaly_detectors/{" + Job.ID + "}/model_snapshots/{" + UpgradeJobModelSnapshotAction.Request.SNAPSHOT_ID + "}/_upgrade"));
    }

    public String getName() {
        return "ml_upgrade_job_model_snapshot_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String jobId = restRequest.param(Job.ID.getPreferredName());
        String snapshotId = restRequest.param(UpgradeJobModelSnapshotAction.Request.SNAPSHOT_ID.getPreferredName());
        TimeValue timeout = TimeValue.parseTimeValue((String)restRequest.param(UpgradeJobModelSnapshotAction.Request.TIMEOUT.getPreferredName(), UpgradeJobModelSnapshotAction.Request.DEFAULT_TIMEOUT.getStringRep()), (String)UpgradeJobModelSnapshotAction.Request.TIMEOUT.getPreferredName());
        boolean waitForCompletion = restRequest.paramAsBoolean(UpgradeJobModelSnapshotAction.Request.WAIT_FOR_COMPLETION.getPreferredName(), false);
        UpgradeJobModelSnapshotAction.Request request = new UpgradeJobModelSnapshotAction.Request(jobId, snapshotId, timeout, waitForCompletion);
        return channel -> client.execute((ActionType)UpgradeJobModelSnapshotAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

