/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.retention.MlDataRemover;

public class EmptyStateIndexRemover
implements MlDataRemover {
    private final OriginSettingClient client;
    private final TaskId parentTaskId;

    public EmptyStateIndexRemover(OriginSettingClient client, TaskId parentTaskId) {
        this.client = Objects.requireNonNull(client);
        this.parentTaskId = parentTaskId;
    }

    @Override
    public void remove(float requestsPerSec, ActionListener<Boolean> listener, BooleanSupplier isTimedOutSupplier) {
        try {
            if (isTimedOutSupplier.getAsBoolean()) {
                listener.onResponse((Object)false);
                return;
            }
            this.getEmptyStateIndices((ActionListener<Set<String>>)ActionListener.wrap(emptyStateIndices -> {
                if (emptyStateIndices.isEmpty()) {
                    listener.onResponse((Object)true);
                    return;
                }
                this.getCurrentStateIndices((ActionListener<Set<String>>)ActionListener.wrap(currentStateIndices -> {
                    Set stateIndicesToRemove = Sets.difference((Set)emptyStateIndices, (Set)currentStateIndices);
                    if (stateIndicesToRemove.isEmpty()) {
                        listener.onResponse((Object)true);
                        return;
                    }
                    this.executeDeleteEmptyStateIndices(stateIndicesToRemove, listener);
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }, arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void getEmptyStateIndices(ActionListener<Set<String>> listener) {
        IndicesStatsRequest indicesStatsRequest = (IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()});
        indicesStatsRequest.setParentTask(this.parentTaskId);
        this.client.admin().indices().stats(indicesStatsRequest, ActionListener.wrap(indicesStatsResponse -> {
            Set emptyStateIndices = indicesStatsResponse.getIndices().values().stream().filter(stats -> stats.getTotal().getDocs().getCount() == 0L).map(IndexStats::getIndex).collect(Collectors.toSet());
            listener.onResponse(emptyStateIndices);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void getCurrentStateIndices(ActionListener<Set<String>> listener) {
        GetIndexRequest getIndexRequest = (GetIndexRequest)new GetIndexRequest().indices(new String[]{AnomalyDetectorsIndex.jobStateIndexWriteAlias()});
        getIndexRequest.setParentTask(this.parentTaskId);
        this.client.admin().indices().getIndex(getIndexRequest, ActionListener.wrap(getIndexResponse -> listener.onResponse(Set.of(getIndexResponse.getIndices())), arg_0 -> listener.onFailure(arg_0)));
    }

    private void executeDeleteEmptyStateIndices(Set<String> emptyStateIndices, ActionListener<Boolean> listener) {
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(emptyStateIndices.toArray(new String[0]));
        deleteIndexRequest.setParentTask(this.parentTaskId);
        this.client.admin().indices().delete(deleteIndexRequest, ActionListener.wrap(deleteResponse -> listener.onResponse((Object)deleteResponse.isAcknowledged()), arg_0 -> listener.onFailure(arg_0)));
    }
}

