/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.output.FlushAcknowledgement;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeState;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;
import org.elasticsearch.xpack.ml.job.persistence.StateStreamer;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessFactory;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectWorkerExecutorService;
import org.elasticsearch.xpack.ml.job.process.autodetect.output.JobSnapshotUpgraderResultProcessor;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.AutodetectParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.FlushJobParams;
import org.elasticsearch.xpack.ml.job.snapshot.upgrader.SnapshotUpgradeTask;
import org.elasticsearch.xpack.ml.process.NativeStorageProvider;

public final class JobModelSnapshotUpgrader {
    private static final Duration FLUSH_PROCESS_CHECK_FREQUENCY = Duration.ofSeconds(1L);
    private static final Logger logger = LogManager.getLogger(JobModelSnapshotUpgrader.class);
    private final SnapshotUpgradeTask task;
    private final Job job;
    private final String jobId;
    private final String snapshotId;
    private final AutodetectParams params;
    private final Client client;
    private final Consumer<Exception> onFinish;
    private final Supplier<Boolean> continueRunning;
    private final ThreadPool threadPool;
    private final AutodetectProcessFactory autodetectProcessFactory;
    private final JobResultsPersister jobResultsPersister;
    private final NativeStorageProvider nativeStorageProvider;

    JobModelSnapshotUpgrader(SnapshotUpgradeTask task, Job job, AutodetectParams params, ThreadPool threadPool, AutodetectProcessFactory autodetectProcessFactory, JobResultsPersister jobResultsPersister, Client client, NativeStorageProvider nativeStorageProvider, Consumer<Exception> onFinish, Supplier<Boolean> continueRunning) {
        this.task = Objects.requireNonNull(task);
        this.job = Objects.requireNonNull(job);
        this.params = Objects.requireNonNull(params);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.autodetectProcessFactory = Objects.requireNonNull(autodetectProcessFactory);
        this.jobResultsPersister = Objects.requireNonNull(jobResultsPersister);
        this.nativeStorageProvider = Objects.requireNonNull(nativeStorageProvider);
        this.client = Objects.requireNonNull(client);
        this.onFinish = Objects.requireNonNull(onFinish);
        this.continueRunning = Objects.requireNonNull(continueRunning);
        this.jobId = task.getJobId();
        this.snapshotId = task.getSnapshotId();
    }

    void start() {
        AutodetectWorkerExecutorService autodetectWorkerExecutor;
        ExecutorService autodetectExecutorService = this.threadPool.executor("ml_job_comms");
        AutodetectProcess process = this.autodetectProcessFactory.createAutodetectProcess(this.jobId + "-" + this.snapshotId, this.job, this.params, autodetectExecutorService, reason -> {
            this.setTaskToFailed((String)reason, (ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>)ActionListener.wrap(t -> {}, f -> {}));
            try {
                this.nativeStorageProvider.cleanupLocalTmpStorage(this.task.getDescription());
            }
            catch (IOException e) {
                logger.error((Message)new ParameterizedMessage("[{}] [{}] failed to delete temporary files snapshot upgrade", (Object)this.jobId, (Object)this.snapshotId), (Throwable)e);
            }
        });
        JobSnapshotUpgraderResultProcessor processor = new JobSnapshotUpgraderResultProcessor(this.jobId, this.snapshotId, this.jobResultsPersister, process);
        try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().stashContext();){
            autodetectWorkerExecutor = new AutodetectWorkerExecutorService(this.threadPool.getThreadContext());
            autodetectExecutorService.submit(autodetectWorkerExecutor::start);
            autodetectExecutorService.submit(processor::process);
        }
        catch (EsRejectedExecutionException e) {
            try {
                IOUtils.close((Closeable)process);
            }
            catch (IOException ioe) {
                logger.error("Can't close autodetect", (Throwable)ioe);
            }
            this.onFinish.accept((Exception)((Object)e));
            return;
        }
        StateStreamer stateStreamer = new StateStreamer(this.client);
        Executor executor = new Executor(stateStreamer, processor, autodetectWorkerExecutor, process);
        if (!this.continueRunning.get().booleanValue()) {
            this.onFinish.accept(null);
            return;
        }
        executor.execute();
    }

    void setTaskToFailed(String reason, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        SnapshotUpgradeTaskState taskState = new SnapshotUpgradeTaskState(SnapshotUpgradeState.FAILED, this.task.getAllocationId(), reason);
        this.task.updatePersistentTaskState((PersistentTaskState)taskState, ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), f -> {
            logger.warn(() -> new ParameterizedMessage("[{}] [{}] failed to set task to failed", (Object)this.task.getJobId(), (Object)this.task.getSnapshotId()), (Throwable)f);
            listener.onFailure(f);
        }));
    }

    private class Executor {
        private final StateStreamer stateStreamer;
        private final JobSnapshotUpgraderResultProcessor processor;
        private final ExecutorService autodetectWorkerExecutor;
        private final AutodetectProcess process;

        Executor(StateStreamer stateStreamer, JobSnapshotUpgraderResultProcessor processor, ExecutorService autodetectWorkerExecutor, AutodetectProcess process) {
            this.stateStreamer = stateStreamer;
            this.processor = processor;
            this.autodetectWorkerExecutor = autodetectWorkerExecutor;
            this.process = process;
        }

        void execute() {
            this.restoreState();
        }

        protected final Map<String, Integer> outputFieldIndexes() {
            HashMap<String, Integer> fieldIndexes = new HashMap<String, Integer>();
            fieldIndexes.put(JobModelSnapshotUpgrader.this.job.getDataDescription().getTimeField(), 0);
            int index = 1;
            for (String field : JobModelSnapshotUpgrader.this.job.getAnalysisConfig().analysisFields()) {
                if ("mlcategory".equals(field)) continue;
                fieldIndexes.put(field, index++);
            }
            if (JobModelSnapshotUpgrader.this.job.getAnalysisConfig().getCategorizationFieldName() != null) {
                fieldIndexes.put("...", index++);
            }
            fieldIndexes.put(".", index++);
            return fieldIndexes;
        }

        void writeHeader() throws IOException {
            Map<String, Integer> outFieldIndexes = this.outputFieldIndexes();
            int numFields = outFieldIndexes.size();
            String[] record = new String[numFields];
            for (Map.Entry<String, Integer> entry : outFieldIndexes.entrySet()) {
                record[entry.getValue().intValue()] = entry.getKey();
            }
            this.process.writeRecord(record);
        }

        FlushAcknowledgement waitFlushToCompletion(String flushId) throws Exception {
            FlushAcknowledgement flushAcknowledgement;
            logger.debug(() -> new ParameterizedMessage("[{}] [{}] waiting for flush [{}]", new Object[]{JobModelSnapshotUpgrader.this.jobId, JobModelSnapshotUpgrader.this.snapshotId, flushId}));
            try {
                flushAcknowledgement = this.processor.waitForFlushAcknowledgement(flushId, FLUSH_PROCESS_CHECK_FREQUENCY);
                while (flushAcknowledgement == null) {
                    this.checkProcessIsAlive();
                    this.checkResultsProcessorIsAlive();
                    flushAcknowledgement = this.processor.waitForFlushAcknowledgement(flushId, FLUSH_PROCESS_CHECK_FREQUENCY);
                }
            }
            finally {
                this.processor.clearAwaitingFlush(flushId);
            }
            logger.debug(() -> new ParameterizedMessage("[{}] [{}] flush completed [{}]", new Object[]{JobModelSnapshotUpgrader.this.jobId, JobModelSnapshotUpgrader.this.snapshotId, flushId}));
            return flushAcknowledgement;
        }

        void restoreState() {
            try {
                this.process.restoreState(this.stateStreamer, JobModelSnapshotUpgrader.this.params.modelSnapshot());
            }
            catch (Exception e2) {
                logger.error(() -> new ParameterizedMessage("[{}] [{}] failed to write old state", (Object)JobModelSnapshotUpgrader.this.jobId, (Object)JobModelSnapshotUpgrader.this.snapshotId), (Throwable)e2);
                JobModelSnapshotUpgrader.this.setTaskToFailed("Failed to write old state due to: " + e2.getMessage(), ActionListener.wrap(t -> this.shutdown(e2), f -> this.shutdown(e2)));
                return;
            }
            this.submitOperation(() -> {
                this.writeHeader();
                String flushId = this.process.flushJob(FlushJobParams.builder().waitForNormalization(false).build());
                return this.waitFlushToCompletion(flushId);
            }, (flushAcknowledgement, e) -> {
                Runnable nextStep;
                if (e != null) {
                    logger.error(() -> new ParameterizedMessage("[{}] [{}] failed to flush after writing old state", (Object)JobModelSnapshotUpgrader.this.jobId, (Object)JobModelSnapshotUpgrader.this.snapshotId), (Throwable)e);
                    nextStep = () -> JobModelSnapshotUpgrader.this.setTaskToFailed("Failed to flush after writing old state due to: " + e.getMessage(), ActionListener.wrap(t -> this.shutdown((Exception)e), f -> this.shutdown((Exception)e)));
                } else {
                    logger.debug(() -> new ParameterizedMessage("[{}] [{}] flush [{}] acknowledged requesting state write", new Object[]{JobModelSnapshotUpgrader.this.jobId, JobModelSnapshotUpgrader.this.snapshotId, flushAcknowledgement.getId()}));
                    nextStep = this::requestStateWrite;
                }
                JobModelSnapshotUpgrader.this.threadPool.executor("ml_utility").execute(nextStep);
            });
        }

        private void requestStateWrite() {
            JobModelSnapshotUpgrader.this.task.updatePersistentTaskState((PersistentTaskState)new SnapshotUpgradeTaskState(SnapshotUpgradeState.SAVING_NEW_STATE, JobModelSnapshotUpgrader.this.task.getAllocationId(), ""), ActionListener.wrap(readingNewState -> {
                if (!JobModelSnapshotUpgrader.this.continueRunning.get().booleanValue()) {
                    this.shutdown(null);
                    return;
                }
                this.submitOperation(() -> {
                    this.process.persistState(JobModelSnapshotUpgrader.this.params.modelSnapshot().getTimestamp().getTime(), JobModelSnapshotUpgrader.this.params.modelSnapshot().getSnapshotId(), JobModelSnapshotUpgrader.this.params.modelSnapshot().getDescription());
                    return null;
                }, (aVoid, e) -> JobModelSnapshotUpgrader.this.threadPool.executor("ml_utility").execute(() -> this.shutdown((Exception)e)));
                logger.info("asked for state to be persisted");
            }, f -> {
                logger.error(() -> new ParameterizedMessage("[{}] [{}] failed to update snapshot upgrader task to started", (Object)JobModelSnapshotUpgrader.this.jobId, (Object)JobModelSnapshotUpgrader.this.snapshotId), (Throwable)f);
                this.shutdown((Exception)((Object)new ElasticsearchStatusException("Failed to start snapshot upgrade [{}] for job [{}]", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)f, new Object[]{JobModelSnapshotUpgrader.this.snapshotId, JobModelSnapshotUpgrader.this.jobId})));
            }));
        }

        private <T> void submitOperation(final CheckedSupplier<T, Exception> operation, final BiConsumer<T, Exception> handler) {
            this.autodetectWorkerExecutor.execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    if (!JobModelSnapshotUpgrader.this.continueRunning.get().booleanValue()) {
                        handler.accept(null, ExceptionsHelper.conflictStatusException((String)"[{}] Could not submit operation to process as it has been killed", (Object[])new Object[]{JobModelSnapshotUpgrader.this.job.getId()}));
                    } else {
                        logger.error((Message)new ParameterizedMessage("[{}] Unexpected exception writing to process", (Object)JobModelSnapshotUpgrader.this.job.getId()), (Throwable)e);
                        handler.accept(null, e);
                    }
                }

                protected void doRun() throws Exception {
                    if (!JobModelSnapshotUpgrader.this.continueRunning.get().booleanValue()) {
                        handler.accept(null, ExceptionsHelper.conflictStatusException((String)"[{}] Could not submit operation to process as it has been killed", (Object[])new Object[]{JobModelSnapshotUpgrader.this.job.getId()}));
                    } else {
                        Executor.this.checkProcessIsAlive();
                        handler.accept(operation.get(), null);
                    }
                }
            });
        }

        private void checkProcessIsAlive() {
            if (!this.process.isProcessAlive()) {
                throw new ElasticsearchException("[{}] Unexpected death of autodetect: {}", new Object[]{JobModelSnapshotUpgrader.this.job.getId(), this.process.readError()});
            }
        }

        private void checkResultsProcessorIsAlive() {
            if (this.processor.isFailed()) {
                throw new ElasticsearchException("[{}] Unexpected death of the result processor", new Object[]{JobModelSnapshotUpgrader.this.job.getId()});
            }
        }

        void shutdown(Exception e) {
            if (!this.process.isProcessAlive()) {
                JobModelSnapshotUpgrader.this.onFinish.accept(e);
                this.autodetectWorkerExecutor.shutdown();
                this.stateStreamer.cancel();
                return;
            }
            this.autodetectWorkerExecutor.execute(() -> {
                try {
                    if (this.process.isReady()) {
                        this.process.close();
                    } else {
                        this.processor.setProcessKilled();
                        this.process.kill(true);
                        this.processor.awaitCompletion();
                    }
                }
                catch (IOException | TimeoutException exc) {
                    logger.warn(() -> new ParameterizedMessage("[{}] [{}] failed to shutdown process", (Object)JobModelSnapshotUpgrader.this.jobId, (Object)JobModelSnapshotUpgrader.this.snapshotId), (Throwable)exc);
                }
                finally {
                    JobModelSnapshotUpgrader.this.onFinish.accept(e);
                }
            });
            this.autodetectWorkerExecutor.shutdown();
            this.stateStreamer.cancel();
        }
    }
}

