/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp.tokenizers;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class WordPieceVocabulary
implements ToXContentObject {
    public static final String NAME = "vocab";
    public static final ParseField VOCAB = new ParseField("vocab", new String[0]);
    public static final ParseField UNKNOWN_TOKEN = new ParseField("unknown", new String[0]);
    private static final ConstructingObjectParser<WordPieceVocabulary, Void> STRICT_PARSER = WordPieceVocabulary.createParser(false);
    private static final ConstructingObjectParser<WordPieceVocabulary, Void> LENIENT_PARSER = WordPieceVocabulary.createParser(true);
    private final SortedMap<String, Integer> vocab;
    private final int unknownToken;

    private static ConstructingObjectParser<WordPieceVocabulary, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, ignoreUnknownFields, a -> new WordPieceVocabulary((List)a[0], (Integer)a[1]));
        parser.declareStringArray(ConstructingObjectParser.constructorArg(), VOCAB);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), UNKNOWN_TOKEN);
        return parser;
    }

    public static WordPieceVocabulary fromXContent(XContentParser parser, boolean lenient) {
        return lenient ? (WordPieceVocabulary)LENIENT_PARSER.apply(parser, null) : (WordPieceVocabulary)STRICT_PARSER.apply(parser, null);
    }

    public WordPieceVocabulary(List<String> words, Integer unknownToken) {
        this.unknownToken = unknownToken == null ? -1 : unknownToken;
        this.vocab = new TreeMap<String, Integer>();
        for (int i = 0; i < words.size(); ++i) {
            this.vocab.put(words.get(i), i);
        }
    }

    public int token(String word) {
        Integer token = (Integer)this.vocab.get(word);
        if (token == null) {
            token = this.unknownToken;
        }
        return token;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(VOCAB.getPreferredName(), this.vocab.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WordPieceVocabulary that = (WordPieceVocabulary)o;
        return this.unknownToken == that.unknownToken && Objects.equals(this.vocab, that.vocab);
    }

    public int hashCode() {
        return Objects.hash(this.vocab, this.unknownToken);
    }
}

