/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.steps;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsTask;
import org.elasticsearch.xpack.ml.dataframe.inference.InferenceRunner;
import org.elasticsearch.xpack.ml.dataframe.steps.AbstractDataFrameAnalyticsStep;
import org.elasticsearch.xpack.ml.dataframe.steps.DataFrameAnalyticsStep;
import org.elasticsearch.xpack.ml.dataframe.steps.StepResponse;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.utils.MlIndicesUtils;

public class InferenceStep
extends AbstractDataFrameAnalyticsStep {
    private static final Logger LOGGER = LogManager.getLogger(InferenceStep.class);
    private final ThreadPool threadPool;
    private final InferenceRunner inferenceRunner;

    public InferenceStep(NodeClient client, DataFrameAnalyticsTask task, DataFrameAnalyticsAuditor auditor, DataFrameAnalyticsConfig config, ThreadPool threadPool, InferenceRunner inferenceRunner) {
        super(client, task, auditor, config);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.inferenceRunner = Objects.requireNonNull(inferenceRunner);
    }

    @Override
    public DataFrameAnalyticsStep.Name name() {
        return DataFrameAnalyticsStep.Name.INFERENCE;
    }

    @Override
    protected void doExecute(ActionListener<StepResponse> listener) {
        if (!this.config.getAnalysis().supportsInference()) {
            LOGGER.debug(() -> new ParameterizedMessage("[{}] Inference step completed immediately as analysis does not support inference", (Object)this.config.getId()));
            listener.onResponse((Object)new StepResponse(false));
            return;
        }
        ActionListener modelIdListener = ActionListener.wrap(modelId -> this.runInference((String)modelId, listener), arg_0 -> listener.onFailure(arg_0));
        ActionListener testDocsExistListener = ActionListener.wrap(testDocsExist -> {
            if (!testDocsExist.booleanValue()) {
                LOGGER.debug(() -> new ParameterizedMessage("[{}] Inference step completed immediately as there are no test docs", (Object)this.config.getId()));
                this.task.getStatsHolder().getProgressTracker().updateInferenceProgress(100);
                listener.onResponse((Object)new StepResponse(this.isTaskStopping()));
                return;
            }
            this.getModelId((ActionListener<String>)modelIdListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener refreshDestListener = ActionListener.wrap(refreshResponse -> this.searchIfTestDocsExist((ActionListener<Boolean>)testDocsExistListener), arg_0 -> listener.onFailure(arg_0));
        this.refreshDestAsync((ActionListener<RefreshResponse>)refreshDestListener);
    }

    private void runInference(String modelId, ActionListener<StepResponse> listener) {
        this.threadPool.executor("ml_utility").execute(() -> {
            try {
                this.inferenceRunner.run(modelId);
                listener.onResponse((Object)new StepResponse(this.isTaskStopping()));
            }
            catch (Exception e) {
                if (this.task.isStopping()) {
                    listener.onResponse((Object)new StepResponse(false));
                }
                listener.onFailure(e);
            }
        });
    }

    private void searchIfTestDocsExist(ActionListener<Boolean> listener) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.config.getDest().getIndex()});
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS));
        searchRequest.source().query((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)(this.config.getDest().getResultsField() + ".is_training"), (boolean)true)));
        searchRequest.source().size(0);
        searchRequest.source().trackTotalHitsUpTo(1);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> listener.onResponse((Object)(searchResponse.getHits().getTotalHits().value > 0L ? 1 : 0)), arg_0 -> listener.onFailure(arg_0)));
    }

    private void getModelId(ActionListener<String> listener) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.size(1);
        searchSourceBuilder.fetchSource(false);
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TrainedModelConfig.TAGS.getPreferredName(), (String)this.config.getId())));
        searchSourceBuilder.sort(TrainedModelConfig.CREATE_TIME.getPreferredName(), SortOrder.DESC);
        SearchRequest searchRequest = new SearchRequest(new String[]{".ml-inference-*"});
        searchRequest.source(searchSourceBuilder);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
            SearchHit[] hits = searchResponse.getHits().getHits();
            if (hits.length == 0) {
                listener.onFailure((Exception)((Object)new ResourceNotFoundException("No model could be found to perform inference", new Object[0])));
            } else {
                listener.onResponse((Object)hits[0].getId());
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void cancel(String reason, TimeValue timeout) {
        this.inferenceRunner.cancel();
    }

    @Override
    public void updateProgress(ActionListener<Void> listener) {
        listener.onResponse(null);
    }
}

