/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.aggregation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.ExtractorUtils;
import org.elasticsearch.xpack.core.ml.utils.Intervals;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregatedSearchRequestBuilder;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationToJsonProcessor;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.CompositeAggregationDataExtractorContext;

class CompositeAggregationDataExtractor
implements DataExtractor {
    private static final Logger LOGGER = LogManager.getLogger(CompositeAggregationDataExtractor.class);
    private volatile Map<String, Object> afterKey = null;
    private final CompositeAggregationBuilder compositeAggregationBuilder;
    private final Client client;
    private final CompositeAggregationDataExtractorContext context;
    private final DatafeedTimingStatsReporter timingStatsReporter;
    private final AggregatedSearchRequestBuilder requestBuilder;
    private final long interval;
    private volatile boolean isCancelled;
    private volatile long nextBucketOnCancel;
    private boolean hasNext;

    CompositeAggregationDataExtractor(CompositeAggregationBuilder compositeAggregationBuilder, Client client, CompositeAggregationDataExtractorContext dataExtractorContext, DatafeedTimingStatsReporter timingStatsReporter, AggregatedSearchRequestBuilder requestBuilder) {
        this.compositeAggregationBuilder = Objects.requireNonNull(compositeAggregationBuilder);
        this.client = Objects.requireNonNull(client);
        this.context = Objects.requireNonNull(dataExtractorContext);
        this.timingStatsReporter = Objects.requireNonNull(timingStatsReporter);
        this.requestBuilder = Objects.requireNonNull(requestBuilder);
        this.interval = ExtractorUtils.getHistogramIntervalMillis((AggregationBuilder)compositeAggregationBuilder);
        this.hasNext = true;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void cancel() {
        LOGGER.debug(() -> new ParameterizedMessage("[{}] Data extractor received cancel request", (Object)this.context.jobId));
        this.isCancelled = true;
    }

    public long getEndTime() {
        return this.context.end;
    }

    public Optional<InputStream> next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Aggregations aggs = this.search();
        if (aggs == null) {
            LOGGER.trace(() -> new ParameterizedMessage("[{}] extraction finished", (Object)this.context.jobId));
            this.hasNext = false;
            this.afterKey = null;
            return Optional.empty();
        }
        return Optional.of(this.processAggs(aggs));
    }

    private Aggregations search() {
        LOGGER.trace(() -> new ParameterizedMessage("[{}] Executing composite aggregated search from [{}] to [{}]", new Object[]{this.context.jobId, this.context.start, this.context.end}));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).query(ExtractorUtils.wrapInTimeRangeQuery((QueryBuilder)this.context.query, (String)this.context.timeField, (long)this.context.start, (long)this.context.end));
        if (!this.context.runtimeMappings.isEmpty()) {
            searchSourceBuilder.runtimeMappings(this.context.runtimeMappings);
        }
        if (this.afterKey != null) {
            this.compositeAggregationBuilder.aggregateAfter(this.afterKey);
        }
        searchSourceBuilder.aggregation((AggregationBuilder)this.compositeAggregationBuilder);
        ActionRequestBuilder<SearchRequest, SearchResponse> searchRequest = this.requestBuilder.build(searchSourceBuilder);
        SearchResponse searchResponse = this.executeSearchRequest(searchRequest);
        LOGGER.trace(() -> new ParameterizedMessage("[{}] Search composite response was obtained", (Object)this.context.jobId));
        this.timingStatsReporter.reportSearchDuration(searchResponse.getTook());
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            return null;
        }
        CompositeAggregation compositeAgg = (CompositeAggregation)aggregations.get(this.compositeAggregationBuilder.getName());
        if (compositeAgg == null || compositeAgg.getBuckets().isEmpty()) {
            return null;
        }
        return aggregations;
    }

    protected SearchResponse executeSearchRequest(ActionRequestBuilder<SearchRequest, SearchResponse> searchRequestBuilder) {
        return (SearchResponse)ClientHelper.executeWithHeaders(this.context.headers, (String)"ml", (Client)this.client, () -> searchRequestBuilder.get());
    }

    private InputStream processAggs(Aggregations aggs) throws IOException {
        AggregationToJsonProcessor aggregationToJsonProcessor = new AggregationToJsonProcessor(this.context.timeField, this.context.fields, this.context.includeDocCount, this.context.start, this.context.compositeAggDateHistogramGroupSourceName);
        LOGGER.trace(() -> new ParameterizedMessage("[{}] got [{}] composite buckets", (Object)this.context.jobId, (Object)((CompositeAggregation)aggs.get(this.compositeAggregationBuilder.getName())).getBuckets().size()));
        aggregationToJsonProcessor.process(aggs);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Long afterKeyTimeBucket = this.afterKey != null ? (Long)this.afterKey.get(this.context.compositeAggDateHistogramGroupSourceName) : null;
        boolean cancellable = aggregationToJsonProcessor.writeAllDocsCancellable(timestamp -> {
            if (this.isCancelled) {
                if (afterKeyTimeBucket == null) {
                    return true;
                }
                if (this.nextBucketOnCancel == 0L) {
                    this.nextBucketOnCancel = Intervals.alignToFloor((long)(timestamp + this.interval), (long)this.interval);
                    LOGGER.debug(() -> new ParameterizedMessage("[{}] set future timestamp cancel to [{}] via timestamp [{}]", new Object[]{this.context.jobId, this.nextBucketOnCancel, timestamp}));
                }
                return timestamp >= this.nextBucketOnCancel;
            }
            return false;
        }, outputStream);
        if (this.isCancelled && cancellable) {
            LOGGER.debug(() -> new ParameterizedMessage("[{}] cancelled before bucket [{}] on date_histogram page [{}]", new Object[]{this.context.jobId, this.nextBucketOnCancel, afterKeyTimeBucket != null ? afterKeyTimeBucket : "__null__"}));
            this.hasNext = false;
        }
        CompositeAggregation compositeAgg = (CompositeAggregation)aggs.get(this.compositeAggregationBuilder.getName());
        this.afterKey = compositeAgg.afterKey();
        return new ByteArrayInputStream(outputStream.toByteArray());
    }
}

