/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedUpdate;
import org.elasticsearch.xpack.ml.MlAutoUpdateService;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;

public class DatafeedConfigAutoUpdater
implements MlAutoUpdateService.UpdateAction {
    private static final Logger logger = LogManager.getLogger(DatafeedConfigAutoUpdater.class);
    private final DatafeedConfigProvider provider;
    private final IndexNameExpressionResolver expressionResolver;

    public DatafeedConfigAutoUpdater(DatafeedConfigProvider provider, IndexNameExpressionResolver expressionResolver) {
        this.provider = provider;
        this.expressionResolver = expressionResolver;
    }

    @Override
    public boolean isMinNodeVersionSupported(Version minNodeVersion) {
        return minNodeVersion.onOrAfter(Version.V_8_0_0);
    }

    @Override
    public boolean isAbleToRun(ClusterState latestState) {
        String[] indices;
        for (String index : indices = this.expressionResolver.concreteIndexNames(latestState, IndicesOptions.lenientExpandOpenHidden(), new String[]{MlConfigIndex.indexName()})) {
            IndexRoutingTable routingTable;
            if (!latestState.metadata().hasIndex(index) || (routingTable = latestState.getRoutingTable().index(index)) != null && routingTable.allPrimaryShardsActive()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "datafeed_aggs_updater";
    }

    @Override
    public void runUpdate() {
        PlainActionFuture getdatafeeds = PlainActionFuture.newFuture();
        this.provider.expandDatafeedConfigs("_all", true, (ActionListener<List<DatafeedConfig.Builder>>)getdatafeeds);
        List datafeedConfigBuilders = (List)getdatafeeds.actionGet();
        List updates = datafeedConfigBuilders.stream().map(DatafeedConfig.Builder::build).filter(DatafeedConfig::aggsRewritten).map(datafeedConfig -> new DatafeedUpdate.Builder().setAggregations(datafeedConfig.getAggProvider()).setId(datafeedConfig.getId()).build()).collect(Collectors.toList());
        if (updates.isEmpty()) {
            return;
        }
        logger.debug(() -> new ParameterizedMessage("{} datafeeds are currently being updated", updates.stream().map(DatafeedUpdate::getId).collect(Collectors.toList())));
        ArrayList<ElasticsearchException> failures = new ArrayList<ElasticsearchException>();
        for (DatafeedUpdate update : updates) {
            PlainActionFuture updateDatafeeds = PlainActionFuture.newFuture();
            this.provider.updateDatefeedConfig(update.getId(), update, Collections.emptyMap(), (updatedConfig, listener) -> listener.onResponse((Object)Boolean.TRUE), (ActionListener<DatafeedConfig>)updateDatafeeds);
            try {
                updateDatafeeds.actionGet();
                logger.debug(() -> new ParameterizedMessage("[{}] datafeed successfully updated", (Object)update.getId()));
            }
            catch (Exception ex) {
                logger.warn((Message)new ParameterizedMessage("[{}] failed being updated", (Object)update.getId()), (Throwable)ex);
                failures.add(new ElasticsearchException("Failed to update datafeed {}", (Throwable)ex, new Object[]{update.getId()}));
            }
        }
        if (failures.isEmpty()) {
            logger.debug(() -> new ParameterizedMessage("{} datafeeds are finished being updated", updates.stream().map(DatafeedUpdate::getId).collect(Collectors.toList())));
            return;
        }
        ElasticsearchException exception = new ElasticsearchException("some datafeeds failed being upgraded.", new Object[0]);
        failures.forEach(arg_0 -> exception.addSuppressed(arg_0));
        throw exception;
    }
}

