/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.autoscaling;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCapacity;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResult;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class MlScalingReason
implements AutoscalingDeciderResult.Reason {
    public static final String NAME = "ml";
    static final String WAITING_ANALYTICS_JOBS = "waiting_analytics_jobs";
    static final String WAITING_ANOMALY_JOBS = "waiting_anomaly_jobs";
    static final String WAITING_MODELS = "waiting_models";
    static final String CONFIGURATION = "configuration";
    static final String LARGEST_WAITING_ANALYTICS_JOB = "largest_waiting_analytics_job";
    static final String LARGEST_WAITING_ANOMALY_JOB = "largest_waiting_anomaly_job";
    static final String CURRENT_CAPACITY = "perceived_current_capacity";
    static final String REQUIRED_CAPACITY = "required_capacity";
    static final String REASON = "reason";
    private final List<String> waitingAnalyticsJobs;
    private final List<String> waitingAnomalyJobs;
    private final List<String> waitingModels;
    private final Settings passedConfiguration;
    private final Long largestWaitingAnalyticsJob;
    private final Long largestWaitingAnomalyJob;
    private final AutoscalingCapacity currentMlCapacity;
    private final AutoscalingCapacity requiredCapacity;
    private final String simpleReason;

    public MlScalingReason(StreamInput in) throws IOException {
        this.waitingAnalyticsJobs = in.readStringList();
        this.waitingAnomalyJobs = in.readStringList();
        this.waitingModels = in.getVersion().onOrAfter(Version.V_8_0_0) ? in.readStringList() : List.of();
        this.passedConfiguration = Settings.readSettingsFromStream((StreamInput)in);
        this.currentMlCapacity = new AutoscalingCapacity(in);
        this.requiredCapacity = (AutoscalingCapacity)in.readOptionalWriteable(AutoscalingCapacity::new);
        this.largestWaitingAnalyticsJob = in.readOptionalVLong();
        this.largestWaitingAnomalyJob = in.readOptionalVLong();
        this.simpleReason = in.readString();
    }

    MlScalingReason(List<String> waitingAnalyticsJobs, List<String> waitingAnomalyJobs, List<String> waitingModels, Settings passedConfiguration, Long largestWaitingAnalyticsJob, Long largestWaitingAnomalyJob, AutoscalingCapacity currentMlCapacity, AutoscalingCapacity requiredCapacity, String simpleReason) {
        this.waitingAnalyticsJobs = waitingAnalyticsJobs == null ? Collections.emptyList() : waitingAnalyticsJobs;
        this.waitingAnomalyJobs = waitingAnomalyJobs == null ? Collections.emptyList() : waitingAnomalyJobs;
        this.waitingModels = waitingModels == null ? List.of() : waitingModels;
        this.passedConfiguration = (Settings)ExceptionsHelper.requireNonNull((Object)passedConfiguration, (String)CONFIGURATION);
        this.largestWaitingAnalyticsJob = largestWaitingAnalyticsJob;
        this.largestWaitingAnomalyJob = largestWaitingAnomalyJob;
        this.currentMlCapacity = (AutoscalingCapacity)ExceptionsHelper.requireNonNull((Object)currentMlCapacity, (String)CURRENT_CAPACITY);
        this.requiredCapacity = requiredCapacity;
        this.simpleReason = (String)ExceptionsHelper.requireNonNull((Object)simpleReason, (String)REASON);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MlScalingReason that = (MlScalingReason)o;
        return Objects.equals(this.waitingAnalyticsJobs, that.waitingAnalyticsJobs) && Objects.equals(this.waitingAnomalyJobs, that.waitingAnomalyJobs) && Objects.equals(this.waitingModels, that.waitingModels) && Objects.equals(this.passedConfiguration, that.passedConfiguration) && Objects.equals(this.largestWaitingAnalyticsJob, that.largestWaitingAnalyticsJob) && Objects.equals(this.largestWaitingAnomalyJob, that.largestWaitingAnomalyJob) && Objects.equals(this.currentMlCapacity, that.currentMlCapacity) && Objects.equals(this.requiredCapacity, that.requiredCapacity) && Objects.equals(this.simpleReason, that.simpleReason);
    }

    public int hashCode() {
        return Objects.hash(this.waitingAnalyticsJobs, this.waitingAnomalyJobs, this.passedConfiguration, this.largestWaitingAnalyticsJob, this.waitingModels, this.largestWaitingAnomalyJob, this.currentMlCapacity, this.requiredCapacity, this.simpleReason);
    }

    public String summary() {
        return this.simpleReason;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.waitingAnalyticsJobs);
        out.writeStringCollection(this.waitingAnomalyJobs);
        if (out.getVersion().onOrAfter(Version.V_8_0_0)) {
            out.writeStringCollection(this.waitingModels);
        }
        Settings.writeSettingsToStream((Settings)this.passedConfiguration, (StreamOutput)out);
        this.currentMlCapacity.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.requiredCapacity);
        out.writeOptionalVLong(this.largestWaitingAnalyticsJob);
        out.writeOptionalVLong(this.largestWaitingAnomalyJob);
        out.writeString(this.simpleReason);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(WAITING_ANALYTICS_JOBS, this.waitingAnalyticsJobs);
        builder.field(WAITING_ANOMALY_JOBS, this.waitingAnomalyJobs);
        builder.field(WAITING_MODELS, this.waitingModels);
        builder.startObject(CONFIGURATION).value((Object)this.passedConfiguration).endObject();
        if (this.largestWaitingAnalyticsJob != null) {
            builder.field(LARGEST_WAITING_ANALYTICS_JOB, this.largestWaitingAnalyticsJob);
        }
        if (this.largestWaitingAnomalyJob != null) {
            builder.field(LARGEST_WAITING_ANOMALY_JOB, this.largestWaitingAnomalyJob);
        }
        builder.field(CURRENT_CAPACITY, (ToXContent)this.currentMlCapacity);
        if (this.requiredCapacity != null) {
            builder.field(REQUIRED_CAPACITY, (ToXContent)this.requiredCapacity);
        }
        builder.field(REASON, this.simpleReason);
        builder.endObject();
        return builder;
    }

    public boolean isFragment() {
        return false;
    }

    static class Builder {
        private List<String> waitingAnalyticsJobs = Collections.emptyList();
        private List<String> waitingAnomalyJobs = Collections.emptyList();
        private List<String> waitingModels = Collections.emptyList();
        private Settings passedConfiguration;
        private Long largestWaitingAnalyticsJob;
        private Long largestWaitingAnomalyJob;
        private AutoscalingCapacity currentMlCapacity;
        private AutoscalingCapacity requiredCapacity;
        private String simpleReason;

        Builder() {
        }

        public Builder setWaitingAnalyticsJobs(List<String> waitingAnalyticsJobs) {
            this.waitingAnalyticsJobs = waitingAnalyticsJobs;
            return this;
        }

        public Builder setWaitingAnomalyJobs(List<String> waitingAnomalyJobs) {
            this.waitingAnomalyJobs = waitingAnomalyJobs;
            return this;
        }

        public Builder setWaitingModels(List<String> waitingModels) {
            this.waitingModels = waitingModels;
            return this;
        }

        public Builder setPassedConfiguration(Settings passedConfiguration) {
            this.passedConfiguration = passedConfiguration;
            return this;
        }

        public Builder setLargestWaitingAnalyticsJob(Long largestWaitingAnalyticsJob) {
            this.largestWaitingAnalyticsJob = largestWaitingAnalyticsJob;
            return this;
        }

        public Builder setLargestWaitingAnomalyJob(Long largestWaitingAnomalyJob) {
            this.largestWaitingAnomalyJob = largestWaitingAnomalyJob;
            return this;
        }

        public Builder setCurrentMlCapacity(AutoscalingCapacity currentMlCapacity) {
            this.currentMlCapacity = currentMlCapacity;
            return this;
        }

        public Builder setSimpleReason(String simpleReason) {
            this.simpleReason = simpleReason;
            return this;
        }

        public Builder setRequiredCapacity(AutoscalingCapacity requiredCapacity) {
            this.requiredCapacity = requiredCapacity;
            return this;
        }

        public MlScalingReason build() {
            return new MlScalingReason(this.waitingAnalyticsJobs, this.waitingAnomalyJobs, this.waitingModels, this.passedConfiguration, this.largestWaitingAnalyticsJob, this.largestWaitingAnomalyJob, this.currentMlCapacity, this.requiredCapacity, this.simpleReason);
        }
    }
}

