/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesAction;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.action.PreviewDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.ChunkingConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.utils.SecondaryAuthorizationUtils;

public class TransportPreviewDatafeedAction
extends HandledTransportAction<PreviewDatafeedAction.Request, PreviewDatafeedAction.Response> {
    private final ThreadPool threadPool;
    private final Client client;
    private final JobConfigProvider jobConfigProvider;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final NamedXContentRegistry xContentRegistry;
    private final SecurityContext securityContext;

    @Inject
    public TransportPreviewDatafeedAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, Client client, JobConfigProvider jobConfigProvider, DatafeedConfigProvider datafeedConfigProvider, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/ml/datafeeds/preview", transportService, actionFilters, PreviewDatafeedAction.Request::new);
        this.threadPool = threadPool;
        this.client = client;
        this.jobConfigProvider = jobConfigProvider;
        this.datafeedConfigProvider = datafeedConfigProvider;
        this.xContentRegistry = xContentRegistry;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
    }

    protected void doExecute(Task task, PreviewDatafeedAction.Request request, ActionListener<PreviewDatafeedAction.Response> listener) {
        ActionListener datafeedConfigActionListener = ActionListener.wrap(datafeedConfig -> {
            if (request.getJobConfig() != null) {
                this.previewDatafeed((DatafeedConfig)datafeedConfig, request.getJobConfig().build(new Date()), listener);
                return;
            }
            this.jobConfigProvider.getJob(datafeedConfig.getJobId(), (ActionListener<Job.Builder>)ActionListener.wrap(jobBuilder -> this.previewDatafeed((DatafeedConfig)datafeedConfig, jobBuilder.build(), listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0));
        if (request.getDatafeedConfig() != null) {
            datafeedConfigActionListener.onResponse((Object)request.getDatafeedConfig());
        } else {
            this.datafeedConfigProvider.getDatafeedConfig(request.getDatafeedId(), (ActionListener<DatafeedConfig.Builder>)ActionListener.wrap(builder -> datafeedConfigActionListener.onResponse((Object)builder.build()), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void previewDatafeed(DatafeedConfig datafeedConfig, Job job, ActionListener<PreviewDatafeedAction.Response> listener) {
        DatafeedConfig.Builder previewDatafeedBuilder = TransportPreviewDatafeedAction.buildPreviewDatafeed(datafeedConfig);
        SecondaryAuthorizationUtils.useSecondaryAuthIfAvailable(this.securityContext, () -> {
            previewDatafeedBuilder.setHeaders(ClientHelper.filterSecurityHeaders((Map)this.threadPool.getThreadContext().getHeaders()));
            DatafeedConfig previewDatafeedConfig = previewDatafeedBuilder.build();
            DataExtractorFactory.create(this.client, previewDatafeedConfig, job, this.xContentRegistry, new DatafeedTimingStatsReporter(new DatafeedTimingStats(datafeedConfig.getJobId()), (ts, refreshPolicy) -> {}), (ActionListener<DataExtractorFactory>)listener.delegateFailure((l, dataExtractorFactory) -> this.isDateNanos(previewDatafeedConfig.getHeaders(), job.getDataDescription().getTimeField(), (ActionListener<Boolean>)listener.delegateFailure((l2, isDateNanos) -> {
                DataExtractor dataExtractor = dataExtractorFactory.newExtractor(0L, isDateNanos != false ? DateUtils.MAX_NANOSECOND_INSTANT.toEpochMilli() : Long.MAX_VALUE);
                this.threadPool.generic().execute(() -> TransportPreviewDatafeedAction.previewDatafeed(dataExtractor, (ActionListener<PreviewDatafeedAction.Response>)l));
            }))));
        });
    }

    static DatafeedConfig.Builder buildPreviewDatafeed(DatafeedConfig datafeed) {
        DatafeedConfig.Builder previewDatafeed = new DatafeedConfig.Builder(datafeed);
        if (!datafeed.hasAggregations()) {
            previewDatafeed.setChunkingConfig(ChunkingConfig.newAuto());
        }
        return previewDatafeed;
    }

    private void isDateNanos(Map<String, String> headers, String timeField, ActionListener<Boolean> listener) {
        ClientHelper.executeWithHeadersAsync(headers, (String)"ml", (Client)this.client, (ActionType)FieldCapabilitiesAction.INSTANCE, (ActionRequest)new FieldCapabilitiesRequest().fields(new String[]{timeField}), (ActionListener)ActionListener.wrap(fieldCapsResponse -> {
            Map timeFieldCaps = fieldCapsResponse.getField(timeField);
            listener.onResponse((Object)timeFieldCaps.keySet().contains("date_nanos"));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void previewDatafeed(DataExtractor dataExtractor, ActionListener<PreviewDatafeedAction.Response> listener) {
        try {
            Optional inputStream = dataExtractor.next();
            StringBuilder responseBuilder = new StringBuilder("[");
            if (inputStream.isPresent()) {
                try (BufferedReader buffer = new BufferedReader(new InputStreamReader((InputStream)inputStream.get(), StandardCharsets.UTF_8));){
                    responseBuilder.append(buffer.lines().collect(Collectors.joining(" ")).replace("} {", "},{"));
                }
            }
            responseBuilder.append("]");
            listener.onResponse((Object)new PreviewDatafeedAction.Response((BytesReference)new BytesArray(responseBuilder.toString().getBytes(StandardCharsets.UTF_8))));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
        finally {
            dataExtractor.cancel();
        }
    }
}

