/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.toxcontent;

import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.lookup.PainlessCast;
import org.elasticsearch.painless.lookup.PainlessClassBinding;
import org.elasticsearch.painless.lookup.PainlessConstructor;
import org.elasticsearch.painless.lookup.PainlessField;
import org.elasticsearch.painless.lookup.PainlessInstanceBinding;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.spi.annotation.CompileTimeOnlyAnnotation;
import org.elasticsearch.painless.spi.annotation.DeprecatedAnnotation;
import org.elasticsearch.painless.spi.annotation.InjectConstantAnnotation;
import org.elasticsearch.painless.spi.annotation.NoImportAnnotation;
import org.elasticsearch.painless.spi.annotation.NonDeterministicAnnotation;
import org.elasticsearch.painless.symbol.Decorations;
import org.elasticsearch.painless.symbol.Decorator;
import org.elasticsearch.painless.symbol.FunctionTable;
import org.elasticsearch.painless.symbol.SemanticScope;
import org.elasticsearch.painless.toxcontent.XContentBuilderWrapper;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class DecorationToXContent {
    public static void ToXContent(Decorations.TargetType targetType, XContentBuilderWrapper builder) {
        DecorationToXContent.start(targetType, builder);
        builder.field("type", targetType.getTargetType().getSimpleName());
        builder.endObject();
    }

    public static void ToXContent(Decorations.ValueType valueType, XContentBuilderWrapper builder) {
        DecorationToXContent.start(valueType, builder);
        builder.field("type", valueType.getValueType().getSimpleName());
        builder.endObject();
    }

    public static void ToXContent(Decorations.StaticType staticType, XContentBuilderWrapper builder) {
        DecorationToXContent.start(staticType, builder);
        builder.field("type", staticType.getStaticType().getSimpleName());
        builder.endObject();
    }

    public static void ToXContent(Decorations.PartialCanonicalTypeName partialCanonicalTypeName, XContentBuilderWrapper builder) {
        DecorationToXContent.start(partialCanonicalTypeName, builder);
        builder.field("type", partialCanonicalTypeName.getPartialCanonicalTypeName());
        builder.endObject();
    }

    public static void ToXContent(Decorations.ExpressionPainlessCast expressionPainlessCast, XContentBuilderWrapper builder) {
        DecorationToXContent.start(expressionPainlessCast, builder);
        builder.field("cast");
        DecorationToXContent.ToXContent(expressionPainlessCast.getExpressionPainlessCast(), builder);
        builder.endObject();
    }

    public static void ToXContent(Decorations.SemanticVariable semanticVariable, XContentBuilderWrapper builder) {
        DecorationToXContent.start(semanticVariable, builder);
        builder.field("variable");
        DecorationToXContent.ToXContent(semanticVariable.getSemanticVariable(), builder);
        builder.endObject();
    }

    public static void ToXContent(Decorations.IterablePainlessMethod iterablePainlessMethod, XContentBuilderWrapper builder) {
        DecorationToXContent.start(iterablePainlessMethod, builder);
        builder.field("method");
        DecorationToXContent.ToXContent(iterablePainlessMethod.getIterablePainlessMethod(), builder);
        builder.endObject();
    }

    public static void ToXContent(Decorations.UnaryType unaryType, XContentBuilderWrapper builder) {
        DecorationToXContent.start(unaryType, builder);
        builder.field("type", unaryType.getUnaryType().getSimpleName());
        builder.endObject();
    }

    public static void ToXContent(Decorations.BinaryType binaryType, XContentBuilderWrapper builder) {
        DecorationToXContent.start(binaryType, builder);
        builder.field("type", binaryType.getBinaryType().getSimpleName());
        builder.endObject();
    }

    public static void ToXContent(Decorations.ShiftType shiftType, XContentBuilderWrapper builder) {
        DecorationToXContent.start(shiftType, builder);
        builder.field("type", shiftType.getShiftType().getSimpleName());
        builder.endObject();
    }

    public static void ToXContent(Decorations.ComparisonType comparisonType, XContentBuilderWrapper builder) {
        DecorationToXContent.start(comparisonType, builder);
        builder.field("type", comparisonType.getComparisonType().getSimpleName());
        builder.endObject();
    }

    public static void ToXContent(Decorations.CompoundType compoundType, XContentBuilderWrapper builder) {
        DecorationToXContent.start(compoundType, builder);
        builder.field("type", compoundType.getCompoundType().getSimpleName());
        builder.endObject();
    }

    public static void ToXContent(Decorations.UpcastPainlessCast upcastPainlessCast, XContentBuilderWrapper builder) {
        DecorationToXContent.start(upcastPainlessCast, builder);
        builder.field("cast");
        DecorationToXContent.ToXContent(upcastPainlessCast.getUpcastPainlessCast(), builder);
        builder.endObject();
    }

    public static void ToXContent(Decorations.DowncastPainlessCast downcastPainlessCast, XContentBuilderWrapper builder) {
        DecorationToXContent.start(downcastPainlessCast, builder);
        builder.field("cast");
        DecorationToXContent.ToXContent(downcastPainlessCast.getDowncastPainlessCast(), builder);
        builder.endObject();
    }

    public static void ToXContent(Decorations.StandardPainlessField standardPainlessField, XContentBuilderWrapper builder) {
        DecorationToXContent.start(standardPainlessField, builder);
        builder.field("field");
        DecorationToXContent.ToXContent(standardPainlessField.getStandardPainlessField(), builder);
        builder.endObject();
    }

    public static void ToXContent(Decorations.StandardPainlessConstructor standardPainlessConstructor, XContentBuilderWrapper builder) {
        DecorationToXContent.start(standardPainlessConstructor, builder);
        builder.field("constructor");
        DecorationToXContent.ToXContent(standardPainlessConstructor.getStandardPainlessConstructor(), builder);
        builder.endObject();
    }

    public static void ToXContent(Decorations.StandardPainlessMethod standardPainlessMethod, XContentBuilderWrapper builder) {
        DecorationToXContent.start(standardPainlessMethod, builder);
        builder.field("method");
        DecorationToXContent.ToXContent(standardPainlessMethod.getStandardPainlessMethod(), builder);
        builder.endObject();
    }

    public static void ToXContent(Decorations.GetterPainlessMethod getterPainlessMethod, XContentBuilderWrapper builder) {
        DecorationToXContent.start(getterPainlessMethod, builder);
        builder.field("method");
        DecorationToXContent.ToXContent(getterPainlessMethod.getGetterPainlessMethod(), builder);
        builder.endObject();
    }

    public static void ToXContent(Decorations.SetterPainlessMethod setterPainlessMethod, XContentBuilderWrapper builder) {
        DecorationToXContent.start(setterPainlessMethod, builder);
        builder.field("method");
        DecorationToXContent.ToXContent(setterPainlessMethod.getSetterPainlessMethod(), builder);
        builder.endObject();
    }

    public static void ToXContent(Decorations.StandardConstant standardConstant, XContentBuilderWrapper builder) {
        DecorationToXContent.start(standardConstant, builder);
        builder.startObject("constant");
        builder.field("type", standardConstant.getStandardConstant().getClass().getSimpleName());
        builder.field("value", standardConstant.getStandardConstant());
        builder.endObject();
        builder.endObject();
    }

    public static void ToXContent(Decorations.StandardLocalFunction standardLocalFunction, XContentBuilderWrapper builder) {
        DecorationToXContent.start(standardLocalFunction, builder);
        builder.field("function");
        DecorationToXContent.ToXContent(standardLocalFunction.getLocalFunction(), builder);
        builder.endObject();
    }

    public static void ToXContent(Decorations.StandardPainlessClassBinding standardPainlessClassBinding, XContentBuilderWrapper builder) {
        DecorationToXContent.start(standardPainlessClassBinding, builder);
        builder.field("PainlessClassBinding");
        DecorationToXContent.ToXContent(standardPainlessClassBinding.getPainlessClassBinding(), builder);
        builder.endObject();
    }

    public static void ToXContent(Decorations.StandardPainlessInstanceBinding standardPainlessInstanceBinding, XContentBuilderWrapper builder) {
        DecorationToXContent.start(standardPainlessInstanceBinding, builder);
        builder.field("PainlessInstanceBinding");
        DecorationToXContent.ToXContent(standardPainlessInstanceBinding.getPainlessInstanceBinding(), builder);
        builder.endObject();
    }

    public static void ToXContent(Decorations.MethodNameDecoration methodNameDecoration, XContentBuilderWrapper builder) {
        DecorationToXContent.start(methodNameDecoration, builder);
        builder.field("methodName", methodNameDecoration.getMethodName());
        builder.endObject();
    }

    public static void ToXContent(Decorations.ReturnType returnType, XContentBuilderWrapper builder) {
        DecorationToXContent.start(returnType, builder);
        builder.field("returnType", returnType.getReturnType().getSimpleName());
        builder.endObject();
    }

    public static void ToXContent(Decorations.TypeParameters typeParameters, XContentBuilderWrapper builder) {
        DecorationToXContent.start(typeParameters, builder);
        if (!typeParameters.getTypeParameters().isEmpty()) {
            builder.field("typeParameters", DecorationToXContent.classNames(typeParameters.getTypeParameters()));
        }
        builder.endObject();
    }

    public static void ToXContent(Decorations.ParameterNames parameterNames, XContentBuilderWrapper builder) {
        DecorationToXContent.start(parameterNames, builder);
        if (!parameterNames.getParameterNames().isEmpty()) {
            builder.field("parameterNames", parameterNames.getParameterNames());
        }
        builder.endObject();
    }

    public static void ToXContent(Decorations.ReferenceDecoration referenceDecoration, XContentBuilderWrapper builder) {
        DecorationToXContent.start(referenceDecoration, builder);
        FunctionRef ref = referenceDecoration.getReference();
        builder.field("interfaceMethodName", ref.interfaceMethodName);
        builder.field("interfaceMethodType");
        DecorationToXContent.ToXContent(ref.interfaceMethodType, builder);
        builder.field("delegateClassName", ref.delegateClassName);
        builder.field("isDelegateInterface", ref.isDelegateInterface);
        builder.field("isDelegateAugmented", ref.isDelegateAugmented);
        builder.field("delegateInvokeType", ref.delegateInvokeType);
        builder.field("delegateMethodName", ref.delegateMethodName);
        builder.field("delegateMethodType");
        DecorationToXContent.ToXContent(ref.delegateMethodType, builder);
        if (ref.delegateInjections.length > 0) {
            builder.startArray("delegateInjections");
            for (Object obj : ref.delegateInjections) {
                builder.startObject();
                builder.field("type", obj.getClass().getSimpleName());
                builder.field("value", obj);
                builder.endObject();
            }
            builder.endArray();
        }
        builder.field("factoryMethodDescriptor", ref.getFactoryMethodDescriptor());
        builder.endObject();
    }

    public static void ToXContent(Decorations.EncodingDecoration encodingDecoration, XContentBuilderWrapper builder) {
        DecorationToXContent.start(encodingDecoration, builder);
        builder.field("encoding", encodingDecoration.getEncoding());
        builder.endObject();
    }

    public static void ToXContent(Decorations.CapturesDecoration capturesDecoration, XContentBuilderWrapper builder) {
        DecorationToXContent.start(capturesDecoration, builder);
        if (!capturesDecoration.getCaptures().isEmpty()) {
            builder.startArray("captures");
            for (SemanticScope.Variable capture : capturesDecoration.getCaptures()) {
                DecorationToXContent.ToXContent(capture, builder);
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public static void ToXContent(Decorations.InstanceType instanceType, XContentBuilderWrapper builder) {
        DecorationToXContent.start(instanceType, builder);
        builder.field("instanceType", instanceType.getInstanceType().getSimpleName());
        builder.endObject();
    }

    public static void ToXContent(Decorations.AccessDepth accessDepth, XContentBuilderWrapper builder) {
        DecorationToXContent.start(accessDepth, builder);
        builder.field("depth", accessDepth.getAccessDepth());
        builder.endObject();
    }

    public static void ToXContent(Decorations.IRNodeDecoration irNodeDecoration, XContentBuilderWrapper builder) {
        DecorationToXContent.start(irNodeDecoration, builder);
        builder.field("irNode", irNodeDecoration.getIRNode().toString());
        builder.endObject();
    }

    public static void ToXContent(Decorations.Converter converter, XContentBuilderWrapper builder) {
        DecorationToXContent.start(converter, builder);
        builder.field("converter");
        DecorationToXContent.ToXContent(converter.getConverter(), builder);
        builder.endObject();
    }

    public static void ToXContent(Decorator.Decoration decoration, XContentBuilderWrapper builder) {
        if (decoration instanceof Decorations.TargetType) {
            DecorationToXContent.ToXContent((Decorations.TargetType)decoration, builder);
        } else if (decoration instanceof Decorations.ValueType) {
            DecorationToXContent.ToXContent((Decorations.ValueType)decoration, builder);
        } else if (decoration instanceof Decorations.StaticType) {
            DecorationToXContent.ToXContent((Decorations.StaticType)decoration, builder);
        } else if (decoration instanceof Decorations.PartialCanonicalTypeName) {
            DecorationToXContent.ToXContent((Decorations.PartialCanonicalTypeName)decoration, builder);
        } else if (decoration instanceof Decorations.ExpressionPainlessCast) {
            DecorationToXContent.ToXContent((Decorations.ExpressionPainlessCast)decoration, builder);
        } else if (decoration instanceof Decorations.SemanticVariable) {
            DecorationToXContent.ToXContent((Decorations.SemanticVariable)decoration, builder);
        } else if (decoration instanceof Decorations.IterablePainlessMethod) {
            DecorationToXContent.ToXContent((Decorations.IterablePainlessMethod)decoration, builder);
        } else if (decoration instanceof Decorations.UnaryType) {
            DecorationToXContent.ToXContent((Decorations.UnaryType)decoration, builder);
        } else if (decoration instanceof Decorations.BinaryType) {
            DecorationToXContent.ToXContent((Decorations.BinaryType)decoration, builder);
        } else if (decoration instanceof Decorations.ShiftType) {
            DecorationToXContent.ToXContent((Decorations.ShiftType)decoration, builder);
        } else if (decoration instanceof Decorations.ComparisonType) {
            DecorationToXContent.ToXContent((Decorations.ComparisonType)decoration, builder);
        } else if (decoration instanceof Decorations.CompoundType) {
            DecorationToXContent.ToXContent((Decorations.CompoundType)decoration, builder);
        } else if (decoration instanceof Decorations.UpcastPainlessCast) {
            DecorationToXContent.ToXContent((Decorations.UpcastPainlessCast)decoration, builder);
        } else if (decoration instanceof Decorations.DowncastPainlessCast) {
            DecorationToXContent.ToXContent((Decorations.DowncastPainlessCast)decoration, builder);
        } else if (decoration instanceof Decorations.StandardPainlessField) {
            DecorationToXContent.ToXContent((Decorations.StandardPainlessField)decoration, builder);
        } else if (decoration instanceof Decorations.StandardPainlessConstructor) {
            DecorationToXContent.ToXContent((Decorations.StandardPainlessConstructor)decoration, builder);
        } else if (decoration instanceof Decorations.StandardPainlessMethod) {
            DecorationToXContent.ToXContent((Decorations.StandardPainlessMethod)decoration, builder);
        } else if (decoration instanceof Decorations.GetterPainlessMethod) {
            DecorationToXContent.ToXContent((Decorations.GetterPainlessMethod)decoration, builder);
        } else if (decoration instanceof Decorations.SetterPainlessMethod) {
            DecorationToXContent.ToXContent((Decorations.SetterPainlessMethod)decoration, builder);
        } else if (decoration instanceof Decorations.StandardConstant) {
            DecorationToXContent.ToXContent((Decorations.StandardConstant)decoration, builder);
        } else if (decoration instanceof Decorations.StandardLocalFunction) {
            DecorationToXContent.ToXContent((Decorations.StandardLocalFunction)decoration, builder);
        } else if (decoration instanceof Decorations.StandardPainlessClassBinding) {
            DecorationToXContent.ToXContent((Decorations.StandardPainlessClassBinding)decoration, builder);
        } else if (decoration instanceof Decorations.StandardPainlessInstanceBinding) {
            DecorationToXContent.ToXContent((Decorations.StandardPainlessInstanceBinding)decoration, builder);
        } else if (decoration instanceof Decorations.MethodNameDecoration) {
            DecorationToXContent.ToXContent((Decorations.MethodNameDecoration)decoration, builder);
        } else if (decoration instanceof Decorations.ReturnType) {
            DecorationToXContent.ToXContent((Decorations.ReturnType)decoration, builder);
        } else if (decoration instanceof Decorations.TypeParameters) {
            DecorationToXContent.ToXContent((Decorations.TypeParameters)decoration, builder);
        } else if (decoration instanceof Decorations.ParameterNames) {
            DecorationToXContent.ToXContent((Decorations.ParameterNames)decoration, builder);
        } else if (decoration instanceof Decorations.ReferenceDecoration) {
            DecorationToXContent.ToXContent((Decorations.ReferenceDecoration)decoration, builder);
        } else if (decoration instanceof Decorations.EncodingDecoration) {
            DecorationToXContent.ToXContent((Decorations.EncodingDecoration)decoration, builder);
        } else if (decoration instanceof Decorations.CapturesDecoration) {
            DecorationToXContent.ToXContent((Decorations.CapturesDecoration)decoration, builder);
        } else if (decoration instanceof Decorations.InstanceType) {
            DecorationToXContent.ToXContent((Decorations.InstanceType)decoration, builder);
        } else if (decoration instanceof Decorations.AccessDepth) {
            DecorationToXContent.ToXContent((Decorations.AccessDepth)decoration, builder);
        } else if (decoration instanceof Decorations.IRNodeDecoration) {
            DecorationToXContent.ToXContent((Decorations.IRNodeDecoration)decoration, builder);
        } else if (decoration instanceof Decorations.Converter) {
            DecorationToXContent.ToXContent((Decorations.Converter)decoration, builder);
        } else {
            builder.startObject();
            builder.field("decoration", decoration.getClass().getSimpleName());
            builder.endObject();
        }
    }

    public static void ToXContent(PainlessCast painlessCast, XContentBuilderWrapper builder) {
        builder.startObject();
        if (painlessCast.originalType != null) {
            builder.field("originalType", painlessCast.originalType.getSimpleName());
        }
        if (painlessCast.targetType != null) {
            builder.field("targetType", painlessCast.targetType.getSimpleName());
        }
        builder.field("explicitCast", painlessCast.explicitCast);
        if (painlessCast.unboxOriginalType != null) {
            builder.field("unboxOriginalType", painlessCast.unboxOriginalType.getSimpleName());
        }
        if (painlessCast.unboxTargetType != null) {
            builder.field("unboxTargetType", painlessCast.unboxTargetType.getSimpleName());
        }
        if (painlessCast.boxOriginalType != null) {
            builder.field("boxOriginalType", painlessCast.boxOriginalType.getSimpleName());
        }
        builder.endObject();
    }

    public static void ToXContent(PainlessMethod method, XContentBuilderWrapper builder) {
        builder.startObject();
        if (method.javaMethod != null) {
            builder.field("javaMethod");
            DecorationToXContent.ToXContent(method.methodType, builder);
        }
        if (method.targetClass != null) {
            builder.field("targetClass", method.targetClass.getSimpleName());
        }
        if (method.returnType != null) {
            builder.field("returnType", method.returnType.getSimpleName());
        }
        if (method.typeParameters != null && !method.typeParameters.isEmpty()) {
            builder.field("typeParameters", DecorationToXContent.classNames(method.typeParameters));
        }
        if (method.methodHandle != null) {
            builder.field("methodHandle");
            DecorationToXContent.ToXContent(method.methodHandle.type(), builder);
        }
        DecorationToXContent.AnnotationsToXContent(method.annotations, builder);
        builder.endObject();
    }

    public static void ToXContent(FunctionTable.LocalFunction localFunction, XContentBuilderWrapper builder) {
        builder.startObject();
        builder.field("mangledName", localFunction.getMangledName());
        builder.field("returnType", localFunction.getReturnType().getSimpleName());
        if (!localFunction.getTypeParameters().isEmpty()) {
            builder.field("typeParameters", DecorationToXContent.classNames(localFunction.getTypeParameters()));
        }
        builder.field("isInternal", localFunction.isInternal());
        builder.field("isStatic", localFunction.isStatic());
        builder.field("methodType");
        DecorationToXContent.ToXContent(localFunction.getMethodType(), builder);
        builder.endObject();
    }

    public static void ToXContent(PainlessClassBinding binding, XContentBuilderWrapper builder) {
        builder.startObject();
        builder.field("javaConstructor");
        DecorationToXContent.ToXContent(binding.javaConstructor, builder);
        builder.field("javaMethod");
        DecorationToXContent.ToXContent(binding.javaMethod, builder);
        builder.field("returnType", binding.returnType.getSimpleName());
        if (!binding.typeParameters.isEmpty()) {
            builder.field("typeParameters", DecorationToXContent.classNames(binding.typeParameters));
        }
        DecorationToXContent.AnnotationsToXContent(binding.annotations, builder);
        builder.endObject();
    }

    public static void ToXContent(PainlessInstanceBinding binding, XContentBuilderWrapper builder) {
        builder.startObject();
        builder.field("targetInstance", binding.targetInstance.getClass().getSimpleName());
        builder.field("javaMethod");
        DecorationToXContent.ToXContent(binding.javaMethod, builder);
        builder.field("returnType", binding.returnType.getSimpleName());
        if (!binding.typeParameters.isEmpty()) {
            builder.field("typeParameters", DecorationToXContent.classNames(binding.typeParameters));
        }
        DecorationToXContent.AnnotationsToXContent(binding.annotations, builder);
        builder.endObject();
    }

    public static void ToXContent(PainlessField field, XContentBuilderWrapper builder) {
        builder.startObject();
        builder.field("javaField");
        DecorationToXContent.ToXContent(field.javaField, builder);
        builder.field("typeParameter", field.typeParameter.getSimpleName());
        builder.field("getterMethodHandle");
        DecorationToXContent.ToXContent(field.getterMethodHandle.type(), builder);
        builder.field("setterMethodHandle");
        if (field.setterMethodHandle != null) {
            DecorationToXContent.ToXContent(field.setterMethodHandle.type(), builder);
        }
        builder.endObject();
    }

    public static void ToXContent(PainlessConstructor constructor, XContentBuilderWrapper builder) {
        builder.startObject();
        builder.field("javaConstructor");
        DecorationToXContent.ToXContent(constructor.javaConstructor, builder);
        if (!constructor.typeParameters.isEmpty()) {
            builder.field("typeParameters", DecorationToXContent.classNames(constructor.typeParameters));
        }
        builder.field("methodHandle");
        DecorationToXContent.ToXContent(constructor.methodHandle.type(), builder);
        builder.endObject();
    }

    public static void ToXContent(SemanticScope.Variable variable, XContentBuilderWrapper builder) {
        builder.startObject();
        builder.field("type", variable.getType());
        builder.field("name", variable.getName());
        builder.field("isFinal", variable.isFinal());
        builder.endObject();
    }

    public static void AnnotationsToXContent(Map<Class<?>, Object> annotations, XContentBuilderWrapper builder) {
        if (annotations == null || annotations.isEmpty()) {
            return;
        }
        builder.startArray("annotations");
        for (Class key : annotations.keySet().stream().sorted().collect(Collectors.toList())) {
            DecorationToXContent.AnnotationToXContent(annotations.get(key), builder);
        }
        builder.endArray();
    }

    public static void AnnotationToXContent(Object annotation, XContentBuilderWrapper builder) {
        if (annotation instanceof CompileTimeOnlyAnnotation) {
            builder.value("compile_time_only");
        } else if (annotation instanceof DeprecatedAnnotation) {
            builder.startObject();
            builder.field("name", "deprecated");
            builder.field("message", ((DeprecatedAnnotation)annotation).getMessage());
            builder.endObject();
        } else if (annotation instanceof InjectConstantAnnotation) {
            builder.startObject();
            builder.field("name", "inject_constant");
            builder.field("message", ((InjectConstantAnnotation)annotation).injects);
            builder.endObject();
        } else if (annotation instanceof NoImportAnnotation) {
            builder.value("no_import");
        } else if (annotation instanceof NonDeterministicAnnotation) {
            builder.value("nondeterministic");
        } else {
            builder.value(annotation.toString());
        }
    }

    public static void ToXContent(Method asmMethod, XContentBuilderWrapper builder) {
        builder.startObject();
        builder.field("name", asmMethod.getName());
        builder.field("descriptor", asmMethod.getDescriptor());
        builder.field("returnType", asmMethod.getReturnType().getClassName());
        builder.field("argumentTypes", Arrays.stream(asmMethod.getArgumentTypes()).map(Type::getClassName));
        builder.endObject();
    }

    public static void ToXContent(MethodType methodType, XContentBuilderWrapper builder) {
        builder.startObject();
        List<Class<?>> parameters = methodType.parameterList();
        if (!parameters.isEmpty()) {
            builder.field("parameters", DecorationToXContent.classNames(parameters));
        }
        builder.field("return", ((Class)methodType.returnType()).getSimpleName());
        builder.endObject();
    }

    public static void ToXContent(Field field, XContentBuilderWrapper builder) {
        builder.startObject();
        builder.field("name", field.getName());
        builder.field("type", field.getType().getSimpleName());
        builder.field("modifiers", Modifier.toString(field.getModifiers()));
        builder.endObject();
    }

    public static void ToXContent(java.lang.reflect.Method method, XContentBuilderWrapper builder) {
        builder.startObject();
        builder.field("name", method.getName());
        builder.field("parameters", DecorationToXContent.classNames(method.getParameterTypes()));
        builder.field("return", method.getReturnType().getSimpleName());
        Class<?>[] exceptions = method.getExceptionTypes();
        if (exceptions.length > 0) {
            builder.field("exceptions", DecorationToXContent.classNames(exceptions));
        }
        builder.field("modifiers", Modifier.toString(method.getModifiers()));
        builder.endObject();
    }

    public static void ToXContent(Constructor<?> constructor, XContentBuilderWrapper builder) {
        builder.startObject();
        builder.field("name", constructor.getName());
        if (constructor.getParameterTypes().length > 0) {
            builder.field("parameterTypes", DecorationToXContent.classNames(constructor.getParameterTypes()));
        }
        if (constructor.getExceptionTypes().length > 0) {
            builder.field("exceptionTypes", DecorationToXContent.classNames(constructor.getExceptionTypes()));
        }
        builder.field("modifiers", Modifier.toString(constructor.getModifiers()));
        builder.endObject();
    }

    public static void start(Decorator.Decoration decoration, XContentBuilderWrapper builder) {
        builder.startObject();
        builder.field("decoration", decoration.getClass().getSimpleName());
    }

    public static List<String> classNames(Class<?>[] classes) {
        return Arrays.stream(classes).map(Class::getSimpleName).collect(Collectors.toList());
    }

    public static List<String> classNames(List<Class<?>> classes) {
        return classes.stream().map(Class::getSimpleName).collect(Collectors.toList());
    }

    static final class Fields {
        static final String DECORATION = "decoration";
        static final String TYPE = "type";
        static final String CAST = "cast";
        static final String METHOD = "method";

        Fields() {
        }
    }
}

