/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.xcontent.MediaType;
import org.elasticsearch.xcontent.MediaTypeRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.sql.action.SqlQueryAction;
import org.elasticsearch.xpack.sql.action.SqlQueryRequest;
import org.elasticsearch.xpack.sql.plugin.SqlMediaTypeParser;
import org.elasticsearch.xpack.sql.plugin.SqlResponseListener;

public class RestSqlQueryAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_sql"), new RestHandler.Route(RestRequest.Method.POST, "/_sql"));
    }

    public MediaTypeRegistry<? extends MediaType> validAcceptMediaTypes() {
        return SqlMediaTypeParser.MEDIA_TYPE_REGISTRY;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SqlQueryRequest sqlRequest;
        try (XContentParser parser = request.contentOrSourceParamParser();){
            sqlRequest = SqlQueryRequest.fromXContent((XContentParser)parser);
        }
        return channel -> {
            RestCancellableNodeClient cancellableClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancellableClient.execute((ActionType)SqlQueryAction.INSTANCE, (ActionRequest)sqlRequest, (ActionListener)new SqlResponseListener((RestChannel)channel, request, sqlRequest));
        };
    }

    protected Set<String> responseParams() {
        return Collections.singleton("delimiter");
    }

    public String getName() {
        return "sql_query";
    }
}

