/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.timeseries.support;

import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.InternalComposite;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.metrics.InternalTopHits;
import org.elasticsearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class TimeSeriesMetrics {
    private static final Logger logger = LogManager.getLogger();
    private final int bucketBatchSize;
    private final int docBatchSize;
    private final Client client;
    private final String[] indices;
    private final List<String> dimensionFieldNames;

    TimeSeriesMetrics(int bucketBatchSize, int docBatchSize, Client client, String[] indices, List<String> dimensionFieldNames) {
        this.bucketBatchSize = bucketBatchSize;
        this.docBatchSize = docBatchSize;
        this.client = client;
        this.indices = indices;
        this.dimensionFieldNames = dimensionFieldNames;
    }

    public void latestInRange(String metric, TemporalAccessor from, TemporalAccessor to, MetricsCallback callback) {
        this.latestInRanage(metric, from, to, null, null, null, callback);
    }

    public void latestInRanges(String metric, TemporalAccessor from, TemporalAccessor to, DateHistogramInterval step, MetricsCallback callback) {
        this.latestInRanage(metric, from, to, step, null, null, callback);
    }

    private void latestInRanage(String metric, TemporalAccessor from, TemporalAccessor to, @Nullable DateHistogramInterval step, @Nullable Map<String, Object> afterKey, @Nullable Map<String, Object> previousTimeSeries, MetricsCallback callback) {
        SearchRequest search = this.searchInRange(from, to);
        search.source().size(0);
        search.source().trackTotalHits(false);
        search.source().aggregation(this.timeSeriesComposite(step, afterKey).subAggregation(this.latestMetric(metric)));
        logger.debug("Requesting batch of latest {}", (Object)search);
        this.client.search(search, ActionListener.wrap(new LatestInRangeResponseHandler(metric, callback, from, to, step, search, previousTimeSeries), callback::onError));
    }

    private SearchRequest searchInRange(TemporalAccessor from, TemporalAccessor to) {
        SearchRequest search = new SearchRequest(this.indices);
        search.source().query(new RangeQueryBuilder("@timestamp").format(DateFieldMapper.DEFAULT_DATE_TIME_NANOS_FORMATTER.pattern()).gt(DateFieldMapper.DEFAULT_DATE_TIME_NANOS_FORMATTER.format(from)).lte(DateFieldMapper.DEFAULT_DATE_TIME_NANOS_FORMATTER.format(to)));
        return search;
    }

    private CompositeAggregationBuilder timeSeriesComposite(@Nullable DateHistogramInterval step, @Nullable Map<String, Object> afterKey) {
        Stream<CompositeValuesSourceBuilder> sources = this.dimensionFieldNames.stream().map(d -> ((TermsValuesSourceBuilder)new TermsValuesSourceBuilder((String)d).field((String)d)).missingBucket(true));
        if (step != null) {
            sources = Stream.concat(sources, Stream.of(((DateHistogramValuesSourceBuilder)new DateHistogramValuesSourceBuilder("@timestamp").field("@timestamp")).fixedInterval(step).offset(1L)));
        }
        return new CompositeAggregationBuilder("time_series", sources.collect(Collectors.toList())).aggregateAfter(afterKey).size(this.bucketBatchSize);
    }

    private TopHitsAggregationBuilder latestMetric(String metric) {
        return new TopHitsAggregationBuilder("latest").sort((SortBuilder<?>)new FieldSortBuilder("@timestamp").order(SortOrder.DESC)).fetchField(metric).fetchField(new FieldAndFormat("@timestamp", "epoch_millis")).size(1);
    }

    public void valuesInRange(String metric, TemporalAccessor from, TemporalAccessor to, MetricsCallback listener) {
        this.valuesInRange(metric, from, to, null, null, listener);
    }

    private void valuesInRange(String metric, TemporalAccessor from, TemporalAccessor to, Object[] searchAfter, Map<String, Object> previousTimeSeries, MetricsCallback callback) {
        SearchRequest search = this.searchInRange(from, to);
        search.source().size(this.docBatchSize);
        search.source().trackTotalHits(false);
        List<SortBuilder<?>> sorts = Stream.concat(this.dimensionFieldNames.stream().map(d -> (FieldSortBuilder)new FieldSortBuilder((String)d).order(SortOrder.ASC)), Stream.of(((FieldSortBuilder)new FieldSortBuilder("@timestamp").order(SortOrder.ASC)).setFormat("epoch_millis"))).collect(Collectors.toList());
        search.source().sort(sorts);
        if (searchAfter != null) {
            search.source().searchAfter(searchAfter);
        }
        search.source().fetchField(metric);
        this.client.search(search, ActionListener.wrap(new ValuesInRangeResponseHandler(metric, callback, from, to, search, previousTimeSeries), callback::onError));
    }

    static interface MetricsCallback {
        public void onTimeSeriesStart(Map<String, Object> var1);

        public void onMetric(long var1, double var3);

        public void onSuccess();

        public void onError(Exception var1);
    }

    private class LatestInRangeResponseHandler
    implements CheckedConsumer<SearchResponse, RuntimeException> {
        private final String metric;
        private final MetricsCallback callback;
        private final TemporalAccessor from;
        private final TemporalAccessor to;
        @Nullable
        private final DateHistogramInterval step;
        private final SearchRequest search;
        private Map<String, Object> previousDimensions;

        LatestInRangeResponseHandler(String metric, MetricsCallback callback, TemporalAccessor from, @Nullable TemporalAccessor to, DateHistogramInterval step, @Nullable SearchRequest search, Map<String, Object> previousDimensions) {
            this.metric = metric;
            this.callback = callback;
            this.from = from;
            this.to = to;
            this.step = step;
            this.search = search;
            this.previousDimensions = previousDimensions;
        }

        public void accept(SearchResponse response) {
            InternalComposite composite = (InternalComposite)response.getAggregations().get("time_series");
            logger.debug("Received batch of latest {} with {} buckets", (Object)this.search, (Object)composite.getBuckets().size());
            for (InternalComposite.InternalBucket bucket : composite.getBuckets()) {
                DocumentField metricField;
                InternalTopHits latest;
                SearchHit[] hits;
                Map<String, Object> dimensions = bucket.getKey().entrySet().stream().filter(e -> false == ((String)e.getKey()).equals("@timestamp") && e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (!Objects.equals(this.previousDimensions, dimensions)) {
                    this.previousDimensions = dimensions;
                    this.callback.onTimeSeriesStart(dimensions);
                }
                if ((hits = (latest = (InternalTopHits)bucket.getAggregations().get("latest")).getHits().getHits()).length == 0 || (metricField = hits[0].field(this.metric)) == null) continue;
                long time = Long.parseLong((String)hits[0].field("@timestamp").getValue());
                double value = ((Number)metricField.getValue()).doubleValue();
                this.callback.onMetric(time, value);
            }
            if (composite.afterKey() == null) {
                this.callback.onSuccess();
            } else {
                TimeSeriesMetrics.this.latestInRanage(this.metric, this.from, this.to, this.step, composite.afterKey(), this.previousDimensions, this.callback);
            }
        }
    }

    private class ValuesInRangeResponseHandler
    implements CheckedConsumer<SearchResponse, RuntimeException> {
        private final String metric;
        private final MetricsCallback callback;
        private final TemporalAccessor from;
        private final TemporalAccessor to;
        private final SearchRequest search;
        private Map<String, Object> previousDimensions;

        ValuesInRangeResponseHandler(String metric, MetricsCallback callback, TemporalAccessor from, TemporalAccessor to, @Nullable SearchRequest search, Map<String, Object> previousDimensions) {
            this.metric = metric;
            this.callback = callback;
            this.from = from;
            this.to = to;
            this.search = search;
            this.previousDimensions = previousDimensions;
        }

        public void accept(SearchResponse response) {
            SearchHit[] hits;
            logger.debug("Received batch of values {} with {} docs", (Object)this.search, (Object)response.getHits().getHits().length);
            for (SearchHit hit : hits = response.getHits().getHits()) {
                DocumentField metricField;
                HashMap<String, Object> dimensions = new HashMap<String, Object>();
                for (int d = 0; d < TimeSeriesMetrics.this.dimensionFieldNames.size(); ++d) {
                    Object dimensionValue = hit.getSortValues()[d];
                    if (dimensionValue == null) continue;
                    dimensions.put(TimeSeriesMetrics.this.dimensionFieldNames.get(d), dimensionValue);
                }
                if (!Objects.equals(this.previousDimensions, dimensions)) {
                    this.previousDimensions = dimensions;
                    this.callback.onTimeSeriesStart(dimensions);
                }
                if ((metricField = hit.field(this.metric)) == null) continue;
                long time = Long.parseLong((String)hit.getSortValues()[TimeSeriesMetrics.this.dimensionFieldNames.size()]);
                double value = ((Number)metricField.getValue()).doubleValue();
                this.callback.onMetric(time, value);
            }
            if (hits.length < TimeSeriesMetrics.this.docBatchSize) {
                this.callback.onSuccess();
            } else {
                TimeSeriesMetrics.this.valuesInRange(this.metric, this.from, this.to, hits[hits.length - 1].getSortValues(), this.previousDimensions, this.callback);
            }
        }
    }
}

