/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.lucene.search.vectorhighlight.ScoreOrderFragmentsBuilder;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.fetch.subphase.highlight.FragmentBuilderHelper;
import org.elasticsearch.search.lookup.SourceLookup;

public class SourceScoreOrderFragmentsBuilder
extends ScoreOrderFragmentsBuilder {
    private final MappedFieldType fieldType;
    private final SourceLookup sourceLookup;
    private final boolean fixBrokenAnalysis;

    public SourceScoreOrderFragmentsBuilder(MappedFieldType fieldType, boolean fixBrokenAnalysis, SourceLookup sourceLookup, String[] preTags, String[] postTags, BoundaryScanner boundaryScanner) {
        super(preTags, postTags, boundaryScanner);
        this.fieldType = fieldType;
        this.sourceLookup = sourceLookup;
        this.fixBrokenAnalysis = fixBrokenAnalysis;
    }

    protected Field[] getFields(IndexReader reader, int docId, String fieldName) throws IOException {
        List<Object> values = this.sourceLookup.extractRawValues(this.fieldType.name());
        Field[] fields = new Field[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            fields[i] = new Field(this.fieldType.name(), (CharSequence)values.get(i).toString(), (IndexableFieldType)TextField.TYPE_NOT_STORED);
        }
        return fields;
    }

    protected String makeFragment(StringBuilder buffer, int[] index, Field[] values, FieldFragList.WeightedFragInfo fragInfo, String[] preTags, String[] postTags, Encoder encoder) {
        if (this.fixBrokenAnalysis) {
            fragInfo = FragmentBuilderHelper.fixWeightedFragInfo(fragInfo);
        }
        return super.makeFragment(buffer, index, values, fragInfo, preTags, postTags, encoder);
    }
}

