/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.script.FieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.TopHitsAggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class TopHitsAggregationBuilder
extends AbstractAggregationBuilder<TopHitsAggregationBuilder> {
    public static final String NAME = "top_hits";
    private int from = 0;
    private int size = 3;
    private boolean explain = false;
    private boolean version = false;
    private boolean seqNoAndPrimaryTerm = false;
    private boolean trackScores = false;
    private List<SortBuilder<?>> sorts = null;
    private HighlightBuilder highlightBuilder;
    private StoredFieldsContext storedFieldsContext;
    private List<FieldAndFormat> docValueFields;
    private List<FieldAndFormat> fetchFields;
    private Set<SearchSourceBuilder.ScriptField> scriptFields;
    private FetchSourceContext fetchSourceContext;

    public TopHitsAggregationBuilder(String name) {
        super(name);
    }

    protected TopHitsAggregationBuilder(TopHitsAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.from = clone.from;
        this.size = clone.size;
        this.explain = clone.explain;
        this.version = clone.version;
        this.seqNoAndPrimaryTerm = clone.seqNoAndPrimaryTerm;
        this.trackScores = clone.trackScores;
        this.sorts = clone.sorts == null ? null : new ArrayList(clone.sorts);
        this.highlightBuilder = clone.highlightBuilder == null ? null : new HighlightBuilder(clone.highlightBuilder, clone.highlightBuilder.highlightQuery(), clone.highlightBuilder.fields());
        this.storedFieldsContext = clone.storedFieldsContext == null ? null : new StoredFieldsContext(clone.storedFieldsContext);
        this.docValueFields = clone.docValueFields == null ? null : new ArrayList<FieldAndFormat>(clone.docValueFields);
        this.fetchFields = clone.fetchFields == null ? null : new ArrayList<FieldAndFormat>(clone.fetchFields);
        this.scriptFields = clone.scriptFields == null ? null : new HashSet<SearchSourceBuilder.ScriptField>(clone.scriptFields);
        this.fetchSourceContext = clone.fetchSourceContext == null ? null : new FetchSourceContext(clone.fetchSourceContext.fetchSource(), clone.fetchSourceContext.includes(), clone.fetchSourceContext.excludes());
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new TopHitsAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public TopHitsAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        int i;
        int size;
        this.explain = in.readBoolean();
        this.fetchSourceContext = in.readOptionalWriteable(FetchSourceContext::new);
        if (in.readBoolean()) {
            size = in.readVInt();
            this.docValueFields = new ArrayList<FieldAndFormat>(size);
            for (i = 0; i < size; ++i) {
                this.docValueFields.add(new FieldAndFormat(in));
            }
        }
        this.storedFieldsContext = in.readOptionalWriteable(StoredFieldsContext::new);
        this.from = in.readVInt();
        this.highlightBuilder = in.readOptionalWriteable(HighlightBuilder::new);
        if (in.readBoolean()) {
            size = in.readVInt();
            this.scriptFields = new HashSet<SearchSourceBuilder.ScriptField>(size);
            for (i = 0; i < size; ++i) {
                this.scriptFields.add(new SearchSourceBuilder.ScriptField(in));
            }
        }
        this.size = in.readVInt();
        if (in.readBoolean()) {
            size = in.readVInt();
            this.sorts = new ArrayList();
            for (i = 0; i < size; ++i) {
                this.sorts.add(in.readNamedWriteable(SortBuilder.class));
            }
        }
        this.trackScores = in.readBoolean();
        this.version = in.readBoolean();
        this.seqNoAndPrimaryTerm = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_7_10_0) && in.readBoolean()) {
            this.fetchFields = in.readList(FieldAndFormat::new);
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.explain);
        out.writeOptionalWriteable(this.fetchSourceContext);
        boolean hasFieldDataFields = this.docValueFields != null;
        out.writeBoolean(hasFieldDataFields);
        if (hasFieldDataFields) {
            out.writeList(this.docValueFields);
        }
        out.writeOptionalWriteable(this.storedFieldsContext);
        out.writeVInt(this.from);
        out.writeOptionalWriteable(this.highlightBuilder);
        boolean hasScriptFields = this.scriptFields != null;
        out.writeBoolean(hasScriptFields);
        if (hasScriptFields) {
            out.writeCollection(this.scriptFields);
        }
        out.writeVInt(this.size);
        boolean hasSorts = this.sorts != null;
        out.writeBoolean(hasSorts);
        if (hasSorts) {
            out.writeNamedWriteableList(this.sorts);
        }
        out.writeBoolean(this.trackScores);
        out.writeBoolean(this.version);
        out.writeBoolean(this.seqNoAndPrimaryTerm);
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            out.writeBoolean(this.fetchFields != null);
            if (this.fetchFields != null) {
                out.writeList(this.fetchFields);
            }
        }
    }

    public TopHitsAggregationBuilder from(int from) {
        if (from < 0) {
            throw new IllegalArgumentException("[from] must be greater than or equal to 0. Found [" + from + "] in [" + this.name + "]");
        }
        this.from = from;
        return this;
    }

    public int from() {
        return this.from;
    }

    public TopHitsAggregationBuilder size(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("[size] must be greater than or equal to 0. Found [" + size + "] in [" + this.name + "]");
        }
        this.size = size;
        return this;
    }

    public int size() {
        return this.size;
    }

    public TopHitsAggregationBuilder sort(String name, SortOrder order) {
        if (name == null) {
            throw new IllegalArgumentException("sort [name] must not be null: [" + name + "]");
        }
        if (order == null) {
            throw new IllegalArgumentException("sort [order] must not be null: [" + name + "]");
        }
        if (name.equals("_score")) {
            this.sort((SortBuilder<?>)SortBuilders.scoreSort().order(order));
        } else {
            this.sort((SortBuilder<?>)SortBuilders.fieldSort(name).order(order));
        }
        return this;
    }

    public TopHitsAggregationBuilder sort(String name) {
        if (name == null) {
            throw new IllegalArgumentException("sort [name] must not be null: [" + name + "]");
        }
        if (name.equals("_score")) {
            this.sort(SortBuilders.scoreSort());
        } else {
            this.sort(SortBuilders.fieldSort(name));
        }
        return this;
    }

    public TopHitsAggregationBuilder sort(SortBuilder<?> sort) {
        if (sort == null) {
            throw new IllegalArgumentException("[sort] must not be null: [" + this.name + "]");
        }
        if (this.sorts == null) {
            this.sorts = new ArrayList();
        }
        this.sorts.add(sort);
        return this;
    }

    public TopHitsAggregationBuilder sorts(List<SortBuilder<?>> sorts) {
        if (sorts == null) {
            throw new IllegalArgumentException("[sorts] must not be null: [" + this.name + "]");
        }
        if (this.sorts == null) {
            this.sorts = new ArrayList();
        }
        for (SortBuilder<?> sort : sorts) {
            this.sorts.add(sort);
        }
        return this;
    }

    public List<SortBuilder<?>> sorts() {
        return this.sorts;
    }

    public TopHitsAggregationBuilder highlighter(HighlightBuilder highlightBuilder) {
        if (highlightBuilder == null) {
            throw new IllegalArgumentException("[highlightBuilder] must not be null: [" + this.name + "]");
        }
        this.highlightBuilder = highlightBuilder;
        return this;
    }

    public HighlightBuilder highlighter() {
        return this.highlightBuilder;
    }

    public TopHitsAggregationBuilder fetchSource(boolean fetch) {
        FetchSourceContext fetchSourceContext = this.fetchSourceContext != null ? this.fetchSourceContext : FetchSourceContext.FETCH_SOURCE;
        this.fetchSourceContext = new FetchSourceContext(fetch, fetchSourceContext.includes(), fetchSourceContext.excludes());
        return this;
    }

    public TopHitsAggregationBuilder fetchSource(@Nullable String include, @Nullable String exclude) {
        String[] stringArray;
        String[] stringArray2;
        if (include == null) {
            stringArray2 = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = include;
        }
        if (exclude == null) {
            stringArray = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = exclude;
        }
        this.fetchSource(stringArray2, stringArray);
        return this;
    }

    public TopHitsAggregationBuilder fetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        FetchSourceContext fetchSourceContext = this.fetchSourceContext != null ? this.fetchSourceContext : FetchSourceContext.FETCH_SOURCE;
        this.fetchSourceContext = new FetchSourceContext(fetchSourceContext.fetchSource(), includes, excludes);
        return this;
    }

    public TopHitsAggregationBuilder fetchSource(@Nullable FetchSourceContext fetchSourceContext) {
        if (fetchSourceContext == null) {
            throw new IllegalArgumentException("[fetchSourceContext] must not be null: [" + this.name + "]");
        }
        this.fetchSourceContext = fetchSourceContext;
        return this;
    }

    public FetchSourceContext fetchSource() {
        return this.fetchSourceContext;
    }

    public TopHitsAggregationBuilder storedField(String field) {
        return this.storedFields(Collections.singletonList(field));
    }

    public TopHitsAggregationBuilder storedFields(List<String> fields) {
        if (fields == null) {
            throw new IllegalArgumentException("[fields] must not be null: [" + this.name + "]");
        }
        if (this.storedFieldsContext == null) {
            this.storedFieldsContext = StoredFieldsContext.fromList(fields);
        } else {
            this.storedFieldsContext.addFieldNames(fields);
        }
        return this;
    }

    public StoredFieldsContext storedFields() {
        return this.storedFieldsContext;
    }

    public TopHitsAggregationBuilder docValueField(String docValueField, String format) {
        if (docValueField == null) {
            throw new IllegalArgumentException("[docValueField] must not be null: [" + this.name + "]");
        }
        if (this.docValueFields == null) {
            this.docValueFields = new ArrayList<FieldAndFormat>();
        }
        this.docValueFields.add(new FieldAndFormat(docValueField, format));
        return this;
    }

    public TopHitsAggregationBuilder docValueField(String docValueField) {
        return this.docValueField(docValueField, null);
    }

    public List<FieldAndFormat> docValueFields() {
        return this.docValueFields;
    }

    public TopHitsAggregationBuilder fetchField(FieldAndFormat fieldAndFormat) {
        if (fieldAndFormat == null) {
            throw new IllegalArgumentException("[fields] must not be null: [" + this.name + "]");
        }
        if (this.fetchFields == null) {
            this.fetchFields = new ArrayList<FieldAndFormat>();
        }
        this.fetchFields.add(fieldAndFormat);
        return this;
    }

    public TopHitsAggregationBuilder fetchField(String field) {
        return this.fetchField(new FieldAndFormat(field, null, null));
    }

    public List<FieldAndFormat> fetchFields() {
        return this.fetchFields;
    }

    public TopHitsAggregationBuilder scriptField(String name, Script script) {
        if (name == null) {
            throw new IllegalArgumentException("scriptField [name] must not be null: [" + name + "]");
        }
        if (script == null) {
            throw new IllegalArgumentException("scriptField [script] must not be null: [" + name + "]");
        }
        this.scriptField(name, script, false);
        return this;
    }

    public TopHitsAggregationBuilder scriptField(String name, Script script, boolean ignoreFailure) {
        if (name == null) {
            throw new IllegalArgumentException("scriptField [name] must not be null: [" + name + "]");
        }
        if (script == null) {
            throw new IllegalArgumentException("scriptField [script] must not be null: [" + name + "]");
        }
        if (this.scriptFields == null) {
            this.scriptFields = new HashSet<SearchSourceBuilder.ScriptField>();
        }
        this.scriptFields.add(new SearchSourceBuilder.ScriptField(name, script, ignoreFailure));
        return this;
    }

    public TopHitsAggregationBuilder scriptFields(List<SearchSourceBuilder.ScriptField> scriptFields) {
        if (scriptFields == null) {
            throw new IllegalArgumentException("[scriptFields] must not be null: [" + this.name + "]");
        }
        if (this.scriptFields == null) {
            this.scriptFields = new HashSet<SearchSourceBuilder.ScriptField>();
        }
        this.scriptFields.addAll(scriptFields);
        return this;
    }

    public Set<SearchSourceBuilder.ScriptField> scriptFields() {
        return this.scriptFields;
    }

    public TopHitsAggregationBuilder explain(boolean explain) {
        this.explain = explain;
        return this;
    }

    public boolean explain() {
        return this.explain;
    }

    public TopHitsAggregationBuilder version(boolean version) {
        this.version = version;
        return this;
    }

    public boolean version() {
        return this.version;
    }

    public TopHitsAggregationBuilder seqNoAndPrimaryTerm(Boolean seqNoAndPrimaryTerm) {
        this.seqNoAndPrimaryTerm = seqNoAndPrimaryTerm;
        return this;
    }

    public Boolean seqNoAndPrimaryTerm() {
        return this.seqNoAndPrimaryTerm;
    }

    public TopHitsAggregationBuilder trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    public boolean trackScores() {
        return this.trackScores;
    }

    @Override
    public TopHitsAggregationBuilder subAggregations(AggregatorFactories.Builder subFactories) {
        throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.NONE;
    }

    @Override
    protected TopHitsAggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
        int maxInnerResultWindow;
        long innerResultWindow = this.from() + this.size();
        if (innerResultWindow > (long)(maxInnerResultWindow = context.getIndexSettings().getMaxInnerResultWindow())) {
            throw new IllegalArgumentException("Top hits result window is too large, the top hits aggregator [" + this.name + "]'s from + size must be less than or equal to: [" + maxInnerResultWindow + "] but was [" + innerResultWindow + "]. This limit can be set by changing the [" + IndexSettings.MAX_INNER_RESULT_WINDOW_SETTING.getKey() + "] index level setting.");
        }
        ArrayList<ScriptFieldsContext.ScriptField> scriptFields = new ArrayList<ScriptFieldsContext.ScriptField>();
        if (this.scriptFields != null) {
            for (SearchSourceBuilder.ScriptField field : this.scriptFields) {
                FieldScript.Factory factory = context.compile(field.script(), FieldScript.CONTEXT);
                FieldScript.LeafFactory searchScript = factory.newFactory(field.script().getParams(), context.lookup());
                scriptFields.add(new ScriptFieldsContext.ScriptField(field.fieldName(), searchScript, field.ignoreFailure()));
            }
        }
        Optional<Object> optionalSort = this.sorts == null ? Optional.empty() : context.buildSort(this.sorts);
        return new TopHitsAggregatorFactory(this.name, this.from, this.size, this.explain, this.version, this.seqNoAndPrimaryTerm, this.trackScores, optionalSort, this.highlightBuilder, this.storedFieldsContext, this.docValueFields, this.fetchFields, scriptFields, this.fetchSourceContext, context, parent, subfactoriesBuilder, this.metadata);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SearchSourceBuilder.FROM_FIELD.getPreferredName(), this.from);
        builder.field(SearchSourceBuilder.SIZE_FIELD.getPreferredName(), this.size);
        builder.field(SearchSourceBuilder.VERSION_FIELD.getPreferredName(), this.version);
        builder.field(SearchSourceBuilder.SEQ_NO_PRIMARY_TERM_FIELD.getPreferredName(), this.seqNoAndPrimaryTerm);
        builder.field(SearchSourceBuilder.EXPLAIN_FIELD.getPreferredName(), this.explain);
        if (this.fetchSourceContext != null) {
            builder.field(SearchSourceBuilder._SOURCE_FIELD.getPreferredName(), (ToXContent)this.fetchSourceContext);
        }
        if (this.storedFieldsContext != null) {
            this.storedFieldsContext.toXContent(SearchSourceBuilder.STORED_FIELDS_FIELD.getPreferredName(), builder);
        }
        if (this.docValueFields != null) {
            builder.startArray(SearchSourceBuilder.DOCVALUE_FIELDS_FIELD.getPreferredName());
            for (FieldAndFormat fieldAndFormat : this.docValueFields) {
                fieldAndFormat.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.fetchFields != null) {
            builder.startArray(SearchSourceBuilder.FETCH_FIELDS_FIELD.getPreferredName());
            for (FieldAndFormat fieldAndFormat : this.fetchFields) {
                fieldAndFormat.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.scriptFields != null) {
            builder.startObject(SearchSourceBuilder.SCRIPT_FIELDS_FIELD.getPreferredName());
            for (SearchSourceBuilder.ScriptField scriptField : this.scriptFields) {
                scriptField.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (this.sorts != null) {
            builder.startArray(SearchSourceBuilder.SORT_FIELD.getPreferredName());
            for (SortBuilder sortBuilder : this.sorts) {
                sortBuilder.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.trackScores) {
            builder.field(SearchSourceBuilder.TRACK_SCORES_FIELD.getPreferredName(), true);
        }
        if (this.highlightBuilder != null) {
            builder.field(SearchSourceBuilder.HIGHLIGHT_FIELD.getPreferredName(), (ToXContent)this.highlightBuilder);
        }
        builder.endObject();
        return builder;
    }

    public static TopHitsAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        TopHitsAggregationBuilder factory = new TopHitsAggregationBuilder(aggregationName);
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            List<SortBuilder<?>> sorts;
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (SearchSourceBuilder.FROM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    factory.from(parser.intValue());
                    continue;
                }
                if (SearchSourceBuilder.SIZE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    factory.size(parser.intValue());
                    continue;
                }
                if (SearchSourceBuilder.VERSION_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    factory.version(parser.booleanValue());
                    continue;
                }
                if (SearchSourceBuilder.SEQ_NO_PRIMARY_TERM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    factory.seqNoAndPrimaryTerm(parser.booleanValue());
                    continue;
                }
                if (SearchSourceBuilder.EXPLAIN_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    factory.explain(parser.booleanValue());
                    continue;
                }
                if (SearchSourceBuilder.TRACK_SCORES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    factory.trackScores(parser.booleanValue());
                    continue;
                }
                if (SearchSourceBuilder._SOURCE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    factory.fetchSource(FetchSourceContext.fromXContent(parser));
                    continue;
                }
                if (SearchSourceBuilder.STORED_FIELDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    factory.storedFieldsContext = StoredFieldsContext.fromXContent(SearchSourceBuilder.STORED_FIELDS_FIELD.getPreferredName(), parser);
                    continue;
                }
                if (SearchSourceBuilder.SORT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    factory.sort(parser.text());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + currentFieldName + "].", parser.getTokenLocation());
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (SearchSourceBuilder._SOURCE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    factory.fetchSource(FetchSourceContext.fromXContent(parser));
                    continue;
                }
                if (SearchSourceBuilder.SCRIPT_FIELDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    ArrayList<SearchSourceBuilder.ScriptField> scriptFields = new ArrayList<SearchSourceBuilder.ScriptField>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        String scriptFieldName = parser.currentName();
                        token = parser.nextToken();
                        if (token == XContentParser.Token.START_OBJECT) {
                            Script script = null;
                            boolean ignoreFailure = false;
                            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                if (token == XContentParser.Token.FIELD_NAME) {
                                    currentFieldName = parser.currentName();
                                    continue;
                                }
                                if (token.isValue()) {
                                    if (SearchSourceBuilder.SCRIPT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                        script = Script.parse(parser);
                                        continue;
                                    }
                                    if (SearchSourceBuilder.IGNORE_FAILURE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                        ignoreFailure = parser.booleanValue();
                                        continue;
                                    }
                                    throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + currentFieldName + "].", parser.getTokenLocation());
                                }
                                if (token == XContentParser.Token.START_OBJECT) {
                                    if (SearchSourceBuilder.SCRIPT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                        script = Script.parse(parser);
                                        continue;
                                    }
                                    throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + currentFieldName + "].", parser.getTokenLocation());
                                }
                                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + currentFieldName + "].", parser.getTokenLocation());
                            }
                            scriptFields.add(new SearchSourceBuilder.ScriptField(scriptFieldName, script, ignoreFailure));
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "Expected [" + XContentParser.Token.START_OBJECT + "] in [" + currentFieldName + "] but found [" + token + "]", parser.getTokenLocation());
                    }
                    factory.scriptFields(scriptFields);
                    continue;
                }
                if (SearchSourceBuilder.HIGHLIGHT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    factory.highlighter(HighlightBuilder.fromXContent(parser));
                    continue;
                }
                if (SearchSourceBuilder.SORT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    sorts = SortBuilder.fromXContent(parser);
                    factory.sorts(sorts);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + currentFieldName + "].", parser.getTokenLocation());
            }
            if (token == XContentParser.Token.START_ARRAY) {
                FieldAndFormat ff;
                if (SearchSourceBuilder.STORED_FIELDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    factory.storedFieldsContext = StoredFieldsContext.fromXContent(SearchSourceBuilder.STORED_FIELDS_FIELD.getPreferredName(), parser);
                    continue;
                }
                if (SearchSourceBuilder.DOCVALUE_FIELDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        ff = FieldAndFormat.fromXContent(parser);
                        factory.docValueField(ff.field, ff.format);
                    }
                    continue;
                }
                if (SearchSourceBuilder.FETCH_FIELDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        ff = FieldAndFormat.fromXContent(parser);
                        factory.fetchField(ff);
                    }
                    continue;
                }
                if (SearchSourceBuilder.SORT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    sorts = SortBuilder.fromXContent(parser);
                    factory.sorts(sorts);
                    continue;
                }
                if (SearchSourceBuilder._SOURCE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    factory.fetchSource(FetchSourceContext.fromXContent(parser));
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + currentFieldName + "].", parser.getTokenLocation());
            }
            throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + currentFieldName + "].", parser.getTokenLocation());
        }
        return factory;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TopHitsAggregationBuilder that = (TopHitsAggregationBuilder)o;
        return this.from == that.from && this.size == that.size && this.explain == that.explain && this.version == that.version && this.seqNoAndPrimaryTerm == that.seqNoAndPrimaryTerm && this.trackScores == that.trackScores && Objects.equals(this.sorts, that.sorts) && Objects.equals(this.highlightBuilder, that.highlightBuilder) && Objects.equals(this.storedFieldsContext, that.storedFieldsContext) && Objects.equals(this.docValueFields, that.docValueFields) && Objects.equals(this.fetchFields, that.fetchFields) && Objects.equals(this.scriptFields, that.scriptFields) && Objects.equals(this.fetchSourceContext, that.fetchSourceContext);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.from, this.size, this.explain, this.version, this.seqNoAndPrimaryTerm, this.trackScores, this.sorts, this.highlightBuilder, this.storedFieldsContext, this.docValueFields, this.fetchFields, this.scriptFields, this.fetchSourceContext);
    }

    @Override
    public String getType() {
        return NAME;
    }
}

