/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.range.AbstractRangeBuilder;
import org.elasticsearch.search.aggregations.bucket.range.DateRangeAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.range.InternalDateRange;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregatorSupplier;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ObjectParser;

public class DateRangeAggregationBuilder
extends AbstractRangeBuilder<DateRangeAggregationBuilder, RangeAggregator.Range> {
    public static final String NAME = "date_range";
    public static final ValuesSourceRegistry.RegistryKey<RangeAggregatorSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey<RangeAggregatorSupplier>("date_range", RangeAggregatorSupplier.class);
    public static final ObjectParser<DateRangeAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"date_range", DateRangeAggregationBuilder::new);
    private static final DeprecationLogger DEPRECATION_LOGGER;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(REGISTRY_KEY, List.of(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE), RangeAggregator::build, true);
        builder.register(REGISTRY_KEY, CoreValuesSourceType.BOOLEAN, (name, factories, valuesSourceConfig, rangeFactory, ranges, keyed, context, parent, cardinality, metadata) -> {
            DEPRECATION_LOGGER.critical(DeprecationCategory.AGGREGATIONS, "Range-boolean", "Running Range or DateRange aggregations on [boolean] fields is deprecated", new Object[0]);
            return RangeAggregator.build(name, factories, valuesSourceConfig, rangeFactory, ranges, keyed, context, parent, cardinality, metadata);
        }, true);
    }

    public DateRangeAggregationBuilder(String name) {
        super(name, InternalDateRange.FACTORY);
    }

    protected DateRangeAggregationBuilder(DateRangeAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new DateRangeAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public DateRangeAggregationBuilder(StreamInput in) throws IOException {
        super(in, InternalDateRange.FACTORY, RangeAggregator.Range::new);
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    protected ValuesSourceRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.DATE;
    }

    public DateRangeAggregationBuilder addRange(String key, String from, String to) {
        this.addRange(new RangeAggregator.Range(key, from, to));
        return this;
    }

    public DateRangeAggregationBuilder addRange(String from, String to) {
        return this.addRange(null, from, to);
    }

    public DateRangeAggregationBuilder addUnboundedTo(String key, String to) {
        this.addRange(new RangeAggregator.Range(key, null, to));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedTo(String to) {
        return this.addUnboundedTo(null, to);
    }

    public DateRangeAggregationBuilder addUnboundedFrom(String key, String from) {
        this.addRange(new RangeAggregator.Range(key, from, null));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedFrom(String from) {
        return this.addUnboundedFrom(null, from);
    }

    public DateRangeAggregationBuilder addRange(String key, double from, double to) {
        this.addRange(new RangeAggregator.Range(key, from, to));
        return this;
    }

    public DateRangeAggregationBuilder addRange(double from, double to) {
        return this.addRange(null, from, to);
    }

    public DateRangeAggregationBuilder addUnboundedTo(String key, double to) {
        this.addRange(new RangeAggregator.Range(key, null, to));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedTo(double to) {
        return this.addUnboundedTo(null, to);
    }

    public DateRangeAggregationBuilder addUnboundedFrom(String key, double from) {
        this.addRange(new RangeAggregator.Range(key, from, null));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedFrom(double from) {
        return this.addUnboundedFrom(null, from);
    }

    public DateRangeAggregationBuilder addRange(String key, ZonedDateTime from, ZonedDateTime to) {
        this.addRange(new RangeAggregator.Range(key, DateRangeAggregationBuilder.convertDateTime(from), DateRangeAggregationBuilder.convertDateTime(to)));
        return this;
    }

    private static Double convertDateTime(ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.toInstant().toEpochMilli();
    }

    public DateRangeAggregationBuilder addRange(ZonedDateTime from, ZonedDateTime to) {
        return this.addRange(null, from, to);
    }

    public DateRangeAggregationBuilder addUnboundedTo(String key, ZonedDateTime to) {
        this.addRange(new RangeAggregator.Range(key, null, DateRangeAggregationBuilder.convertDateTime(to)));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedTo(ZonedDateTime to) {
        return this.addUnboundedTo(null, to);
    }

    public DateRangeAggregationBuilder addUnboundedFrom(String key, ZonedDateTime from) {
        this.addRange(new RangeAggregator.Range(key, DateRangeAggregationBuilder.convertDateTime(from), null));
        return this;
    }

    public DateRangeAggregationBuilder addUnboundedFrom(ZonedDateTime from) {
        return this.addUnboundedFrom(null, from);
    }

    @Override
    protected DateRangeAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        RangeAggregatorSupplier aggregatorSupplier = context.getValuesSourceRegistry().getAggregator(REGISTRY_KEY, config);
        RangeAggregator.Range[] ranges = this.processRanges(range -> {
            DocValueFormat parser = config.format();
            assert (parser != null);
            double from = range.getFrom();
            double to = range.getTo();
            String fromAsString = range.getFromAsString();
            String toAsString = range.getToAsString();
            if (fromAsString != null) {
                from = parser.parseDouble(fromAsString, false, context::nowInMillis);
            } else if (Double.isFinite(from)) {
                from = parser.parseDouble(Long.toString((long)from), false, context::nowInMillis);
            }
            if (toAsString != null) {
                to = parser.parseDouble(toAsString, false, context::nowInMillis);
            } else if (Double.isFinite(to)) {
                to = parser.parseDouble(Long.toString((long)to), false, context::nowInMillis);
            }
            return new RangeAggregator.Range(range.getKey(), from, fromAsString, to, toAsString);
        });
        if (ranges.length == 0) {
            throw new IllegalArgumentException("No [ranges] specified for the [" + this.getName() + "] aggregation");
        }
        return new DateRangeAggregatorFactory(this.name, config, ranges, this.keyed, this.rangeFactory, context, parent, subFactoriesBuilder, this.metadata, aggregatorSupplier);
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, true, true, true);
        PARSER.declareBoolean(AbstractRangeBuilder::keyed, RangeAggregator.KEYED_FIELD);
        PARSER.declareObjectArray((agg, ranges) -> {
            for (RangeAggregator.Range range : ranges) {
                agg.addRange(range);
            }
        }, (p, c) -> (RangeAggregator.Range)RangeAggregator.Range.PARSER.parse(p, null), RangeAggregator.RANGES_FIELD);
        DEPRECATION_LOGGER = DeprecationLogger.getLogger(DateRangeAggregationBuilder.class);
    }
}

