/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.List;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.bucket.composite.BinaryValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.bucket.composite.DoubleValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.LongValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.MissingOrder;
import org.elasticsearch.search.aggregations.bucket.composite.OrdinalValuesSource;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class TermsValuesSourceBuilder
extends CompositeValuesSourceBuilder<TermsValuesSourceBuilder> {
    static final String TYPE = "terms";
    static final ValuesSourceRegistry.RegistryKey<TermsCompositeSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey<TermsCompositeSupplier>("terms", TermsCompositeSupplier.class);
    private static final ObjectParser<TermsValuesSourceBuilder, Void> PARSER = new ObjectParser("terms");

    static TermsValuesSourceBuilder parse(String name, XContentParser parser) throws IOException {
        return (TermsValuesSourceBuilder)PARSER.parse(parser, (Object)new TermsValuesSourceBuilder(name), null);
    }

    public TermsValuesSourceBuilder(String name) {
        super(name);
    }

    protected TermsValuesSourceBuilder(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    @Override
    public String type() {
        return TYPE;
    }

    static void register(ValuesSourceRegistry.Builder builder) {
        builder.register(REGISTRY_KEY, List.of(CoreValuesSourceType.DATE, CoreValuesSourceType.NUMERIC, CoreValuesSourceType.BOOLEAN), (valuesSourceConfig, name, hasScript, format, missingBucket, missingOrder, order) -> {
            DocValueFormat docValueFormat = format == null && valuesSourceConfig.valueSourceType() == CoreValuesSourceType.DATE ? DocValueFormat.RAW : valuesSourceConfig.format();
            return new CompositeValuesSourceConfig(name, valuesSourceConfig.fieldType(), valuesSourceConfig.getValuesSource(), docValueFormat, order, missingBucket, missingOrder, hasScript, (bigArrays, reader, size, addRequestCircuitBreakerBytes, compositeValuesSourceConfig) -> {
                ValuesSource.Numeric vs = (ValuesSource.Numeric)compositeValuesSourceConfig.valuesSource();
                if (vs.isFloatingPoint()) {
                    return new DoubleValuesSource(bigArrays, compositeValuesSourceConfig.fieldType(), (CheckedFunction<LeafReaderContext, SortedNumericDoubleValues, IOException>)((CheckedFunction)vs::doubleValues), compositeValuesSourceConfig.format(), compositeValuesSourceConfig.missingBucket(), compositeValuesSourceConfig.missingOrder(), size, compositeValuesSourceConfig.reverseMul());
                }
                LongUnaryOperator rounding = LongUnaryOperator.identity();
                return new LongValuesSource(bigArrays, compositeValuesSourceConfig.fieldType(), (CheckedFunction<LeafReaderContext, SortedNumericDocValues, IOException>)((CheckedFunction)vs::longValues), rounding, compositeValuesSourceConfig.format(), compositeValuesSourceConfig.missingBucket(), compositeValuesSourceConfig.missingOrder(), size, compositeValuesSourceConfig.reverseMul());
            });
        }, false);
        builder.register(REGISTRY_KEY, List.of(CoreValuesSourceType.KEYWORD, CoreValuesSourceType.IP), (valuesSourceConfig, name, hasScript, format, missingBucket, missingOrder, order) -> new CompositeValuesSourceConfig(name, valuesSourceConfig.fieldType(), valuesSourceConfig.getValuesSource(), valuesSourceConfig.format(), order, missingBucket, missingOrder, hasScript, (bigArrays, reader, size, addRequestCircuitBreakerBytes, compositeValuesSourceConfig) -> {
            if (valuesSourceConfig.hasOrdinals() && reader instanceof DirectoryReader) {
                ValuesSource.Bytes.WithOrdinals vs = (ValuesSource.Bytes.WithOrdinals)compositeValuesSourceConfig.valuesSource();
                return new OrdinalValuesSource(bigArrays, addRequestCircuitBreakerBytes, compositeValuesSourceConfig.fieldType(), (CheckedFunction<LeafReaderContext, SortedSetDocValues, IOException>)((CheckedFunction)vs::ordinalsValues), compositeValuesSourceConfig.format(), compositeValuesSourceConfig.missingBucket(), compositeValuesSourceConfig.missingOrder(), size, compositeValuesSourceConfig.reverseMul());
            }
            ValuesSource.Bytes vs = (ValuesSource.Bytes)compositeValuesSourceConfig.valuesSource();
            return new BinaryValuesSource(bigArrays, addRequestCircuitBreakerBytes, compositeValuesSourceConfig.fieldType(), (CheckedFunction<LeafReaderContext, SortedBinaryDocValues, IOException>)((CheckedFunction)vs::bytesValues), compositeValuesSourceConfig.format(), compositeValuesSourceConfig.missingBucket(), compositeValuesSourceConfig.missingOrder(), size, compositeValuesSourceConfig.reverseMul());
        }), false);
    }

    @Override
    protected ValuesSourceType getDefaultValuesSourceType() {
        return CoreValuesSourceType.KEYWORD;
    }

    @Override
    protected CompositeValuesSourceConfig innerBuild(ValuesSourceRegistry registry, ValuesSourceConfig config) throws IOException {
        return registry.getAggregator(REGISTRY_KEY, config).apply(config, this.name, this.script() != null, this.format(), this.missingBucket(), this.missingOrder(), this.order());
    }

    static {
        CompositeValuesSourceParserHelper.declareValuesSourceFields(PARSER);
    }

    @FunctionalInterface
    public static interface TermsCompositeSupplier {
        public CompositeValuesSourceConfig apply(ValuesSourceConfig var1, String var2, boolean var3, String var4, boolean var5, MissingOrder var6, SortOrder var7);
    }
}

