/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.script.AbstractFieldScript;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class StringFieldScript
extends AbstractFieldScript {
    public static final long MAX_CHARS = 0x100000L;
    public static final ScriptContext<Factory> CONTEXT = StringFieldScript.newContext("keyword_field", Factory.class);
    public static final Factory PARSE_FROM_SOURCE = new Factory(){

        @Override
        public LeafFactory newFactory(String field, Map<String, Object> params, SearchLookup lookup) {
            return ctx -> new StringFieldScript(field, params, lookup, ctx){

                @Override
                public void execute() {
                    this.emitFromSource();
                }
            };
        }

        @Override
        public boolean isResultDeterministic() {
            return true;
        }
    };
    public static final String[] PARAMETERS = new String[0];
    private final List<String> results = new ArrayList<String>();
    private long chars;

    public static Factory leafAdapter(Function<SearchLookup, CompositeFieldScript.LeafFactory> parentFactory) {
        return (leafFieldName, params, searchLookup) -> {
            CompositeFieldScript.LeafFactory parentLeafFactory = (CompositeFieldScript.LeafFactory)parentFactory.apply(searchLookup);
            return ctx -> {
                final CompositeFieldScript compositeFieldScript = parentLeafFactory.newInstance(ctx);
                return new StringFieldScript(leafFieldName, params, searchLookup, ctx){

                    @Override
                    public void setDocument(int docId) {
                        compositeFieldScript.setDocument(docId);
                    }

                    @Override
                    public void execute() {
                        this.emitFromCompositeScript(compositeFieldScript);
                    }
                };
            };
        };
    }

    public StringFieldScript(String fieldName, Map<String, Object> params, SearchLookup searchLookup, LeafReaderContext ctx) {
        super(fieldName, params, searchLookup, ctx);
    }

    public final List<String> resultsForDoc(int docId) {
        this.results.clear();
        this.chars = 0L;
        this.setDocument(docId);
        this.execute();
        return this.results;
    }

    public final void runForDoc(int docId, Consumer<String> consumer) {
        this.resultsForDoc(docId).forEach(consumer);
    }

    @Override
    protected void emitFromObject(Object v) {
        if (v != null) {
            this.emit(v.toString());
        }
    }

    public final void emit(String v) {
        this.checkMaxSize(this.results.size());
        this.chars += (long)v.length();
        if (this.chars > 0x100000L) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Runtime field [%s] is emitting [%s] characters while the maximum number of values allowed is [%s]", this.fieldName, this.chars, 0x100000L));
        }
        this.results.add(v);
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(String var1, Map<String, Object> var2, SearchLookup var3);
    }

    public static interface LeafFactory {
        public StringFieldScript newInstance(LeafReaderContext var1);
    }

    public static class Emit {
        private final StringFieldScript script;

        public Emit(StringFieldScript script) {
            this.script = script;
        }

        public void emit(String v) {
            this.script.emit(v);
        }
    }
}

