/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ParseField;

public enum ScriptType implements Writeable
{
    INLINE(0, new ParseField("source", new String[]{"inline"})),
    STORED(1, new ParseField("id", new String[]{"stored"}));

    private final int id;
    private final ParseField parseField;

    public static ScriptType readFrom(StreamInput in) throws IOException {
        int id = in.readVInt();
        if (ScriptType.STORED.id == id) {
            return STORED;
        }
        if (ScriptType.INLINE.id == id) {
            return INLINE;
        }
        throw new IllegalStateException("Error reading ScriptType id [" + id + "] from stream, expected one of [" + ScriptType.STORED.id + " [" + ScriptType.STORED.parseField.getPreferredName() + "], " + ScriptType.INLINE.id + " [" + ScriptType.INLINE.parseField.getPreferredName() + "]]");
    }

    private ScriptType(int id, ParseField parseField) {
        this.id = id;
        this.parseField = parseField;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public ParseField getParseField() {
        return this.parseField;
    }

    public String toString() {
        return this.getName();
    }
}

