/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.rest.RestCompatibleVersionHelper;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParsedMediaType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class RestRequest
implements ToXContent.Params {
    private static final Pattern TCHAR_PATTERN = Pattern.compile("[a-zA-z0-9!#$%&'*+\\-.\\^_`|~]+");
    private static final AtomicLong requestIdGenerator = new AtomicLong();
    private final NamedXContentRegistry xContentRegistry;
    private final Map<String, String> params;
    private final Map<String, List<String>> headers;
    private final String rawPath;
    private final Set<String> consumedParams = new HashSet<String>();
    private final SetOnce<XContentType> xContentType = new SetOnce();
    private final HttpChannel httpChannel;
    private final ParsedMediaType parsedAccept;
    private final ParsedMediaType parsedContentType;
    private final RestApiVersion restApiVersion;
    private HttpRequest httpRequest;
    private boolean contentConsumed = false;
    private final long requestId;

    public boolean isContentConsumed() {
        return this.contentConsumed;
    }

    protected RestRequest(NamedXContentRegistry xContentRegistry, Map<String, String> params, String path, Map<String, List<String>> headers, HttpRequest httpRequest, HttpChannel httpChannel) {
        this(xContentRegistry, params, path, headers, httpRequest, httpChannel, requestIdGenerator.incrementAndGet());
    }

    private RestRequest(NamedXContentRegistry xContentRegistry, Map<String, String> params, String path, Map<String, List<String>> headers, HttpRequest httpRequest, HttpChannel httpChannel, long requestId) {
        try {
            this.parsedAccept = RestRequest.parseHeaderWithMediaType(httpRequest.getHeaders(), "Accept");
        }
        catch (IllegalArgumentException e) {
            throw new MediaTypeHeaderException(e, "Accept");
        }
        try {
            this.parsedContentType = RestRequest.parseHeaderWithMediaType(httpRequest.getHeaders(), "Content-Type");
            if (this.parsedContentType != null) {
                this.xContentType.set((Object)((XContentType)this.parsedContentType.toMediaType(XContentType.MEDIA_TYPE_REGISTRY)));
            }
        }
        catch (IllegalArgumentException e) {
            throw new MediaTypeHeaderException(e, "Content-Type");
        }
        this.xContentRegistry = xContentRegistry;
        this.httpRequest = httpRequest;
        this.httpChannel = httpChannel;
        this.params = params;
        this.rawPath = path;
        this.headers = Collections.unmodifiableMap(headers);
        this.requestId = requestId;
        this.restApiVersion = RestCompatibleVersionHelper.getCompatibleVersion(this.parsedAccept, this.parsedContentType, this.hasContent());
    }

    @Nullable
    private static ParsedMediaType parseHeaderWithMediaType(Map<String, List<String>> headers, String headerName) {
        List<String> header = headers.get(headerName);
        if (header == null || header.isEmpty()) {
            return null;
        }
        if (header.size() > 1) {
            throw new IllegalArgumentException("Incorrect header [" + headerName + "]. Only one value should be provided");
        }
        String rawContentType = header.get(0);
        if (Strings.hasText(rawContentType)) {
            return ParsedMediaType.parseMediaType((String)rawContentType);
        }
        throw new IllegalArgumentException("Header [" + headerName + "] cannot be empty.");
    }

    protected RestRequest(RestRequest restRequest) {
        this(restRequest.getXContentRegistry(), restRequest.params(), restRequest.path(), restRequest.getHeaders(), restRequest.getHttpRequest(), restRequest.getHttpChannel(), restRequest.getRequestId());
    }

    void ensureSafeBuffers() {
        this.httpRequest = this.httpRequest.releaseAndCopy();
    }

    public static RestRequest request(NamedXContentRegistry xContentRegistry, HttpRequest httpRequest, HttpChannel httpChannel) {
        Map<String, String> params = RestRequest.params(httpRequest.uri());
        String path = RestRequest.path(httpRequest.uri());
        return new RestRequest(xContentRegistry, params, path, httpRequest.getHeaders(), httpRequest, httpChannel, requestIdGenerator.incrementAndGet());
    }

    private static Map<String, String> params(String uri) {
        HashMap<String, String> params = new HashMap<String, String>();
        int index = uri.indexOf(63);
        if (index >= 0) {
            try {
                RestUtils.decodeQueryString(uri, index + 1, params);
            }
            catch (IllegalArgumentException e) {
                throw new BadParameterException(e);
            }
        }
        return params;
    }

    private static String path(String uri) {
        int index = uri.indexOf(63);
        if (index >= 0) {
            return uri.substring(0, index);
        }
        return uri;
    }

    public static RestRequest requestWithoutParameters(NamedXContentRegistry xContentRegistry, HttpRequest httpRequest, HttpChannel httpChannel) {
        Map<String, String> params = Collections.emptyMap();
        return new RestRequest(xContentRegistry, params, httpRequest.uri(), httpRequest.getHeaders(), httpRequest, httpChannel, requestIdGenerator.incrementAndGet());
    }

    public Method method() {
        return this.httpRequest.method();
    }

    public String uri() {
        return this.httpRequest.uri();
    }

    public String rawPath() {
        return this.rawPath;
    }

    public final String path() {
        return RestUtils.decodeComponent(this.rawPath());
    }

    public boolean hasContent() {
        return this.contentLength() > 0;
    }

    public int contentLength() {
        return this.httpRequest.content().length();
    }

    public BytesReference content() {
        this.contentConsumed = true;
        return this.httpRequest.content();
    }

    public final BytesReference requiredContent() {
        if (!this.hasContent()) {
            throw new ElasticsearchParseException("request body is required", new Object[0]);
        }
        if (this.xContentType.get() == null) {
            throw new IllegalStateException("unknown content type");
        }
        return this.content();
    }

    public final String header(String name) {
        List<String> values = this.headers.get(name);
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public final List<String> getAllHeaderValues(String name) {
        List<String> values = this.headers.get(name);
        if (values != null) {
            return Collections.unmodifiableList(values);
        }
        return null;
    }

    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public final long getRequestId() {
        return this.requestId;
    }

    @Nullable
    public final XContentType getXContentType() {
        return (XContentType)this.xContentType.get();
    }

    public HttpChannel getHttpChannel() {
        return this.httpChannel;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public final boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    public final String param(String key) {
        this.consumedParams.add(key);
        return this.params.get(key);
    }

    public final String param(String key, String defaultValue) {
        this.consumedParams.add(key);
        String value = this.params.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map<String, String> params() {
        return this.params;
    }

    List<String> consumedParams() {
        return new ArrayList<String>(this.consumedParams);
    }

    List<String> unconsumedParams() {
        return this.params.keySet().stream().filter(p -> !this.consumedParams.contains(p)).collect(Collectors.toList());
    }

    public float paramAsFloat(String key, float defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse float parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    public double paramAsDouble(String key, double defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse double parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    public int paramAsInt(String key, int defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse int parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    public long paramAsLong(String key, long defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse long parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    public boolean paramAsBoolean(String key, boolean defaultValue) {
        String rawParam = this.param(key);
        if (rawParam != null && rawParam.length() == 0) {
            return true;
        }
        return Booleans.parseBoolean((String)rawParam, (boolean)defaultValue);
    }

    public Boolean paramAsBoolean(String key, Boolean defaultValue) {
        return Booleans.parseBoolean((String)this.param(key), (Boolean)defaultValue);
    }

    public TimeValue paramAsTime(String key, TimeValue defaultValue) {
        return TimeValue.parseTimeValue((String)this.param(key), (TimeValue)defaultValue, (String)key);
    }

    public ByteSizeValue paramAsSize(String key, ByteSizeValue defaultValue) {
        return ByteSizeValue.parseBytesSizeValue(this.param(key), defaultValue, key);
    }

    public String[] paramAsStringArray(String key, String[] defaultValue) {
        String value = this.param(key);
        if (value == null) {
            return defaultValue;
        }
        return Strings.splitStringByCommaToArray(value);
    }

    public String[] paramAsStringArrayOrEmptyIfAll(String key) {
        String[] params = this.paramAsStringArray(key, Strings.EMPTY_ARRAY);
        if (Strings.isAllOrWildcard(params)) {
            return Strings.EMPTY_ARRAY;
        }
        return params;
    }

    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    public final XContentParser contentParser() throws IOException {
        BytesReference content = this.requiredContent();
        XContent xContent = ((XContentType)this.xContentType.get()).xContent();
        return xContent.createParserForCompatibility(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)content.streamInput(), this.restApiVersion);
    }

    public final void applyContentParser(CheckedConsumer<XContentParser, IOException> applyParser) throws IOException {
        if (this.hasContent()) {
            try (XContentParser parser = this.contentParser();){
                applyParser.accept((Object)parser);
            }
        }
    }

    public final boolean hasContentOrSourceParam() {
        return this.hasContent() || this.hasParam("source");
    }

    public final XContentParser contentOrSourceParamParser() throws IOException {
        Tuple<XContentType, BytesReference> tuple = this.contentOrSourceParam();
        return ((XContentType)tuple.v1()).xContent().createParserForCompatibility(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)((BytesReference)tuple.v2()).streamInput(), this.restApiVersion);
    }

    public final void withContentOrSourceParamParserOrNull(CheckedConsumer<XContentParser, IOException> withParser) throws IOException {
        block13: {
            if (this.hasContentOrSourceParam()) {
                Tuple<XContentType, BytesReference> tuple = this.contentOrSourceParam();
                BytesReference content = (BytesReference)tuple.v2();
                XContentType xContentType = (XContentType)tuple.v1();
                try (StreamInput stream = content.streamInput();
                     XContentParser parser = xContentType.xContent().createParserForCompatibility(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream, this.restApiVersion);){
                    withParser.accept((Object)parser);
                    break block13;
                }
            }
            withParser.accept(null);
        }
    }

    public final Tuple<XContentType, BytesReference> contentOrSourceParam() {
        if (!this.hasContentOrSourceParam()) {
            throw new ElasticsearchParseException("request body or source parameter is required", new Object[0]);
        }
        if (this.hasContent()) {
            return new Tuple((Object)((XContentType)this.xContentType.get()), (Object)this.requiredContent());
        }
        String source = this.param("source");
        String typeParam = this.param("source_content_type");
        if (source == null || typeParam == null) {
            throw new IllegalStateException("source and source_content_type parameters are required");
        }
        BytesArray bytes = new BytesArray(source);
        XContentType xContentType = RestRequest.parseContentType(Collections.singletonList(typeParam));
        if (xContentType == null) {
            throw new IllegalStateException("Unknown value for source_content_type [" + typeParam + "]");
        }
        return new Tuple((Object)xContentType, (Object)bytes);
    }

    public ParsedMediaType getParsedAccept() {
        return this.parsedAccept;
    }

    public ParsedMediaType getParsedContentType() {
        return this.parsedContentType;
    }

    public static XContentType parseContentType(List<String> header) {
        if (header == null || header.isEmpty()) {
            return null;
        }
        if (header.size() > 1) {
            throw new IllegalArgumentException("only one Content-Type header should be provided");
        }
        String rawContentType = header.get(0);
        String[] elements = rawContentType.split("[ \t]*;");
        if (elements.length > 0) {
            String[] splitMediaType = elements[0].split("/");
            if (splitMediaType.length == 2 && TCHAR_PATTERN.matcher(splitMediaType[0]).matches() && TCHAR_PATTERN.matcher(splitMediaType[1].trim()).matches()) {
                return XContentType.fromMediaType((String)elements[0]);
            }
            throw new IllegalArgumentException("invalid Content-Type header [" + rawContentType + "]");
        }
        throw new IllegalArgumentException("empty Content-Type header");
    }

    public RestApiVersion getRestApiVersion() {
        return this.restApiVersion;
    }

    public static class MediaTypeHeaderException
    extends RuntimeException {
        private String failedHeaderName;

        MediaTypeHeaderException(IllegalArgumentException cause, String failedHeaderName) {
            super(cause);
            this.failedHeaderName = failedHeaderName;
        }

        public String getFailedHeaderName() {
            return this.failedHeaderName;
        }

        @Override
        public String getMessage() {
            return "Invalid media-type value on header [" + this.failedHeaderName + "]";
        }
    }

    public static class BadParameterException
    extends RuntimeException {
        BadParameterException(IllegalArgumentException cause) {
            super(cause);
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        OPTIONS,
        HEAD,
        PATCH,
        TRACE,
        CONNECT;

    }
}

