/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ParsedMediaType;

class RestCompatibleVersionHelper {
    RestCompatibleVersionHelper() {
    }

    static RestApiVersion getCompatibleVersion(@Nullable ParsedMediaType acceptHeader, @Nullable ParsedMediaType contentTypeHeader, boolean hasContent) {
        byte contentTypeVersion;
        Byte aVersion = RestCompatibleVersionHelper.parseVersion(acceptHeader);
        byte acceptVersion = aVersion == null ? RestApiVersion.current().major : Integer.valueOf(aVersion.byteValue()).byteValue();
        Byte cVersion = RestCompatibleVersionHelper.parseVersion(contentTypeHeader);
        byte by = contentTypeVersion = cVersion == null ? RestApiVersion.current().major : Integer.valueOf(cVersion.byteValue()).byteValue();
        if (acceptVersion > RestApiVersion.current().major || acceptVersion < RestApiVersion.minimumSupported().major) {
            throw new ElasticsearchStatusException("Accept version must be either version {} or {}, but found {}. Accept={}", RestStatus.BAD_REQUEST, RestApiVersion.current().major, RestApiVersion.minimumSupported().major, acceptVersion, acceptHeader);
        }
        if (hasContent) {
            if (contentTypeVersion > RestApiVersion.current().major || contentTypeVersion < RestApiVersion.minimumSupported().major) {
                throw new ElasticsearchStatusException("Content-Type version must be either version {} or {}, but found {}. Content-Type={}", RestStatus.BAD_REQUEST, RestApiVersion.current().major, RestApiVersion.minimumSupported().major, contentTypeVersion, contentTypeHeader);
            }
            if (contentTypeVersion != acceptVersion) {
                throw new ElasticsearchStatusException("A compatible version is required on both Content-Type and Accept headers if either one has requested a compatible version and the compatible versions must match. Accept={}, Content-Type={}", RestStatus.BAD_REQUEST, acceptHeader, contentTypeHeader);
            }
            if (cVersion == null && aVersion != null || aVersion == null && cVersion != null) {
                throw new ElasticsearchStatusException("A compatible version is required on both Content-Type and Accept headers if either one has requested a compatible version. Accept={}, Content-Type={}", RestStatus.BAD_REQUEST, acceptHeader, contentTypeHeader);
            }
            if (contentTypeVersion < RestApiVersion.current().major) {
                return RestApiVersion.minimumSupported();
            }
        }
        if (acceptVersion < RestApiVersion.current().major) {
            return RestApiVersion.minimumSupported();
        }
        return RestApiVersion.current();
    }

    static Byte parseVersion(ParsedMediaType parsedMediaType) {
        if (parsedMediaType != null) {
            String version = (String)parsedMediaType.getParameters().get("compatible-with");
            return version != null ? Byte.valueOf(Byte.parseByte(version)) : null;
        }
        return null;
    }
}

