/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.search.Queries;

public enum ZeroTermsQueryOption implements Writeable
{
    NONE(0){

        @Override
        public Query asQuery() {
            return Queries.newMatchNoDocsQuery("Matching no documents because no terms present");
        }
    }
    ,
    ALL(1){

        @Override
        public Query asQuery() {
            return Queries.newMatchAllQuery();
        }
    }
    ,
    NULL(2){

        @Override
        public Query asQuery() {
            return null;
        }
    };

    private final int ordinal;

    private ZeroTermsQueryOption(int ordinal) {
        this.ordinal = ordinal;
    }

    public abstract Query asQuery();

    public static ZeroTermsQueryOption readFromStream(StreamInput in) throws IOException {
        int ord = in.readVInt();
        for (ZeroTermsQueryOption zeroTermsQuery : ZeroTermsQueryOption.values()) {
            if (zeroTermsQuery.ordinal != ord) continue;
            return zeroTermsQuery;
        }
        throw new ElasticsearchException("unknown serialized type [" + ord + "]", new Object[0]);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal);
    }
}

