/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeoFormatterFactory;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoShapeUtils;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.SimpleVectorTileFormatter;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractLatLonPointIndexFieldData;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractPointGeometryFieldMapper;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.GeoPointFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.support.MapXContentParser;

public class GeoPointFieldMapper
extends AbstractPointGeometryFieldMapper<GeoPoint> {
    public static final String CONTENT_TYPE = "geo_point";
    public static FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.scriptCompiler(), (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings())));
    private final Builder builder;
    private final FieldValues<GeoPoint> scriptValues;

    private static Builder builder(FieldMapper in) {
        return ((GeoPointFieldMapper)in).builder;
    }

    public GeoPointFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, AbstractGeometryFieldMapper.Parser<GeoPoint> parser, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, builder.ignoreMalformed.get(), builder.ignoreZValue.get(), builder.nullValue.get(), copyTo, parser);
        this.builder = builder;
        this.scriptValues = null;
    }

    public GeoPointFieldMapper(String simpleName, MappedFieldType mappedFieldType, AbstractGeometryFieldMapper.Parser<GeoPoint> parser, Builder builder) {
        super(simpleName, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty(), parser, builder.onScriptError.get());
        this.builder = builder;
        this.scriptValues = builder.scriptValues();
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.builder.scriptCompiler, this.builder.ignoreMalformed.getDefaultValue().value()).init(this);
    }

    @Override
    protected void index(DocumentParserContext context, GeoPoint geometry) throws IOException {
        if (this.fieldType().isSearchable()) {
            context.doc().add((IndexableField)new LatLonPoint(this.fieldType().name(), geometry.lat(), geometry.lon()));
        }
        if (this.fieldType().hasDocValues()) {
            context.doc().add((IndexableField)new LatLonDocValuesField(this.fieldType().name(), geometry.lat(), geometry.lon()));
        } else if (this.fieldType().isStored() || this.fieldType().isSearchable()) {
            context.addToFieldNames(this.fieldType().name());
        }
        if (this.fieldType().isStored()) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), geometry.toString()));
        }
        this.multiFields.parse(this, context.switchParser(MapXContentParser.wrapObject((Object)geometry.geohash())));
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        this.scriptValues.valuesForDoc(searchLookup, readerContext, doc, point -> {
            try {
                this.index(documentParserContext, (GeoPoint)point);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<GeoPoint> nullValue;
        final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).indexed.get(), true);
        final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).hasDocValues.get(), true);
        final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).stored.get(), false);
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).script.get());
        private final FieldMapper.Parameter<String> onScriptError = FieldMapper.Parameter.onScriptErrorParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).onScriptError.get(), this.script);
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final ScriptCompiler scriptCompiler;

        public Builder(String name, ScriptCompiler scriptCompiler, boolean ignoreMalformedByDefault) {
            super(name);
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), ignoreMalformedByDefault);
            this.nullValue = AbstractPointGeometryFieldMapper.nullValueParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).nullValue.get(), (n, c, o) -> Builder.parseNullValue(o, this.ignoreZValue.get().value(), this.ignoreMalformed.get().value()), () -> null).acceptsNull();
            this.scriptCompiler = Objects.requireNonNull(scriptCompiler);
            this.script.precludesParameters(this.nullValue, this.ignoreMalformed, this.ignoreZValue);
            this.addScriptValidation(this.script, this.indexed, this.hasDocValues);
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.hasDocValues, this.indexed, this.stored, this.ignoreMalformed, this.ignoreZValue, this.nullValue, this.script, this.onScriptError, this.meta);
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        private static GeoPoint parseNullValue(Object nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            if (nullValue == null) {
                return null;
            }
            GeoPoint point = new GeoPoint();
            GeoUtils.parseGeoPoint(nullValue, point, ignoreZValue);
            if (!ignoreMalformed) {
                if (point.lat() > 90.0 || point.lat() < -90.0) {
                    throw new IllegalArgumentException("illegal latitude value [" + point.lat() + "]");
                }
                if (point.lon() > 180.0 || point.lon() < -180.0) {
                    throw new IllegalArgumentException("illegal longitude value [" + point.lon() + "]");
                }
            } else {
                GeoUtils.normalizePoint(point);
            }
            return point;
        }

        private FieldValues<GeoPoint> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            GeoPointFieldScript.Factory factory = this.scriptCompiler.compile(this.script.get(), GeoPointFieldScript.CONTEXT);
            return factory == null ? null : (lookup, ctx, doc, consumer) -> factory.newFactory(this.name, this.script.get().getParams(), lookup).newInstance(ctx).runGeoPointForDoc(doc, consumer);
        }

        @Override
        public FieldMapper build(MapperBuilderContext context) {
            GeoPointParser geoParser = new GeoPointParser(this.name, GeoPoint::new, (parser, point) -> {
                GeoUtils.parseGeoPoint(parser, point, (boolean)this.ignoreZValue.get().value());
                return point;
            }, this.nullValue.get(), (boolean)this.ignoreZValue.get().value(), (boolean)this.ignoreMalformed.get().value());
            GeoPointFieldType ft = new GeoPointFieldType(context.buildFullName(this.name), this.indexed.get(), this.stored.get(), this.hasDocValues.get(), geoParser, this.scriptValues(), this.meta.get());
            if (this.script.get() == null) {
                return new GeoPointFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), geoParser, this);
            }
            return new GeoPointFieldMapper(this.name, (MappedFieldType)ft, geoParser, this);
        }
    }

    private static class GeoPointParser
    extends AbstractPointGeometryFieldMapper.PointParser<GeoPoint> {
        GeoPointParser(String field, Supplier<GeoPoint> pointSupplier, CheckedBiFunction<XContentParser, GeoPoint, GeoPoint, IOException> objectParser, GeoPoint nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            super(field, pointSupplier, objectParser, nullValue, ignoreZValue, ignoreMalformed);
        }

        @Override
        protected GeoPoint validate(GeoPoint in) {
            if (!this.ignoreMalformed) {
                if (in.lat() > 90.0 || in.lat() < -90.0) {
                    throw new IllegalArgumentException("illegal latitude value [" + in.lat() + "] for " + this.field);
                }
                if (in.lon() > 180.0 || in.lon() < -180.0) {
                    throw new IllegalArgumentException("illegal longitude value [" + in.lon() + "] for " + this.field);
                }
            } else if (this.isNormalizable(in.lat()) && this.isNormalizable(in.lon())) {
                GeoUtils.normalizePoint(in);
            } else {
                throw new ElasticsearchParseException("cannot normalize the point - not a number", new Object[0]);
            }
            return in;
        }

        private boolean isNormalizable(double coord) {
            return !Double.isNaN(coord) && !Double.isInfinite(coord);
        }

        @Override
        protected void reset(GeoPoint in, double x, double y) {
            in.reset(y, x);
        }
    }

    public static class GeoPointFieldType
    extends AbstractGeometryFieldMapper.AbstractGeometryFieldType<GeoPoint>
    implements GeoShapeQueryable {
        private static final GeoFormatterFactory<GeoPoint> GEO_FORMATTER_FACTORY = new GeoFormatterFactory(List.of(new SimpleVectorTileFormatter()));
        private final FieldValues<GeoPoint> scriptValues;

        private GeoPointFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, AbstractGeometryFieldMapper.Parser<GeoPoint> parser, FieldValues<GeoPoint> scriptValues, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, parser, meta);
            this.scriptValues = scriptValues;
        }

        public GeoPointFieldType(String name) {
            this(name, true, false, true, null, null, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return GeoPointFieldMapper.CONTENT_TYPE;
        }

        @Override
        protected Function<List<GeoPoint>, List<Object>> getFormatter(String format) {
            return GEO_FORMATTER_FACTORY.getFormatter(format, p -> new Point(p.getLon(), p.getLat()));
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (this.scriptValues == null) {
                return super.valueFetcher(context, format);
            }
            Function formatter = this.getFormatter(format != null ? format : "geojson");
            return FieldValues.valueListFetcher(this.scriptValues, formatter, context);
        }

        @Override
        public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, SearchExecutionContext context) {
            LatLonGeometry[] luceneGeometries = GeoShapeUtils.toLuceneGeometry(fieldName, context, shape, relation);
            if (luceneGeometries.length == 0) {
                return new MatchNoDocsQuery();
            }
            ShapeField.QueryRelation luceneRelation = shape.type() == ShapeType.POINT && relation == ShapeRelation.INTERSECTS ? ShapeField.QueryRelation.CONTAINS : relation.getLuceneRelation();
            Query query = LatLonPoint.newGeometryQuery((String)fieldName, (ShapeField.QueryRelation)luceneRelation, (LatLonGeometry[])luceneGeometries);
            if (this.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newSlowGeometryQuery((String)fieldName, (ShapeField.QueryRelation)luceneRelation, (LatLonGeometry[])luceneGeometries);
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new AbstractLatLonPointIndexFieldData.Builder(this.name(), CoreValuesSourceType.GEOPOINT);
        }

        @Override
        public Query distanceFeatureQuery(Object origin, String pivot, SearchExecutionContext context) {
            GeoPoint originGeoPoint;
            if (origin instanceof GeoPoint) {
                originGeoPoint = (GeoPoint)origin;
            } else if (origin instanceof String) {
                originGeoPoint = GeoUtils.parseFromString((String)origin);
            } else {
                throw new IllegalArgumentException("Illegal type [" + origin.getClass() + "] for [origin]! Must be of type [geo_point] or [string] for geo_point fields!");
            }
            double pivotDouble = DistanceUnit.DEFAULT.parse(pivot, DistanceUnit.DEFAULT);
            return LatLonPoint.newDistanceFeatureQuery((String)this.name(), (float)1.0f, (double)originGeoPoint.lat(), (double)originGeoPoint.lon(), (double)pivotDouble);
        }
    }
}

