/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.LuceneDocument;

class DocumentLeafReader
extends LeafReader {
    private final LuceneDocument document;
    private final Map<String, Consumer<LeafReaderContext>> calculatedFields;
    private final Set<String> fieldPath = new LinkedHashSet<String>();

    DocumentLeafReader(LuceneDocument document, Map<String, Consumer<LeafReaderContext>> calculatedFields) {
        this.document = document;
        this.calculatedFields = calculatedFields;
    }

    private void checkField(String field) {
        if (this.calculatedFields.containsKey(field)) {
            if (!this.fieldPath.add(field)) {
                throw new IllegalArgumentException("Loop in field resolution detected: " + String.join((CharSequence)"->", this.fieldPath) + "->" + field);
            }
            this.calculatedFields.get(field).accept(this.getContext());
            this.fieldPath.remove(field);
        }
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.checkField(field);
        List<Number> values = this.document.getFields().stream().filter(f -> Objects.equals(f.name(), field)).filter(f -> f.fieldType().docValuesType() == DocValuesType.NUMERIC).map(IndexableField::numericValue).sorted().collect(Collectors.toList());
        return DocumentLeafReader.numericDocValues(values);
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.checkField(field);
        List<BytesRef> values = this.document.getFields().stream().filter(f -> Objects.equals(f.name(), field)).filter(f -> f.fieldType().docValuesType() == DocValuesType.BINARY).map(IndexableField::binaryValue).sorted().collect(Collectors.toList());
        return DocumentLeafReader.binaryDocValues(values);
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.checkField(field);
        List<BytesRef> values = this.document.getFields().stream().filter(f -> Objects.equals(f.name(), field)).filter(f -> f.fieldType().docValuesType() == DocValuesType.SORTED).map(IndexableField::binaryValue).sorted().collect(Collectors.toList());
        return DocumentLeafReader.sortedDocValues(values);
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.checkField(field);
        List<Number> values = this.document.getFields().stream().filter(f -> Objects.equals(f.name(), field)).filter(f -> f.fieldType().docValuesType() == DocValuesType.SORTED_NUMERIC).map(IndexableField::numericValue).sorted().collect(Collectors.toList());
        return DocumentLeafReader.sortedNumericDocValues(values);
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.checkField(field);
        List<BytesRef> values = this.document.getFields().stream().filter(f -> Objects.equals(f.name(), field)).filter(f -> f.fieldType().docValuesType() == DocValuesType.SORTED_SET).map(IndexableField::binaryValue).sorted().collect(Collectors.toList());
        return DocumentLeafReader.sortedSetDocValues(values);
    }

    public FieldInfos getFieldInfos() {
        return new FieldInfos(new FieldInfo[0]);
    }

    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        List fields = this.document.getFields().stream().filter(f -> f.fieldType().stored()).collect(Collectors.toList());
        for (IndexableField field : fields) {
            FieldInfo fieldInfo = DocumentLeafReader.fieldInfo(field.name());
            if (visitor.needsField(fieldInfo) != StoredFieldVisitor.Status.YES) continue;
            if (field.numericValue() != null) {
                Number v = field.numericValue();
                if (v instanceof Integer) {
                    visitor.intField(fieldInfo, v.intValue());
                    continue;
                }
                if (v instanceof Long) {
                    visitor.longField(fieldInfo, v.longValue());
                    continue;
                }
                if (v instanceof Float) {
                    visitor.floatField(fieldInfo, v.floatValue());
                    continue;
                }
                if (!(v instanceof Double)) continue;
                visitor.doubleField(fieldInfo, v.doubleValue());
                continue;
            }
            if (field.stringValue() != null) {
                visitor.stringField(fieldInfo, field.stringValue());
                continue;
            }
            if (field.binaryValue() == null) continue;
            byte[] data = new byte[field.binaryValue().length];
            System.arraycopy(field.binaryValue().bytes, field.binaryValue().offset, data, 0, data.length);
            visitor.binaryField(fieldInfo, data);
        }
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        throw new UnsupportedOperationException();
    }

    public Terms terms(String field) throws IOException {
        throw new UnsupportedOperationException();
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        throw new UnsupportedOperationException();
    }

    public VectorValues getVectorValues(String field) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TopDocs searchNearestVectors(String field, float[] target, int k, Bits acceptDocs) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Bits getLiveDocs() {
        throw new UnsupportedOperationException();
    }

    public PointValues getPointValues(String field) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void checkIntegrity() throws IOException {
        throw new UnsupportedOperationException();
    }

    public LeafMetaData getMetaData() {
        throw new UnsupportedOperationException();
    }

    public Fields getTermVectors(int docID) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int numDocs() {
        throw new UnsupportedOperationException();
    }

    public int maxDoc() {
        throw new UnsupportedOperationException();
    }

    protected void doClose() throws IOException {
        throw new UnsupportedOperationException();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        throw new UnsupportedOperationException();
    }

    private static FieldInfo fieldInfo(String name) {
        return new FieldInfo(name, 0, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorSimilarityFunction.EUCLIDEAN, false);
    }

    private static NumericDocValues numericDocValues(final List<Number> values) {
        if (values.size() == 0) {
            return null;
        }
        final DocIdSetIterator disi = DocIdSetIterator.all((int)1);
        return new NumericDocValues(){

            public long longValue() {
                return ((Number)values.get(0)).longValue();
            }

            public boolean advanceExact(int target) throws IOException {
                return disi.advance(target) == target;
            }

            public int docID() {
                return disi.docID();
            }

            public int nextDoc() throws IOException {
                return disi.nextDoc();
            }

            public int advance(int target) throws IOException {
                return disi.advance(target);
            }

            public long cost() {
                return disi.cost();
            }
        };
    }

    private static SortedNumericDocValues sortedNumericDocValues(final List<Number> values) {
        if (values.size() == 0) {
            return null;
        }
        final DocIdSetIterator disi = DocIdSetIterator.all((int)1);
        return new SortedNumericDocValues(){
            int i = -1;

            public long nextValue() {
                ++this.i;
                return ((Number)values.get(this.i)).longValue();
            }

            public int docValueCount() {
                return values.size();
            }

            public boolean advanceExact(int target) throws IOException {
                this.i = -1;
                return disi.advance(target) == target;
            }

            public int docID() {
                return disi.docID();
            }

            public int nextDoc() throws IOException {
                this.i = -1;
                return disi.nextDoc();
            }

            public int advance(int target) throws IOException {
                this.i = -1;
                return disi.advance(target);
            }

            public long cost() {
                return disi.cost();
            }
        };
    }

    private static BinaryDocValues binaryDocValues(final List<BytesRef> values) {
        if (values.size() == 0) {
            return null;
        }
        final DocIdSetIterator disi = DocIdSetIterator.all((int)1);
        return new BinaryDocValues(){

            public BytesRef binaryValue() {
                return (BytesRef)values.get(0);
            }

            public boolean advanceExact(int target) throws IOException {
                return disi.advance(target) == target;
            }

            public int docID() {
                return disi.docID();
            }

            public int nextDoc() throws IOException {
                return disi.nextDoc();
            }

            public int advance(int target) throws IOException {
                return disi.advance(target);
            }

            public long cost() {
                return disi.cost();
            }
        };
    }

    private static SortedDocValues sortedDocValues(final List<BytesRef> values) {
        if (values.size() == 0) {
            return null;
        }
        final DocIdSetIterator disi = DocIdSetIterator.all((int)1);
        return new SortedDocValues(){

            public int ordValue() {
                return 0;
            }

            public BytesRef lookupOrd(int ord) {
                return (BytesRef)values.get(0);
            }

            public int getValueCount() {
                return values.size();
            }

            public boolean advanceExact(int target) throws IOException {
                return disi.advance(target) == target;
            }

            public int docID() {
                return disi.docID();
            }

            public int nextDoc() throws IOException {
                return disi.nextDoc();
            }

            public int advance(int target) throws IOException {
                return disi.advance(target);
            }

            public long cost() {
                return disi.cost();
            }
        };
    }

    private static SortedSetDocValues sortedSetDocValues(final List<BytesRef> values) {
        if (values.size() == 0) {
            return null;
        }
        final DocIdSetIterator disi = DocIdSetIterator.all((int)1);
        return new SortedSetDocValues(){
            int i = -1;

            public long nextOrd() {
                ++this.i;
                if (this.i >= values.size()) {
                    return -1L;
                }
                return this.i;
            }

            public BytesRef lookupOrd(long ord) {
                return (BytesRef)values.get((int)ord);
            }

            public long getValueCount() {
                return values.size();
            }

            public boolean advanceExact(int target) throws IOException {
                this.i = -1;
                return disi.advance(target) == target;
            }

            public int docID() {
                return disi.docID();
            }

            public int nextDoc() throws IOException {
                this.i = -1;
                return disi.nextDoc();
            }

            public int advance(int target) throws IOException {
                this.i = -1;
                return disi.advance(target);
            }

            public long cost() {
                return disi.cost();
            }
        };
    }
}

