/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.util.List;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Uid;

public final class SingleFieldsVisitor
extends StoredFieldVisitor {
    private final MappedFieldType field;
    private final List<Object> destination;

    public SingleFieldsVisitor(MappedFieldType field, List<Object> destination) {
        this.field = field;
        this.destination = destination;
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
        if (fieldInfo.name.equals(this.field.name())) {
            return StoredFieldVisitor.Status.YES;
        }
        return StoredFieldVisitor.Status.NO;
    }

    private void addValue(Object value) {
        this.destination.add(this.field.valueForDisplay(value));
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) {
        if ("_id".equals(fieldInfo.name)) {
            this.addValue(Uid.decodeId(value));
        } else {
            this.addValue(new BytesRef(value));
        }
    }

    public void stringField(FieldInfo fieldInfo, String value) {
        this.addValue(value);
    }

    public void intField(FieldInfo fieldInfo, int value) {
        this.addValue(value);
    }

    public void longField(FieldInfo fieldInfo, long value) {
        this.addValue(value);
    }

    public void floatField(FieldInfo fieldInfo, float value) {
        this.addValue(Float.valueOf(value));
    }

    public void doubleField(FieldInfo fieldInfo, double value) {
        this.addValue(value);
    }
}

