/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.component;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.component.LifecycleListener;

public abstract class AbstractLifecycleComponent
implements LifecycleComponent {
    protected final Lifecycle lifecycle = new Lifecycle();
    private final List<LifecycleListener> listeners = new CopyOnWriteArrayList<LifecycleListener>();

    protected AbstractLifecycleComponent() {
    }

    @Override
    public Lifecycle.State lifecycleState() {
        return this.lifecycle.state();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Lifecycle lifecycle = this.lifecycle;
        synchronized (lifecycle) {
            if (!this.lifecycle.canMoveToStarted()) {
                return;
            }
            for (LifecycleListener listener : this.listeners) {
                listener.beforeStart();
            }
            this.doStart();
            this.lifecycle.moveToStarted();
            for (LifecycleListener listener : this.listeners) {
                listener.afterStart();
            }
        }
    }

    protected abstract void doStart();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Lifecycle lifecycle = this.lifecycle;
        synchronized (lifecycle) {
            if (!this.lifecycle.canMoveToStopped()) {
                return;
            }
            for (LifecycleListener listener : this.listeners) {
                listener.beforeStop();
            }
            this.lifecycle.moveToStopped();
            this.doStop();
            for (LifecycleListener listener : this.listeners) {
                listener.afterStop();
            }
        }
    }

    protected abstract void doStop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Lifecycle lifecycle = this.lifecycle;
        synchronized (lifecycle) {
            if (this.lifecycle.started()) {
                this.stop();
            }
            if (!this.lifecycle.canMoveToClosed()) {
                return;
            }
            for (LifecycleListener listener : this.listeners) {
                listener.beforeClose();
            }
            this.lifecycle.moveToClosed();
            try {
                this.doClose();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                for (LifecycleListener listener : this.listeners) {
                    listener.afterClose();
                }
            }
        }
    }

    protected abstract void doClose() throws IOException;
}

