/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.ModifyDataStreamsAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStreamAction;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataMigrateToDataStreamService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.IndicesService;

public class MetadataDataStreamsService {
    private final ClusterService clusterService;
    private final IndicesService indicesService;

    public MetadataDataStreamsService(ClusterService clusterService, IndicesService indicesService) {
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    public void modifyDataStream(final ModifyDataStreamsAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        if (request.getActions().size() == 0) {
            listener.onResponse(AcknowledgedResponse.TRUE);
        } else {
            this.clusterService.submitStateUpdateTask("update-backing-indices", new AckedClusterStateUpdateTask(Priority.URGENT, request, listener){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    return MetadataDataStreamsService.modifyDataStream(currentState, request.getActions(), indexMetadata -> {
                        try {
                            return MetadataDataStreamsService.this.indicesService.createIndexMapperService((IndexMetadata)indexMetadata);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    });
                }
            });
        }
    }

    static ClusterState modifyDataStream(ClusterState currentState, Iterable<DataStreamAction> actions, Function<IndexMetadata, MapperService> mapperSupplier) {
        Metadata updatedMetadata = currentState.metadata();
        for (DataStreamAction action : actions) {
            Metadata.Builder builder = Metadata.builder(updatedMetadata);
            if (action.getType() == DataStreamAction.Type.ADD_BACKING_INDEX) {
                MetadataDataStreamsService.addBackingIndex(updatedMetadata, builder, mapperSupplier, action.getDataStream(), action.getIndex());
            } else if (action.getType() == DataStreamAction.Type.REMOVE_BACKING_INDEX) {
                MetadataDataStreamsService.removeBackingIndex(updatedMetadata, builder, action.getDataStream(), action.getIndex());
            } else {
                throw new IllegalStateException("unsupported data stream action type [" + action.getClass().getName() + "]");
            }
            updatedMetadata = builder.build();
        }
        return ClusterState.builder(currentState).metadata(updatedMetadata).build();
    }

    private static void addBackingIndex(Metadata metadata, Metadata.Builder builder, Function<IndexMetadata, MapperService> mapperSupplier, String dataStreamName, String indexName) {
        IndexAbstraction.DataStream dataStream = MetadataDataStreamsService.validateDataStream(metadata, dataStreamName);
        IndexAbstraction index = MetadataDataStreamsService.validateIndex(metadata, indexName);
        try {
            MetadataMigrateToDataStreamService.prepareBackingIndex(builder, metadata.index(index.getWriteIndex()), dataStreamName, mapperSupplier, false);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to prepare backing index", e);
        }
        builder.put(dataStream.getDataStream().addBackingIndex(metadata, index.getWriteIndex()));
    }

    private static void removeBackingIndex(Metadata metadata, Metadata.Builder builder, String dataStreamName, String indexName) {
        IndexAbstraction.DataStream dataStream = MetadataDataStreamsService.validateDataStream(metadata, dataStreamName);
        IndexAbstraction index = MetadataDataStreamsService.validateIndex(metadata, indexName);
        IndexMetadata writeIndex = metadata.index(index.getWriteIndex());
        builder.put(dataStream.getDataStream().removeBackingIndex(writeIndex.getIndex()));
        builder.put(IndexMetadata.builder(writeIndex).settings(Settings.builder().put(writeIndex.getSettings()).put("index.hidden", "false").build()).settingsVersion(writeIndex.getSettingsVersion() + 1L));
    }

    private static IndexAbstraction.DataStream validateDataStream(Metadata metadata, String dataStreamName) {
        IndexAbstraction dataStream = (IndexAbstraction)metadata.getIndicesLookup().get(dataStreamName);
        if (dataStream == null || dataStream.getType() != IndexAbstraction.Type.DATA_STREAM) {
            throw new IllegalArgumentException("data stream [" + dataStreamName + "] not found");
        }
        return (IndexAbstraction.DataStream)dataStream;
    }

    private static IndexAbstraction validateIndex(Metadata metadata, String indexName) {
        IndexAbstraction index = (IndexAbstraction)metadata.getIndicesLookup().get(indexName);
        if (index == null || index.getType() != IndexAbstraction.Type.CONCRETE_INDEX) {
            throw new IllegalArgumentException("index [" + indexName + "] not found");
        }
        return index;
    }
}

