/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetMappingsResponse
extends ActionResponse
implements ToXContentFragment {
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private final ImmutableOpenMap<String, MappingMetadata> mappings;

    public GetMappingsResponse(ImmutableOpenMap<String, MappingMetadata> mappings) {
        this.mappings = mappings;
    }

    GetMappingsResponse(StreamInput in) throws IOException {
        super(in);
        this.mappings = in.readImmutableMap(StreamInput::readString, in.getVersion().before(Version.V_8_0_0) ? i -> {
            int mappingCount = i.readVInt();
            assert (mappingCount == 1 || mappingCount == 0) : "Expected 0 or 1 mappings but got " + mappingCount;
            if (mappingCount == 1) {
                String type = i.readString();
                assert ("_doc".equals(type)) : "Expected type [_doc] but got [" + type + "]";
                return new MappingMetadata(i);
            }
            return MappingMetadata.EMPTY_MAPPINGS;
        } : i -> i.readBoolean() ? new MappingMetadata(i) : MappingMetadata.EMPTY_MAPPINGS);
    }

    public ImmutableOpenMap<String, MappingMetadata> mappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, MappingMetadata> getMappings() {
        return this.mappings();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        MappingMetadata.writeMappingMetadata(out, this.mappings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (ObjectObjectCursor<String, MappingMetadata> objectObjectCursor : this.getMappings()) {
            builder.startObject((String)objectObjectCursor.key);
            boolean includeTypeName = params.paramAsBoolean("include_type_name", false);
            if (builder.getRestApiVersion() == RestApiVersion.V_7 && includeTypeName && objectObjectCursor.value != null) {
                builder.startObject(MAPPINGS.getPreferredName());
                if (objectObjectCursor.value != MappingMetadata.EMPTY_MAPPINGS) {
                    builder.field("_doc", ((MappingMetadata)objectObjectCursor.value).sourceAsMap());
                }
                builder.endObject();
            } else if (objectObjectCursor.value != null) {
                builder.field(MAPPINGS.getPreferredName(), ((MappingMetadata)objectObjectCursor.value).sourceAsMap());
            } else {
                builder.startObject(MAPPINGS.getPreferredName()).endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public int hashCode() {
        return this.mappings.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetMappingsResponse other = (GetMappingsResponse)obj;
        return this.mappings.equals(other.mappings);
    }
}

