/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.diskusage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.admin.indices.diskusage.AnalyzeDiskUsageShardRequest;
import org.elasticsearch.action.admin.indices.diskusage.AnalyzeDiskUsageShardResponse;
import org.elasticsearch.action.admin.indices.diskusage.AnalyzeIndexDiskUsageRequest;
import org.elasticsearch.action.admin.indices.diskusage.AnalyzeIndexDiskUsageResponse;
import org.elasticsearch.action.admin.indices.diskusage.IndexDiskUsageAnalyzer;
import org.elasticsearch.action.admin.indices.diskusage.IndexDiskUsageStats;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.TransportBroadcastAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportAnalyzeIndexDiskUsageAction
extends TransportBroadcastAction<AnalyzeIndexDiskUsageRequest, AnalyzeIndexDiskUsageResponse, AnalyzeDiskUsageShardRequest, AnalyzeDiskUsageShardResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportAnalyzeIndexDiskUsageAction(ClusterService clusterService, TransportService transportService, IndicesService indexServices, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/analyze_disk_usage", clusterService, transportService, actionFilters, indexNameExpressionResolver, AnalyzeIndexDiskUsageRequest::new, AnalyzeDiskUsageShardRequest::new, "analyze");
        this.indicesService = indexServices;
    }

    @Override
    protected void doExecute(Task task, AnalyzeIndexDiskUsageRequest request, ActionListener<AnalyzeIndexDiskUsageResponse> listener) {
        super.doExecute(task, request, listener);
    }

    @Override
    protected AnalyzeDiskUsageShardRequest newShardRequest(int numShards, ShardRouting shard, AnalyzeIndexDiskUsageRequest request) {
        return new AnalyzeDiskUsageShardRequest(shard.shardId(), request);
    }

    @Override
    protected AnalyzeDiskUsageShardResponse readShardResponse(StreamInput in) throws IOException {
        return new AnalyzeDiskUsageShardResponse(in);
    }

    @Override
    protected AnalyzeDiskUsageShardResponse shardOperation(AnalyzeDiskUsageShardRequest request, Task task) throws IOException {
        ShardId shardId = request.shardId();
        assert (task instanceof CancellableTask) : "AnalyzeDiskUsageShardRequest must create a cancellable task";
        CancellableTask cancellableTask = (CancellableTask)task;
        Runnable checkForCancellation = cancellableTask::ensureNotCancelled;
        IndexShard shard = this.indicesService.indexServiceSafe(shardId.getIndex()).getShard(shardId.id());
        try (Engine.IndexCommitRef commitRef = shard.acquireLastIndexCommit(request.flush);){
            IndexDiskUsageStats stats = IndexDiskUsageAnalyzer.analyze(shardId, commitRef.getIndexCommit(), checkForCancellation);
            AnalyzeDiskUsageShardResponse analyzeDiskUsageShardResponse = new AnalyzeDiskUsageShardResponse(shardId, stats);
            return analyzeDiskUsageShardResponse;
        }
    }

    @Override
    protected AnalyzeIndexDiskUsageResponse newResponse(AnalyzeIndexDiskUsageRequest request, AtomicReferenceArray<?> shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        ArrayList<DefaultShardOperationFailedException> shardFailures = new ArrayList<DefaultShardOperationFailedException>();
        HashMap<String, IndexDiskUsageStats> combined = new HashMap<String, IndexDiskUsageStats>();
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object r = shardsResponses.get(i);
            if (r instanceof AnalyzeDiskUsageShardResponse) {
                ++successfulShards;
                AnalyzeDiskUsageShardResponse resp = (AnalyzeDiskUsageShardResponse)r;
                combined.compute(resp.getIndex(), (k, v) -> v == null ? resp.stats : v.add(resp.stats));
                continue;
            }
            if (r instanceof DefaultShardOperationFailedException) {
                shardFailures.add((DefaultShardOperationFailedException)r);
                continue;
            }
            assert (false) : "unknown response [" + r + "]";
            throw new IllegalStateException("unknown response [" + r + "]");
        }
        return new AnalyzeIndexDiskUsageResponse(shardsResponses.length(), successfulShards, shardFailures.size(), shardFailures, combined);
    }

    @Override
    protected GroupShardsIterator<ShardIterator> shards(ClusterState clusterState, AnalyzeIndexDiskUsageRequest request, String[] concreteIndices) {
        GroupShardsIterator<ShardIterator> groups = this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, null, null);
        for (ShardIterator group : groups) {
            if (group.size() != 0) continue;
            throw new NoShardAvailableActionException(group.shardId());
        }
        return groups;
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, AnalyzeIndexDiskUsageRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, AnalyzeIndexDiskUsageRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }
}

