/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.migration;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.migration.GetFeatureUpgradeStatusRequest;
import org.elasticsearch.action.admin.cluster.migration.GetFeatureUpgradeStatusResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.upgrades.FeatureMigrationResults;
import org.elasticsearch.upgrades.SingleFeatureMigrationResult;
import org.elasticsearch.upgrades.SystemIndexMigrationTaskState;

public class TransportGetFeatureUpgradeStatusAction
extends TransportMasterNodeAction<GetFeatureUpgradeStatusRequest, GetFeatureUpgradeStatusResponse> {
    public static final Version NO_UPGRADE_REQUIRED_VERSION = Version.V_8_0_0;
    private final SystemIndices systemIndices;

    @Inject
    public TransportGetFeatureUpgradeStatusAction(TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices) {
        super("cluster:admin/migration/get_system_feature", transportService, clusterService, threadPool, actionFilters, GetFeatureUpgradeStatusRequest::new, indexNameExpressionResolver, GetFeatureUpgradeStatusResponse::new, "same");
        this.systemIndices = systemIndices;
    }

    @Override
    protected void masterOperation(Task task, GetFeatureUpgradeStatusRequest request, ClusterState state, ActionListener<GetFeatureUpgradeStatusResponse> listener) throws Exception {
        List<GetFeatureUpgradeStatusResponse.FeatureUpgradeStatus> features = this.systemIndices.getFeatures().values().stream().sorted(Comparator.comparing(SystemIndices.Feature::getName)).map(feature -> TransportGetFeatureUpgradeStatusAction.getFeatureUpgradeStatus(state, feature)).collect(Collectors.toList());
        GetFeatureUpgradeStatusResponse.UpgradeStatus status = features.stream().map(GetFeatureUpgradeStatusResponse.FeatureUpgradeStatus::getUpgradeStatus).reduce((xva$0, xva$1) -> GetFeatureUpgradeStatusResponse.UpgradeStatus.combine(xva$0, xva$1)).orElseGet(() -> {
            assert (false) : "get feature statuses API doesn't have any features";
            return GetFeatureUpgradeStatusResponse.UpgradeStatus.NO_MIGRATION_NEEDED;
        });
        listener.onResponse(new GetFeatureUpgradeStatusResponse(features, status));
    }

    static GetFeatureUpgradeStatusResponse.FeatureUpgradeStatus getFeatureUpgradeStatus(ClusterState state, SystemIndices.Feature feature) {
        String featureName = feature.getName();
        String currentFeature = Optional.ofNullable((PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks")).map(tasksMetdata -> tasksMetdata.getTask("upgrade-system-indices")).map(task -> task.getState()).map(taskState -> ((SystemIndexMigrationTaskState)taskState).getCurrentFeature()).orElse(null);
        List<GetFeatureUpgradeStatusResponse.IndexInfo> indexInfos = TransportGetFeatureUpgradeStatusAction.getIndexInfos(state, feature);
        Version minimumVersion = indexInfos.stream().map(GetFeatureUpgradeStatusResponse.IndexInfo::getVersion).min(Version::compareTo).orElse(Version.CURRENT);
        GetFeatureUpgradeStatusResponse.UpgradeStatus initialStatus = featureName.equals(currentFeature) ? GetFeatureUpgradeStatusResponse.UpgradeStatus.IN_PROGRESS : (minimumVersion.before(NO_UPGRADE_REQUIRED_VERSION) ? GetFeatureUpgradeStatusResponse.UpgradeStatus.MIGRATION_NEEDED : GetFeatureUpgradeStatusResponse.UpgradeStatus.NO_MIGRATION_NEEDED);
        GetFeatureUpgradeStatusResponse.UpgradeStatus status = indexInfos.stream().filter(idxInfo -> idxInfo.getException() != null).findFirst().map(idxInfo -> GetFeatureUpgradeStatusResponse.UpgradeStatus.ERROR).map(idxStatus -> GetFeatureUpgradeStatusResponse.UpgradeStatus.combine(idxStatus, initialStatus)).orElse(initialStatus);
        return new GetFeatureUpgradeStatusResponse.FeatureUpgradeStatus(featureName, minimumVersion, status, indexInfos);
    }

    static List<GetFeatureUpgradeStatusResponse.IndexInfo> getIndexInfos(ClusterState state, SystemIndices.Feature feature) {
        SingleFeatureMigrationResult featureStatus = Optional.ofNullable((FeatureMigrationResults)state.metadata().custom("system_index_migration")).map(FeatureMigrationResults::getFeatureStatuses).map(results -> (SingleFeatureMigrationResult)results.get(feature.getName())).orElse(null);
        String failedFeatureName = featureStatus == null ? null : featureStatus.getFailedIndexName();
        Exception exception = featureStatus == null ? null : featureStatus.getException();
        return feature.getIndexDescriptors().stream().flatMap(descriptor -> descriptor.getMatchingIndices(state.metadata()).stream()).sorted(String::compareTo).map(index -> state.metadata().index((String)index)).map(indexMetadata -> new GetFeatureUpgradeStatusResponse.IndexInfo(indexMetadata.getIndex().getName(), indexMetadata.getCreationVersion(), indexMetadata.getIndex().getName().equals(failedFeatureName) ? exception : null)).collect(Collectors.toList());
    }

    @Override
    protected ClusterBlockException checkBlock(GetFeatureUpgradeStatusRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

