/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectortile.rest;

import com.wdtinc.mapbox_vector_tile.VectorTile;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerProps;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.SimpleFeatureFactory;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoGridAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileGridAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGridBucket;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoTileGrid;
import org.elasticsearch.search.aggregations.metrics.GeoBoundsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.GeoCentroidAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.InternalGeoBounds;
import org.elasticsearch.search.aggregations.metrics.InternalGeoCentroid;
import org.elasticsearch.search.aggregations.pipeline.StatsBucketPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.profile.SearchProfileResults;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.vectortile.rest.VectorTileRequest;
import org.elasticsearch.xpack.vectortile.rest.VectorTileUtils;

public class RestVectorTileAction
extends BaseRestHandler {
    private static final String META_LAYER = "meta";
    private static final String HITS_LAYER = "hits";
    private static final String AGGS_LAYER = "aggs";
    private static final String GRID_FIELD = "grid";
    private static final String BOUNDS_FIELD = "bounds";
    private static final String COUNT_TAG = "_count";
    private static final String ID_TAG = "_id";
    private static final String INDEX_TAG = "_index";
    private static final String KEY_TAG = "_key";
    private static final String MIME_TYPE = "application/vnd.mapbox-vector-tile";
    private static final String INTERNAL_AGG_PREFIX = "_mvt_";
    private static final String CENTROID_AGG_NAME = "_mvt_centroid";

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "{index}/_mvt/{field}/{z}/{x}/{y}"), new RestHandler.Route(RestRequest.Method.POST, "{index}/_mvt/{field}/{z}/{x}/{y}"));
    }

    public String getName() {
        return "vector_tile_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        RestCancellableNodeClient cancellableNodeClient = new RestCancellableNodeClient(client, restRequest.getHttpChannel());
        final VectorTileRequest request = VectorTileRequest.parseRestRequest(restRequest);
        SearchRequestBuilder searchRequestBuilder = RestVectorTileAction.searchRequestBuilder(cancellableNodeClient, request);
        return channel -> searchRequestBuilder.execute((ActionListener)new RestResponseListener<SearchResponse>(channel){

            public RestResponse buildResponse(SearchResponse searchResponse) throws Exception {
                try (BytesStream bytesOut = Streams.flushOnCloseStream((BytesStream)this.channel.bytesOutput());){
                    InternalGeoTileGrid grid;
                    VectorTile.Tile.Builder tileBuilder = VectorTile.Tile.newBuilder();
                    this.ensureOpen();
                    SearchHit[] hits = searchResponse.getHits().getHits();
                    if (hits.length > 0) {
                        tileBuilder.addLayers(RestVectorTileAction.buildHitsLayer(hits, request));
                    }
                    this.ensureOpen();
                    SimpleFeatureFactory geomBuilder = new SimpleFeatureFactory(request.getZ(), request.getX(), request.getY(), request.getExtent());
                    InternalGeoTileGrid internalGeoTileGrid = grid = searchResponse.getAggregations() != null ? (InternalGeoTileGrid)searchResponse.getAggregations().get(RestVectorTileAction.GRID_FIELD) : null;
                    if (grid != null && grid.getBuckets().size() > 0) {
                        tileBuilder.addLayers(RestVectorTileAction.buildAggsLayer(grid, request, geomBuilder));
                    }
                    this.ensureOpen();
                    InternalGeoBounds bounds = searchResponse.getAggregations() != null ? (InternalGeoBounds)searchResponse.getAggregations().get(RestVectorTileAction.BOUNDS_FIELD) : null;
                    Aggregations aggsWithoutGridAndBounds = searchResponse.getAggregations() == null ? null : new Aggregations(searchResponse.getAggregations().asList().stream().filter(a -> !RestVectorTileAction.GRID_FIELD.equals(a.getName()) && !RestVectorTileAction.BOUNDS_FIELD.equals(a.getName())).collect(Collectors.toList()));
                    SearchResponse meta = new SearchResponse(new SearchResponseSections(new SearchHits(SearchHits.EMPTY, searchResponse.getHits().getTotalHits(), searchResponse.getHits().getMaxScore()), aggsWithoutGridAndBounds, searchResponse.getSuggest(), searchResponse.isTimedOut(), searchResponse.isTerminatedEarly(), searchResponse.getProfileResults() == null ? null : new SearchProfileResults(searchResponse.getProfileResults()), searchResponse.getNumReducePhases()), searchResponse.getScrollId(), searchResponse.getTotalShards(), searchResponse.getSuccessfulShards(), searchResponse.getSkippedShards(), searchResponse.getTook().millis(), searchResponse.getShardFailures(), searchResponse.getClusters());
                    tileBuilder.addLayers(RestVectorTileAction.buildMetaLayer(meta, bounds, request, geomBuilder));
                    this.ensureOpen();
                    tileBuilder.build().writeTo((OutputStream)bytesOut);
                    BytesRestResponse bytesRestResponse = new BytesRestResponse(RestStatus.OK, RestVectorTileAction.MIME_TYPE, bytesOut.bytes());
                    return bytesRestResponse;
                }
            }
        });
    }

    private static SearchRequestBuilder searchRequestBuilder(RestCancellableNodeClient client, VectorTileRequest request) throws IOException {
        SearchRequestBuilder searchRequestBuilder = client.prepareSearch(request.getIndexes());
        searchRequestBuilder.setSize(request.getSize());
        searchRequestBuilder.setFetchSource(false);
        searchRequestBuilder.setTrackTotalHitsUpTo(request.getTrackTotalHitsUpTo());
        searchRequestBuilder.addFetchField(new FieldAndFormat(request.getField(), "mvt(" + request.getZ() + "/" + request.getX() + "/" + request.getY() + "@" + request.getExtent() + ")"));
        for (FieldAndFormat field : request.getFieldAndFormats()) {
            searchRequestBuilder.addFetchField(field);
        }
        searchRequestBuilder.setRuntimeMappings(request.getRuntimeMappings());
        GeoShapeQueryBuilder qBuilder = QueryBuilders.geoShapeQuery((String)request.getField(), (Geometry)request.getBoundingBox());
        if (request.getQueryBuilder() != null) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.filter(request.getQueryBuilder());
            boolQueryBuilder.filter((QueryBuilder)qBuilder);
            qBuilder = boolQueryBuilder;
        }
        searchRequestBuilder.setQuery((QueryBuilder)qBuilder);
        if (request.getGridPrecision() > 0) {
            Rectangle rectangle = request.getBoundingBox();
            GeoBoundingBox boundingBox = new GeoBoundingBox(new GeoPoint(rectangle.getMaxLat(), rectangle.getMinLon()), new GeoPoint(rectangle.getMinLat(), rectangle.getMaxLon()));
            int extent = 1 << request.getGridPrecision();
            GeoGridAggregationBuilder tileAggBuilder = ((GeoGridAggregationBuilder)new GeoTileGridAggregationBuilder(GRID_FIELD).field(request.getField())).precision(Math.min(29, request.getZ() + request.getGridPrecision())).setGeoBoundingBox(boundingBox).size(extent * extent);
            searchRequestBuilder.addAggregation((AggregationBuilder)tileAggBuilder);
            searchRequestBuilder.addAggregation((PipelineAggregationBuilder)new StatsBucketPipelineAggregationBuilder(COUNT_TAG, "grid._count"));
            if (request.getGridType() == VectorTileRequest.GRID_TYPE.CENTROID) {
                tileAggBuilder.subAggregation((AggregationBuilder)new GeoCentroidAggregationBuilder(CENTROID_AGG_NAME).field(request.getField()));
            }
            List<ValuesSourceAggregationBuilder.MetricsAggregationBuilder<?, ?>> aggregations = request.getAggBuilder();
            for (ValuesSourceAggregationBuilder.MetricsAggregationBuilder<?, ?> aggregation : aggregations) {
                if (aggregation.getName().startsWith(INTERNAL_AGG_PREFIX)) {
                    throw new IllegalArgumentException("Invalid aggregation name [" + aggregation.getName() + "]. Aggregation names cannot start with prefix '_mvt_'");
                }
                tileAggBuilder.subAggregation(aggregation);
                Set metricNames = aggregation.metricNames();
                for (String metric : metricNames) {
                    String bucketPath = metric.contains(".") ? "grid>" + aggregation.getName() + "[" + metric + "]" : "grid>" + aggregation.getName() + "." + metric;
                    String aggName = metricNames.size() == 1 ? aggregation.getName() : aggregation.getName() + "." + metric;
                    searchRequestBuilder.addAggregation((PipelineAggregationBuilder)new StatsBucketPipelineAggregationBuilder(aggName, bucketPath));
                }
            }
        }
        if (request.getExactBounds()) {
            GeoBoundsAggregationBuilder boundsBuilder = ((GeoBoundsAggregationBuilder)new GeoBoundsAggregationBuilder(BOUNDS_FIELD).field(request.getField())).wrapLongitude(false);
            searchRequestBuilder.addAggregation((AggregationBuilder)boundsBuilder);
        }
        for (SortBuilder<?> sortBuilder : request.getSortBuilders()) {
            searchRequestBuilder.addSort(sortBuilder);
        }
        return searchRequestBuilder;
    }

    private static VectorTile.Tile.Layer.Builder buildHitsLayer(SearchHit[] hits, VectorTileRequest request) throws IOException {
        VectorTile.Tile.Layer.Builder hitsLayerBuilder = VectorTileUtils.createLayerBuilder(HITS_LAYER, request.getExtent());
        List<FieldAndFormat> fields = request.getFieldAndFormats();
        MvtLayerProps layerProps = new MvtLayerProps();
        VectorTile.Tile.Feature.Builder featureBuilder = VectorTile.Tile.Feature.newBuilder();
        for (SearchHit searchHit : hits) {
            DocumentField geoField = searchHit.field(request.getField());
            if (geoField == null) continue;
            for (Object feature : geoField) {
                featureBuilder.clear();
                featureBuilder.mergeFrom((byte[])feature);
                VectorTileUtils.addPropertyToFeature(featureBuilder, layerProps, ID_TAG, searchHit.getId());
                VectorTileUtils.addPropertyToFeature(featureBuilder, layerProps, INDEX_TAG, searchHit.getIndex());
                if (fields != null) {
                    for (FieldAndFormat field : fields) {
                        DocumentField documentField = searchHit.field(field.field);
                        if (documentField == null) continue;
                        VectorTileUtils.addPropertyToFeature(featureBuilder, layerProps, field.field, documentField.getValue());
                    }
                }
                hitsLayerBuilder.addFeatures(featureBuilder);
            }
        }
        VectorTileUtils.addPropertiesToLayer(hitsLayerBuilder, layerProps);
        return hitsLayerBuilder;
    }

    private static VectorTile.Tile.Layer.Builder buildAggsLayer(InternalGeoTileGrid grid, VectorTileRequest request, SimpleFeatureFactory geomBuilder) throws IOException {
        VectorTile.Tile.Layer.Builder aggLayerBuilder = VectorTileUtils.createLayerBuilder(AGGS_LAYER, request.getExtent());
        MvtLayerProps layerProps = new MvtLayerProps();
        VectorTile.Tile.Feature.Builder featureBuilder = VectorTile.Tile.Feature.newBuilder();
        for (InternalGeoGridBucket bucket : grid.getBuckets()) {
            featureBuilder.clear();
            String bucketKey = bucket.getKeyAsString();
            switch (request.getGridType()) {
                case GRID: {
                    Rectangle r = GeoTileUtils.toBoundingBox((String)bucketKey);
                    featureBuilder.mergeFrom(geomBuilder.box(r.getMinLon(), r.getMaxLon(), r.getMinLat(), r.getMaxLat()));
                    break;
                }
                case POINT: {
                    GeoPoint point = (GeoPoint)bucket.getKey();
                    featureBuilder.mergeFrom(geomBuilder.point(point.lon(), point.lat()));
                    break;
                }
                case CENTROID: {
                    Rectangle r = GeoTileUtils.toBoundingBox((String)bucketKey);
                    InternalGeoCentroid centroid = (InternalGeoCentroid)bucket.getAggregations().get(CENTROID_AGG_NAME);
                    double featureLon = Math.min(Math.max(centroid.centroid().lon(), r.getMinLon()), r.getMaxLon());
                    double featureLat = Math.min(Math.max(centroid.centroid().lat(), r.getMinLat()), r.getMaxLat());
                    featureBuilder.mergeFrom(geomBuilder.point(featureLon, featureLat));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported grid type + [" + request.getGridType() + "]");
                }
            }
            VectorTileUtils.addPropertyToFeature(featureBuilder, layerProps, KEY_TAG, bucketKey);
            VectorTileUtils.addPropertyToFeature(featureBuilder, layerProps, COUNT_TAG, bucket.getDocCount());
            for (Aggregation aggregation : bucket.getAggregations()) {
                if (aggregation.getName().startsWith(INTERNAL_AGG_PREFIX)) continue;
                VectorTileUtils.addToXContentToFeature(featureBuilder, layerProps, (ToXContent)aggregation);
            }
            aggLayerBuilder.addFeatures(featureBuilder);
        }
        VectorTileUtils.addPropertiesToLayer(aggLayerBuilder, layerProps);
        return aggLayerBuilder;
    }

    private static VectorTile.Tile.Layer.Builder buildMetaLayer(SearchResponse response, InternalGeoBounds bounds, VectorTileRequest request, SimpleFeatureFactory geomBuilder) throws IOException {
        VectorTile.Tile.Layer.Builder metaLayerBuilder = VectorTileUtils.createLayerBuilder(META_LAYER, request.getExtent());
        MvtLayerProps layerProps = new MvtLayerProps();
        VectorTile.Tile.Feature.Builder featureBuilder = VectorTile.Tile.Feature.newBuilder();
        if (bounds != null && bounds.topLeft() != null) {
            GeoPoint topLeft = bounds.topLeft();
            GeoPoint bottomRight = bounds.bottomRight();
            featureBuilder.mergeFrom(geomBuilder.box(topLeft.lon(), bottomRight.lon(), bottomRight.lat(), topLeft.lat()));
        } else {
            Rectangle tile = request.getBoundingBox();
            featureBuilder.mergeFrom(geomBuilder.box(tile.getMinLon(), tile.getMaxLon(), tile.getMinLat(), tile.getMaxLat()));
        }
        VectorTileUtils.addToXContentToFeature(featureBuilder, layerProps, (ToXContent)response);
        metaLayerBuilder.addFeatures(featureBuilder);
        VectorTileUtils.addPropertiesToLayer(metaLayerBuilder, layerProps);
        return metaLayerBuilder;
    }
}

