/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.action;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.snapshots.SnapshotsInfoService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.autoscaling.AutoscalingLicenseChecker;
import org.elasticsearch.xpack.autoscaling.action.GetAutoscalingCapacityAction;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCalculateCapacityService;
import org.elasticsearch.xpack.autoscaling.capacity.memory.AutoscalingMemoryInfoService;

public class TransportGetAutoscalingCapacityAction
extends TransportMasterNodeAction<GetAutoscalingCapacityAction.Request, GetAutoscalingCapacityAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetAutoscalingCapacityAction.class);
    private final AutoscalingCalculateCapacityService capacityService;
    private final ClusterInfoService clusterInfoService;
    private final SnapshotsInfoService snapshotsInfoService;
    private final AutoscalingMemoryInfoService memoryInfoService;
    private final AutoscalingLicenseChecker autoscalingLicenseChecker;

    @Inject
    public TransportGetAutoscalingCapacityAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutoscalingCalculateCapacityService.Holder capacityServiceHolder, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService, AutoscalingMemoryInfoService memoryInfoService, AllocationDeciders allocationDeciders, AutoscalingLicenseChecker autoscalingLicenseChecker) {
        super("cluster:admin/autoscaling/get_autoscaling_capacity", transportService, clusterService, threadPool, actionFilters, GetAutoscalingCapacityAction.Request::new, indexNameExpressionResolver, GetAutoscalingCapacityAction.Response::new, "same");
        this.snapshotsInfoService = snapshotsInfoService;
        this.memoryInfoService = memoryInfoService;
        this.capacityService = capacityServiceHolder.get(allocationDeciders);
        this.clusterInfoService = clusterInfoService;
        this.autoscalingLicenseChecker = Objects.requireNonNull(autoscalingLicenseChecker);
        assert (this.capacityService != null);
    }

    protected void masterOperation(Task task, GetAutoscalingCapacityAction.Request request, ClusterState state, ActionListener<GetAutoscalingCapacityAction.Response> listener) {
        if (!this.autoscalingLicenseChecker.isAutoscalingAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"autoscaling"));
            return;
        }
        GetAutoscalingCapacityAction.Response response = new GetAutoscalingCapacityAction.Response(this.capacityService.calculate(state, this.clusterInfoService.getClusterInfo(), this.snapshotsInfoService.snapshotShardSizes(), this.memoryInfoService.snapshot()));
        logger.debug("autoscaling capacity response [{}]", (Object)response);
        listener.onResponse((Object)response);
    }

    protected ClusterBlockException checkBlock(GetAutoscalingCapacityAction.Request request, ClusterState state) {
        return null;
    }
}

