/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.cli;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.security.Permission;
import java.security.Policy;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.bootstrap.PluginPolicyInfo;
import org.elasticsearch.bootstrap.PolicyUtil;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;

public class PluginSecurity {
    static void confirmPolicyExceptions(Terminal terminal, Set<String> permissions, boolean batch) throws UserException {
        ArrayList<String> requested = new ArrayList<String>(permissions);
        if (requested.isEmpty()) {
            terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)"plugin has a policy file with no additional permissions");
        } else {
            Collections.sort(requested);
            terminal.errorPrintln(Terminal.Verbosity.NORMAL, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            terminal.errorPrintln(Terminal.Verbosity.NORMAL, "@     WARNING: plugin requires additional permissions     @");
            terminal.errorPrintln(Terminal.Verbosity.NORMAL, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            for (String permission : requested) {
                terminal.errorPrintln(Terminal.Verbosity.NORMAL, "* " + permission);
            }
            terminal.errorPrintln(Terminal.Verbosity.NORMAL, "See http://docs.oracle.com/javase/8/docs/technotes/guides/security/permissions.html");
            terminal.errorPrintln(Terminal.Verbosity.NORMAL, "for descriptions of what these permissions allow and the associated risks.");
            PluginSecurity.prompt(terminal, batch);
        }
    }

    private static void prompt(Terminal terminal, boolean batch) throws UserException {
        if (!batch) {
            terminal.println(Terminal.Verbosity.NORMAL, (CharSequence)"");
            String text = terminal.readText("Continue with installation? [y/N]");
            if (!text.equalsIgnoreCase("y")) {
                throw new UserException(65, "installation aborted by user");
            }
        }
    }

    static String formatPermission(Permission permission) {
        StringBuilder sb = new StringBuilder();
        String clazz = null;
        clazz = permission instanceof UnresolvedPermission ? ((UnresolvedPermission)permission).getUnresolvedType() : permission.getClass().getName();
        sb.append(clazz);
        String name = null;
        name = permission instanceof UnresolvedPermission ? ((UnresolvedPermission)permission).getUnresolvedName() : permission.getName();
        if (name != null && name.length() > 0) {
            sb.append(' ');
            sb.append(name);
        }
        String actions = null;
        actions = permission instanceof UnresolvedPermission ? ((UnresolvedPermission)permission).getUnresolvedActions() : permission.getActions();
        if (actions != null && actions.length() > 0) {
            sb.append(' ');
            sb.append(actions);
        }
        return sb.toString();
    }

    static Set<String> getPermissionDescriptions(PluginPolicyInfo pluginPolicyInfo, Path tmpDir) throws IOException {
        HashSet allPermissions = new HashSet(PolicyUtil.getPolicyPermissions(null, (Policy)pluginPolicyInfo.policy, (Path)tmpDir));
        for (URL jar : pluginPolicyInfo.jars) {
            Set jarPermissions = PolicyUtil.getPolicyPermissions((URL)jar, (Policy)pluginPolicyInfo.policy, (Path)tmpDir);
            allPermissions.addAll(jarPermissions);
        }
        return allPermissions.stream().map(PluginSecurity::formatPermission).collect(Collectors.toSet());
    }
}

