/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.grok.MatcherWatchdog;
import org.elasticsearch.ingest.DropProcessor;
import org.elasticsearch.ingest.PipelineProcessor;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.AppendProcessor;
import org.elasticsearch.ingest.common.BytesProcessor;
import org.elasticsearch.ingest.common.CommunityIdProcessor;
import org.elasticsearch.ingest.common.ConvertProcessor;
import org.elasticsearch.ingest.common.CsvProcessor;
import org.elasticsearch.ingest.common.DateIndexNameProcessor;
import org.elasticsearch.ingest.common.DateProcessor;
import org.elasticsearch.ingest.common.DissectProcessor;
import org.elasticsearch.ingest.common.DotExpanderProcessor;
import org.elasticsearch.ingest.common.FailProcessor;
import org.elasticsearch.ingest.common.FingerprintProcessor;
import org.elasticsearch.ingest.common.ForEachProcessor;
import org.elasticsearch.ingest.common.GrokProcessor;
import org.elasticsearch.ingest.common.GrokProcessorGetAction;
import org.elasticsearch.ingest.common.GsubProcessor;
import org.elasticsearch.ingest.common.HtmlStripProcessor;
import org.elasticsearch.ingest.common.JoinProcessor;
import org.elasticsearch.ingest.common.JsonProcessor;
import org.elasticsearch.ingest.common.KeyValueProcessor;
import org.elasticsearch.ingest.common.LowercaseProcessor;
import org.elasticsearch.ingest.common.NetworkDirectionProcessor;
import org.elasticsearch.ingest.common.RegisteredDomainProcessor;
import org.elasticsearch.ingest.common.RemoveProcessor;
import org.elasticsearch.ingest.common.RenameProcessor;
import org.elasticsearch.ingest.common.ScriptProcessor;
import org.elasticsearch.ingest.common.SetProcessor;
import org.elasticsearch.ingest.common.SortProcessor;
import org.elasticsearch.ingest.common.SplitProcessor;
import org.elasticsearch.ingest.common.TrimProcessor;
import org.elasticsearch.ingest.common.URLDecodeProcessor;
import org.elasticsearch.ingest.common.UppercaseProcessor;
import org.elasticsearch.ingest.common.UriPartsProcessor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;

public class IngestCommonPlugin
extends Plugin
implements ActionPlugin,
IngestPlugin {
    static final Setting<TimeValue> WATCHDOG_INTERVAL = Setting.timeSetting((String)"ingest.grok.watchdog.interval", (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<TimeValue> WATCHDOG_MAX_EXECUTION_TIME = Setting.timeSetting((String)"ingest.grok.watchdog.max_execution_time", (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        return Map.ofEntries(Map.entry("date", new DateProcessor.Factory(parameters.scriptService)), Map.entry("set", new SetProcessor.Factory(parameters.scriptService)), Map.entry("append", new AppendProcessor.Factory(parameters.scriptService)), Map.entry("rename", new RenameProcessor.Factory(parameters.scriptService)), Map.entry("remove", new RemoveProcessor.Factory(parameters.scriptService)), Map.entry("split", new SplitProcessor.Factory()), Map.entry("join", new JoinProcessor.Factory()), Map.entry("uppercase", new UppercaseProcessor.Factory()), Map.entry("lowercase", new LowercaseProcessor.Factory()), Map.entry("trim", new TrimProcessor.Factory()), Map.entry("convert", new ConvertProcessor.Factory()), Map.entry("gsub", new GsubProcessor.Factory()), Map.entry("fail", new FailProcessor.Factory(parameters.scriptService)), Map.entry("foreach", new ForEachProcessor.Factory(parameters.scriptService)), Map.entry("date_index_name", new DateIndexNameProcessor.Factory(parameters.scriptService)), Map.entry("sort", new SortProcessor.Factory()), Map.entry("grok", new GrokProcessor.Factory(IngestCommonPlugin.createGrokThreadWatchdog(parameters))), Map.entry("script", new ScriptProcessor.Factory(parameters.scriptService)), Map.entry("dot_expander", new DotExpanderProcessor.Factory()), Map.entry("json", new JsonProcessor.Factory()), Map.entry("kv", new KeyValueProcessor.Factory(parameters.scriptService)), Map.entry("urldecode", new URLDecodeProcessor.Factory()), Map.entry("bytes", new BytesProcessor.Factory()), Map.entry("pipeline", new PipelineProcessor.Factory(parameters.ingestService)), Map.entry("dissect", new DissectProcessor.Factory()), Map.entry("drop", new DropProcessor.Factory()), Map.entry("html_strip", new HtmlStripProcessor.Factory()), Map.entry("csv", new CsvProcessor.Factory()), Map.entry("uri_parts", new UriPartsProcessor.Factory()), Map.entry("network_direction", new NetworkDirectionProcessor.Factory(parameters.scriptService)), Map.entry("community_id", new CommunityIdProcessor.Factory()), Map.entry("fingerprint", new FingerprintProcessor.Factory()), Map.entry("registered_domain", new RegisteredDomainProcessor.Factory()));
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Collections.singletonList(new ActionPlugin.ActionHandler((ActionType)GrokProcessorGetAction.INSTANCE, GrokProcessorGetAction.TransportAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Collections.singletonList(new GrokProcessorGetAction.RestAction());
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(WATCHDOG_INTERVAL, WATCHDOG_MAX_EXECUTION_TIME);
    }

    private static MatcherWatchdog createGrokThreadWatchdog(Processor.Parameters parameters) {
        long intervalMillis = ((TimeValue)WATCHDOG_INTERVAL.get(parameters.env.settings())).getMillis();
        long maxExecutionTimeMillis = ((TimeValue)WATCHDOG_MAX_EXECUTION_TIME.get(parameters.env.settings())).getMillis();
        return MatcherWatchdog.newInstance((long)intervalMillis, (long)maxExecutionTimeMillis, (LongSupplier)parameters.relativeTimeSupplier, parameters.scheduler::apply);
    }
}

