/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.grok;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.grok.GrokCaptureConfig;
import org.elasticsearch.grok.GrokCaptureExtracter;
import org.elasticsearch.grok.MatcherWatchdog;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;

public final class Grok {
    public static final String[] ECS_COMPATIBILITY_MODES = new String[]{"disabled", "v1"};
    private static Map<String, String> LEGACY_PATTERNS;
    private static Map<String, String> ECS_V1_PATTERNS;
    private static final String NAME_GROUP = "name";
    private static final String SUBNAME_GROUP = "subname";
    private static final String PATTERN_GROUP = "pattern";
    private static final String DEFINITION_GROUP = "definition";
    private static final String GROK_PATTERN = "%\\{(?<name>(?<pattern>[A-z0-9]+)(?::(?<subname>[[:alnum:]@\\[\\]_:.-]+))?)(?:=(?<definition>(?:[^{}]+|\\.+)+))?\\}";
    private static final Regex GROK_PATTERN_REGEX;
    private static final int MAX_TO_REGEX_ITERATIONS = 100000;
    private final Map<String, String> patternBank;
    private final boolean namedCaptures;
    private final Regex compiledExpression;
    private final MatcherWatchdog matcherWatchdog;
    private final List<GrokCaptureConfig> captureConfig;

    public Grok(Map<String, String> patternBank, String grokPattern, Consumer<String> logCallBack) {
        this(patternBank, grokPattern, true, MatcherWatchdog.noop(), logCallBack);
    }

    public Grok(Map<String, String> patternBank, String grokPattern, MatcherWatchdog matcherWatchdog, Consumer<String> logCallBack) {
        this(patternBank, grokPattern, true, matcherWatchdog, logCallBack);
    }

    Grok(Map<String, String> patternBank, String grokPattern, boolean namedCaptures, Consumer<String> logCallBack) {
        this(patternBank, grokPattern, namedCaptures, MatcherWatchdog.noop(), logCallBack);
    }

    private Grok(Map<String, String> patternBank, String grokPattern, boolean namedCaptures, MatcherWatchdog matcherWatchdog, Consumer<String> logCallBack) {
        this.patternBank = patternBank;
        this.namedCaptures = namedCaptures;
        this.matcherWatchdog = matcherWatchdog;
        this.forbidCircularReferences();
        String expression = this.toRegex(grokPattern);
        byte[] expressionBytes = expression.getBytes(StandardCharsets.UTF_8);
        this.compiledExpression = new Regex(expressionBytes, 0, expressionBytes.length, 0, (Encoding)UTF8Encoding.INSTANCE, message -> logCallBack.accept(message));
        ArrayList<GrokCaptureConfig> grokCaptureConfigs = new ArrayList<GrokCaptureConfig>();
        Iterator entry = this.compiledExpression.namedBackrefIterator();
        while (entry.hasNext()) {
            grokCaptureConfigs.add(new GrokCaptureConfig((NameEntry)entry.next()));
        }
        this.captureConfig = List.copyOf(grokCaptureConfigs);
    }

    private void forbidCircularReferences() {
        for (Map.Entry<String, String> entry : this.patternBank.entrySet()) {
            if (!Grok.patternReferencesItself(entry.getValue(), entry.getKey())) continue;
            throw new IllegalArgumentException("circular reference in pattern [" + entry.getKey() + "][" + entry.getValue() + "]");
        }
        for (Map.Entry<String, String> entry : this.patternBank.entrySet()) {
            String name = entry.getKey();
            String pattern = entry.getValue();
            this.innerForbidCircularReferences(name, new ArrayList<String>(), pattern);
        }
    }

    private void innerForbidCircularReferences(String patternName, List<String> path, String pattern) {
        if (Grok.patternReferencesItself(pattern, patternName)) {
            String message;
            if (path.isEmpty()) {
                message = "circular reference in pattern [" + patternName + "][" + pattern + "]";
            } else {
                message = "circular reference in pattern [" + path.remove(path.size() - 1) + "][" + pattern + "] back to pattern [" + patternName + "]";
                if (!path.isEmpty()) {
                    message = message + " via patterns [" + String.join((CharSequence)"=>", path) + "]";
                }
            }
            throw new IllegalArgumentException(message);
        }
        int i = pattern.indexOf("%{");
        while (i != -1) {
            int end;
            int begin = i + 2;
            int bracketIndex = pattern.indexOf(125, begin);
            int columnIndex = pattern.indexOf(58, begin);
            if (bracketIndex != -1 && columnIndex == -1) {
                end = bracketIndex;
            } else if (columnIndex != -1 && bracketIndex == -1) {
                end = columnIndex;
            } else if (bracketIndex != -1 && columnIndex != -1) {
                end = Math.min(bracketIndex, columnIndex);
            } else {
                throw new IllegalArgumentException("pattern [" + pattern + "] has circular references to other pattern definitions");
            }
            String otherPatternName = pattern.substring(begin, end);
            path.add(otherPatternName);
            this.innerForbidCircularReferences(patternName, path, this.patternBank.get(otherPatternName));
            i = pattern.indexOf("%{", i + 1);
        }
    }

    private static boolean patternReferencesItself(String pattern, String patternName) {
        return pattern.contains("%{" + patternName + "}") || pattern.contains("%{" + patternName + ":");
    }

    private String groupMatch(String name, Region region, String pattern) {
        int number = GROK_PATTERN_REGEX.nameToBackrefNumber(name.getBytes(StandardCharsets.UTF_8), 0, name.getBytes(StandardCharsets.UTF_8).length, region);
        int begin = region.beg[number];
        int end = region.end[number];
        if (begin < 0) {
            return null;
        }
        return new String(pattern.getBytes(StandardCharsets.UTF_8), begin, end - begin, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String toRegex(String grokPattern) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < 100000; ++i) {
            int result;
            byte[] grokPatternBytes = ((String)grokPattern).getBytes(StandardCharsets.UTF_8);
            Matcher matcher = GROK_PATTERN_REGEX.matcher(grokPatternBytes);
            try {
                this.matcherWatchdog.register(matcher);
                result = matcher.search(0, grokPatternBytes.length, 0);
            }
            finally {
                this.matcherWatchdog.unregister(matcher);
            }
            if (result < 0) {
                return res.append((String)grokPattern).toString();
            }
            Region region = matcher.getEagerRegion();
            String namedPatternRef = this.groupMatch(NAME_GROUP, region, (String)grokPattern);
            String subName = this.groupMatch(SUBNAME_GROUP, region, (String)grokPattern);
            String definition = this.groupMatch(DEFINITION_GROUP, region, (String)grokPattern);
            String patternName = this.groupMatch(PATTERN_GROUP, region, (String)grokPattern);
            String pattern = this.patternBank.get(patternName);
            if (pattern == null) {
                throw new IllegalArgumentException("Unable to find pattern [" + patternName + "] in Grok's pattern dictionary");
            }
            if (pattern.contains("%{" + patternName + "}") || pattern.contains("%{" + patternName + ":")) {
                throw new IllegalArgumentException("circular reference in pattern back [" + patternName + "]");
            }
            String grokPart = this.namedCaptures && subName != null ? String.format(Locale.US, "(?<%s>%s)", namedPatternRef, pattern) : (this.namedCaptures ? String.format(Locale.US, "(?:%s)", pattern) : String.format(Locale.US, "(?<%s>%s)", patternName + "_" + result, pattern));
            String start = new String(grokPatternBytes, 0, result, StandardCharsets.UTF_8);
            String rest = new String(grokPatternBytes, region.end[0], grokPatternBytes.length - region.end[0], StandardCharsets.UTF_8);
            grokPattern = grokPart + rest;
            res.append(start);
        }
        throw new IllegalArgumentException("Can not convert grok patterns to regular expression");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(String text) {
        int result;
        Matcher matcher = this.compiledExpression.matcher(text.getBytes(StandardCharsets.UTF_8));
        try {
            this.matcherWatchdog.register(matcher);
            result = matcher.search(0, text.length(), 0);
        }
        finally {
            this.matcherWatchdog.unregister(matcher);
        }
        return result != -1;
    }

    public Map<String, Object> captures(String text) {
        GrokCaptureExtracter.MapExtracter extracter;
        byte[] utf8Bytes = text.getBytes(StandardCharsets.UTF_8);
        if (this.match(utf8Bytes, 0, utf8Bytes.length, extracter = new GrokCaptureExtracter.MapExtracter(this.captureConfig))) {
            return extracter.result();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(byte[] utf8Bytes, int offset, int length, GrokCaptureExtracter extracter) {
        int result;
        Matcher matcher = this.compiledExpression.matcher(utf8Bytes, offset, offset + length);
        try {
            this.matcherWatchdog.register(matcher);
            result = matcher.search(offset, length, 0);
        }
        finally {
            this.matcherWatchdog.unregister(matcher);
        }
        if (result == -2) {
            throw new RuntimeException("grok pattern matching was interrupted after [" + this.matcherWatchdog.maxExecutionTimeInMillis() + "] ms");
        }
        if (result == -1) {
            return false;
        }
        extracter.extract(utf8Bytes, offset, matcher.getEagerRegion());
        return true;
    }

    public List<GrokCaptureConfig> captureConfig() {
        return this.captureConfig;
    }

    public static synchronized Map<String, String> getBuiltinPatterns(boolean ecsCompatibility) {
        if (ecsCompatibility) {
            if (ECS_V1_PATTERNS == null) {
                ECS_V1_PATTERNS = Grok.loadPatterns(ecsCompatibility);
            }
            return ECS_V1_PATTERNS;
        }
        if (LEGACY_PATTERNS == null) {
            LEGACY_PATTERNS = Grok.loadPatterns(ecsCompatibility);
        }
        return LEGACY_PATTERNS;
    }

    public static Map<String, String> getBuiltinPatterns(String ecsCompatibility) {
        if (Grok.isValidEcsCompatibilityMode(ecsCompatibility)) {
            return Grok.getBuiltinPatterns(ECS_COMPATIBILITY_MODES[1].equals(ecsCompatibility));
        }
        throw new IllegalArgumentException("unsupported ECS compatibility mode [" + ecsCompatibility + "]");
    }

    public static boolean isValidEcsCompatibilityMode(String ecsCompatibility) {
        return Arrays.asList(ECS_COMPATIBILITY_MODES).contains(ecsCompatibility);
    }

    private static Map<String, String> loadPatterns(boolean ecsCompatibility) {
        String[] legacyPatternNames = new String[]{"aws", "bacula", "bind", "bro", "exim", "firewalls", "grok-patterns", "haproxy", "httpd", "java", "junos", "linux-syslog", "maven", "mcollective-patterns", "mongodb", "nagios", "postgresql", "rails", "redis", "ruby", "squid"};
        String[] ecsPatternNames = new String[]{"aws", "bacula", "bind", "bro", "exim", "firewalls", "grok-patterns", "haproxy", "httpd", "java", "junos", "linux-syslog", "maven", "mcollective", "mongodb", "nagios", "postgresql", "rails", "redis", "ruby", "squid", "zeek"};
        String[] patternNames = ecsCompatibility ? ecsPatternNames : legacyPatternNames;
        String directory = ecsCompatibility ? "/patterns/ecs-v1/" : "/patterns/legacy/";
        LinkedHashMap<String, String> builtinPatterns = new LinkedHashMap<String, String>();
        for (String pattern : patternNames) {
            try (InputStream is = Grok.class.getResourceAsStream(directory + pattern);){
                Grok.loadPatterns(builtinPatterns, is);
            }
            catch (IOException e) {
                throw new RuntimeException("failed to load built-in patterns", e);
            }
        }
        return Collections.unmodifiableMap(builtinPatterns);
    }

    private static void loadPatterns(Map<String, String> patternBank, InputStream inputStream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = br.readLine()) != null) {
            String[] parts;
            String trimmedLine = line.replaceAll("^\\s+", "");
            if (trimmedLine.startsWith("#") || trimmedLine.length() == 0 || (parts = trimmedLine.split("\\s+", 2)).length != 2) continue;
            patternBank.put(parts[0], parts[1]);
        }
    }

    static {
        GROK_PATTERN_REGEX = new Regex(GROK_PATTERN.getBytes(StandardCharsets.UTF_8), 0, GROK_PATTERN.getBytes(StandardCharsets.UTF_8).length, 0, (Encoding)UTF8Encoding.INSTANCE, Syntax.DEFAULT);
    }
}

