/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logstash.action;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.logstash.action.GetPipelineRequest;
import org.elasticsearch.xpack.logstash.action.GetPipelineResponse;

public class TransportGetPipelineAction
extends HandledTransportAction<GetPipelineRequest, GetPipelineResponse> {
    private static final Logger logger = LogManager.getLogger(TransportGetPipelineAction.class);
    private final Client client;

    @Inject
    public TransportGetPipelineAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/logstash/pipeline/get", transportService, actionFilters, GetPipelineRequest::new);
        this.client = new OriginSettingClient(client, "logstash_management");
    }

    protected void doExecute(Task task, GetPipelineRequest request, ActionListener<GetPipelineResponse> listener) {
        if (request.ids().isEmpty()) {
            this.client.prepareSearch(new String[]{".logstash"}).setSource(SearchSourceBuilder.searchSource().fetchSource(true).query((QueryBuilder)QueryBuilders.matchAllQuery()).size(1000).trackTotalHits(true)).setScroll(TimeValue.timeValueMinutes((long)1L)).execute(ActionListener.wrap(searchResponse -> {
                int numHits = Math.toIntExact(searchResponse.getHits().getTotalHits().value);
                HashMap<String, BytesReference> pipelineSources = new HashMap<String, BytesReference>(numHits);
                Consumer<SearchResponse> clearScroll = response -> {
                    if (response != null && response.getScrollId() != null) {
                        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                        clearScrollRequest.addScrollId(response.getScrollId());
                        this.client.clearScroll(clearScrollRequest, ActionListener.wrap(r -> {}, e -> logger.warn((Message)new ParameterizedMessage("clear scroll failed for scroll id [{}]", (Object)response.getScrollId()), (Throwable)e)));
                    }
                };
                this.handleSearchResponse((SearchResponse)searchResponse, (Map<String, BytesReference>)pipelineSources, clearScroll, listener);
            }, e -> this.handleFailure((Exception)e, listener)));
        } else if (request.ids().size() == 1) {
            this.client.prepareGet(".logstash", request.ids().get(0)).setFetchSource(true).execute(ActionListener.wrap(response -> {
                if (response.isExists()) {
                    listener.onResponse((Object)new GetPipelineResponse(Map.of(response.getId(), response.getSourceAsBytesRef())));
                } else {
                    listener.onResponse((Object)new GetPipelineResponse(Map.of()));
                }
            }, e -> this.handleFailure((Exception)e, listener)));
        } else {
            this.client.prepareMultiGet().addIds(".logstash", request.ids()).execute(ActionListener.wrap(mGetResponse -> {
                this.logFailures((MultiGetResponse)mGetResponse);
                listener.onResponse((Object)new GetPipelineResponse(Arrays.stream(mGetResponse.getResponses()).filter(itemResponse -> !itemResponse.isFailed()).filter(itemResponse -> itemResponse.getResponse().isExists()).map(MultiGetItemResponse::getResponse).collect(Collectors.toMap(GetResponse::getId, GetResponse::getSourceAsBytesRef))));
            }, e -> this.handleFailure((Exception)e, listener)));
        }
    }

    private void handleFailure(Exception e, ActionListener<GetPipelineResponse> listener) {
        Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
        if (cause instanceof IndexNotFoundException) {
            listener.onResponse((Object)new GetPipelineResponse(Map.of()));
        } else {
            listener.onFailure(e);
        }
    }

    private void handleSearchResponse(SearchResponse searchResponse, Map<String, BytesReference> pipelineSources, Consumer<SearchResponse> clearScroll, ActionListener<GetPipelineResponse> listener) {
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            pipelineSources.put(hit.getId(), hit.getSourceRef());
        }
        if ((long)pipelineSources.size() > searchResponse.getHits().getTotalHits().value) {
            clearScroll.accept(searchResponse);
            listener.onFailure((Exception)new IllegalStateException("scrolling returned more hits [" + pipelineSources.size() + "] than expected [" + searchResponse.getHits().getTotalHits().value + "] so bailing out to prevent unbounded memory consumption."));
        } else if ((long)pipelineSources.size() == searchResponse.getHits().getTotalHits().value) {
            clearScroll.accept(searchResponse);
            listener.onResponse((Object)new GetPipelineResponse(pipelineSources));
        } else {
            this.client.prepareSearchScroll(searchResponse.getScrollId()).setScroll(TimeValue.timeValueMinutes((long)1L)).execute(ActionListener.wrap(searchResponse1 -> this.handleSearchResponse((SearchResponse)searchResponse1, pipelineSources, clearScroll, listener), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void logFailures(MultiGetResponse multiGetResponse) {
        List ids = Arrays.stream(multiGetResponse.getResponses()).filter(MultiGetItemResponse::isFailed).filter(itemResponse -> itemResponse.getFailure() != null).map(itemResponse -> itemResponse.getFailure().getId()).collect(Collectors.toList());
        if (!ids.isEmpty()) {
            logger.info("Could not retrieve logstash pipelines with ids: {}", ids);
        }
    }
}

