/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.extras;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafSimScorer;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.common.CheckedIntFunction;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;

public final class SourceConfirmedTextQuery
extends Query {
    private static final Similarity FREQ_SIMILARITY = new Similarity(){

        public long computeNorm(FieldInvertState state) {
            return 1L;
        }

        public Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
            return new Similarity.SimScorer(){

                public float score(float freq, long norm) {
                    return freq;
                }
            };
        }
    };
    private final Query in;
    private final Function<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> valueFetcherProvider;
    private final Analyzer indexAnalyzer;

    public static Query approximate(Query query) {
        if (query instanceof TermQuery) {
            return query;
        }
        if (query instanceof PhraseQuery) {
            return SourceConfirmedTextQuery.approximate((PhraseQuery)query);
        }
        if (query instanceof MultiPhraseQuery) {
            return SourceConfirmedTextQuery.approximate((MultiPhraseQuery)query);
        }
        if (query instanceof MultiPhrasePrefixQuery) {
            return SourceConfirmedTextQuery.approximate((MultiPhrasePrefixQuery)query);
        }
        return new MatchAllDocsQuery();
    }

    private static Query approximate(PhraseQuery query) {
        BooleanQuery.Builder approximation = new BooleanQuery.Builder();
        for (Term term : query.getTerms()) {
            approximation.add((Query)new TermQuery(term), BooleanClause.Occur.FILTER);
        }
        return approximation.build();
    }

    private static Query approximate(MultiPhraseQuery query) {
        BooleanQuery.Builder approximation = new BooleanQuery.Builder();
        for (Term[] termArray : query.getTermArrays()) {
            BooleanQuery.Builder approximationClause = new BooleanQuery.Builder();
            for (Term term : termArray) {
                approximationClause.add((Query)new TermQuery(term), BooleanClause.Occur.SHOULD);
            }
            approximation.add((Query)approximationClause.build(), BooleanClause.Occur.FILTER);
        }
        return approximation.build();
    }

    private static Query approximate(MultiPhrasePrefixQuery query) {
        Term[][] terms = query.getTerms();
        if (terms.length == 0) {
            return new MatchNoDocsQuery();
        }
        if (terms.length == 1) {
            BooleanQuery.Builder approximation = new BooleanQuery.Builder();
            for (Term term : terms[0]) {
                approximation.add((Query)new PrefixQuery(term), BooleanClause.Occur.FILTER);
            }
            return approximation.build();
        }
        BooleanQuery.Builder approximation = new BooleanQuery.Builder();
        for (int i = 0; i < terms.length - 1; ++i) {
            Term[] termArray = terms[i];
            BooleanQuery.Builder approximationClause = new BooleanQuery.Builder();
            for (Term term : termArray) {
                approximationClause.add((Query)new TermQuery(term), BooleanClause.Occur.SHOULD);
            }
            approximation.add((Query)approximationClause.build(), BooleanClause.Occur.FILTER);
        }
        return approximation.build();
    }

    public SourceConfirmedTextQuery(Query in, Function<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> valueFetcherProvider, Analyzer indexAnalyzer) {
        this.in = in;
        this.valueFetcherProvider = valueFetcherProvider;
        this.indexAnalyzer = indexAnalyzer;
    }

    public Query getQuery() {
        return this.in;
    }

    public String toString(String field) {
        return this.in.toString(field);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        SourceConfirmedTextQuery that = (SourceConfirmedTextQuery)((Object)obj);
        return Objects.equals(this.in, that.in) && Objects.equals(this.valueFetcherProvider, that.valueFetcherProvider) && Objects.equals(this.indexAnalyzer, that.indexAnalyzer);
    }

    public int hashCode() {
        return 31 * Objects.hash(this.in, this.valueFetcherProvider, this.indexAnalyzer) + this.classHash();
    }

    public void visit(QueryVisitor visitor) {
        this.in.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, (Query)this));
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query inRewritten = this.in.rewrite(reader);
        if (inRewritten != this.in) {
            return new SourceConfirmedTextQuery(inRewritten, this.valueFetcherProvider, this.indexAnalyzer);
        }
        if (this.in instanceof ConstantScoreQuery) {
            Query sub = ((ConstantScoreQuery)this.in).getQuery();
            return new ConstantScoreQuery((Query)new SourceConfirmedTextQuery(sub, this.valueFetcherProvider, this.indexAnalyzer));
        }
        if (this.in instanceof BoostQuery) {
            Query sub = ((BoostQuery)this.in).getQuery();
            float boost = ((BoostQuery)this.in).getBoost();
            return new BoostQuery((Query)new SourceConfirmedTextQuery(sub, this.valueFetcherProvider, this.indexAnalyzer), boost);
        }
        if (this.in instanceof MatchNoDocsQuery) {
            return this.in;
        }
        return super.rewrite(reader);
    }

    public Weight createWeight(final IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        if (!scoreMode.needsScores() && this.in instanceof TermQuery) {
            return this.in.createWeight(searcher, scoreMode, boost);
        }
        HashSet terms = new HashSet();
        this.in.visit(QueryVisitor.termCollector(terms));
        if (terms.isEmpty()) {
            throw new IllegalStateException("Query " + this.in + " doesn't have any term");
        }
        final String field = ((Term)terms.iterator().next()).field();
        HashMap<Term, TermStates> termStates = new HashMap<Term, TermStates>();
        ArrayList<TermStatistics> termStats = new ArrayList<TermStatistics>();
        for (Term term : terms) {
            TermStates ts = termStates.computeIfAbsent(term, t -> {
                try {
                    return TermStates.build((IndexReaderContext)searcher.getTopReaderContext(), (Term)t, (boolean)scoreMode.needsScores());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            if (scoreMode.needsScores()) {
                if (ts.docFreq() <= 0) continue;
                termStats.add(searcher.termStatistics(term, ts.docFreq(), ts.totalTermFreq()));
                continue;
            }
            termStats.add(new TermStatistics(term.bytes(), 1L, 1L));
        }
        final Similarity.SimScorer simScorer = searcher.getSimilarity().scorer(boost, searcher.collectionStatistics(field), (TermStatistics[])termStats.toArray(TermStatistics[]::new));
        final Weight approximationWeight = searcher.createWeight(SourceConfirmedTextQuery.approximate(this.in), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        return new Weight(this){

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                RuntimePhraseScorer scorer = this.scorer(context);
                if (scorer == null) {
                    return Explanation.noMatch((String)"No matching phrase", (Explanation[])new Explanation[0]);
                }
                TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
                if (twoPhase.approximation().advance(doc) != doc || !scorer.twoPhaseIterator().matches()) {
                    return Explanation.noMatch((String)"No matching phrase", (Explanation[])new Explanation[0]);
                }
                float phraseFreq = scorer.freq();
                Explanation freqExplanation = Explanation.match((Number)Float.valueOf(phraseFreq), (String)("phraseFreq=" + phraseFreq), (Explanation[])new Explanation[0]);
                LeafSimScorer leafSimScorer = new LeafSimScorer(simScorer, context.reader(), field, scoreMode.needsScores());
                Explanation scoreExplanation = leafSimScorer.explain(doc, freqExplanation);
                return Explanation.match((Number)scoreExplanation.getValue(), (String)("weight(" + this.getQuery() + " in " + doc + ") [" + searcher.getSimilarity().getClass().getSimpleName() + "], result of:"), (Explanation[])new Explanation[]{scoreExplanation});
            }

            public RuntimePhraseScorer scorer(LeafReaderContext context) throws IOException {
                Scorer approximationScorer = approximationWeight.scorer(context);
                if (approximationScorer == null) {
                    return null;
                }
                DocIdSetIterator approximation = approximationScorer.iterator();
                LeafSimScorer leafSimScorer = new LeafSimScorer(simScorer, context.reader(), field, scoreMode.needsScores());
                CheckedIntFunction<List<Object>, IOException> valueFetcher = SourceConfirmedTextQuery.this.valueFetcherProvider.apply(context);
                return new RuntimePhraseScorer(this, approximation, leafSimScorer, valueFetcher, field, SourceConfirmedTextQuery.this.in);
            }
        };
    }

    private class RuntimePhraseScorer
    extends Scorer {
        private final LeafSimScorer scorer;
        private final CheckedIntFunction<List<Object>, IOException> valueFetcher;
        private final String field;
        private final Query query;
        private final TwoPhaseIterator twoPhase;
        private int doc;
        private float freq;

        private RuntimePhraseScorer(Weight weight, DocIdSetIterator approximation, LeafSimScorer scorer, CheckedIntFunction<List<Object>, IOException> valueFetcher, String field, Query query) {
            super(weight);
            this.doc = -1;
            this.scorer = scorer;
            this.valueFetcher = valueFetcher;
            this.field = field;
            this.query = query;
            this.twoPhase = new TwoPhaseIterator(approximation){

                public boolean matches() throws IOException {
                    return RuntimePhraseScorer.this.freq() > 0.0f;
                }

                public float matchCost() {
                    return 10000.0f;
                }
            };
        }

        public DocIdSetIterator iterator() {
            return TwoPhaseIterator.asDocIdSetIterator((TwoPhaseIterator)this.twoPhaseIterator());
        }

        public TwoPhaseIterator twoPhaseIterator() {
            return this.twoPhase;
        }

        public float getMaxScore(int upTo) throws IOException {
            return this.scorer.getSimScorer().score(Float.MAX_VALUE, 1L);
        }

        public float score() throws IOException {
            return this.scorer.score(this.docID(), this.freq());
        }

        public int docID() {
            return this.twoPhase.approximation().docID();
        }

        private float freq() throws IOException {
            if (this.doc != this.docID()) {
                this.doc = this.docID();
                this.freq = this.computeFreq();
            }
            return this.freq;
        }

        private float computeFreq() throws IOException {
            MemoryIndex index = new MemoryIndex();
            index.setSimilarity(FREQ_SIMILARITY);
            List values = (List)this.valueFetcher.apply(this.docID());
            float freq = 0.0f;
            for (Object value : values) {
                if (value == null) continue;
                index.addField(this.field, value.toString(), SourceConfirmedTextQuery.this.indexAnalyzer);
                freq += index.search(this.query);
                index.reset();
            }
            return freq;
        }
    }
}

