/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.CustomDocValuesField;
import org.elasticsearch.xpack.spatial.index.fielddata.CentroidCalculator;
import org.elasticsearch.xpack.spatial.index.fielddata.CoordinateEncoder;
import org.elasticsearch.xpack.spatial.index.fielddata.GeometryDocValueWriter;

public class BinaryGeoShapeDocValuesField
extends CustomDocValuesField {
    private final List<IndexableField> fields = new ArrayList<IndexableField>();
    private final CentroidCalculator centroidCalculator = new CentroidCalculator();

    public BinaryGeoShapeDocValuesField(String name) {
        super(name);
    }

    public void add(List<IndexableField> fields, Geometry geometry) {
        this.fields.addAll(fields);
        this.centroidCalculator.add(geometry);
    }

    public BytesRef binaryValue() {
        try {
            return GeometryDocValueWriter.write(this.fields, CoordinateEncoder.GEO, this.centroidCalculator);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to encode shape", (Throwable)e, new Object[0]);
        }
    }
}

