/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.support;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.elasticsearch.core.internal.io.IOUtils;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class XmlValidator {
    private final SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private final String xsdName;

    public XmlValidator(String xsdName) {
        this.xsdName = xsdName;
    }

    public void validate(String xml) throws Exception {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));){
            this.validate(stream);
        }
    }

    public void validate(InputStream xml) throws Exception {
        try (InputStream xsdStream = this.loadSchema(this.xsdName);
             ResourceResolver resolver = new ResourceResolver();){
            this.schemaFactory.setResourceResolver(resolver);
            Schema schema = this.schemaFactory.newSchema(new StreamSource(xsdStream));
            Validator validator = schema.newValidator();
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            validator.validate(new StreamSource(xml));
        }
    }

    private InputStream loadSchema(String name) {
        if (name.endsWith(".xsd") && name.indexOf(47) == -1 && name.indexOf(92) == -1) {
            return this.getClass().getResourceAsStream(name);
        }
        return null;
    }

    private class ResourceResolver
    implements LSResourceResolver,
    AutoCloseable {
        private final DOMImplementationLS domLS;
        private final List<InputStream> streams;

        private ResourceResolver() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            this.domLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            this.streams = new ArrayList<InputStream>();
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            InputStream stream = XmlValidator.this.loadSchema(systemId);
            if (stream == null) {
                return null;
            }
            this.streams.add(stream);
            LSInput input = this.domLS.createLSInput();
            input.setByteStream(stream);
            return input;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.streams);
        }
    }
}

