/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.support;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.elasticsearch.xpack.core.security.support.RestorableContextClassLoader;
import org.elasticsearch.xpack.idp.saml.idp.SamlIdentityProvider;
import org.elasticsearch.xpack.idp.saml.support.SamlFactory;
import org.elasticsearch.xpack.idp.saml.support.SamlInit;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import org.opensaml.xmlsec.signature.support.SignerProvider;
import org.w3c.dom.Element;

public class SamlObjectSigner {
    private final SamlIdentityProvider idp;
    private final SamlFactory samlFactory;

    public SamlObjectSigner(SamlFactory samlFactory, SamlIdentityProvider idp) {
        SamlInit.initialize();
        this.idp = idp;
        this.samlFactory = samlFactory;
    }

    public Element sign(SignableXMLObject object) {
        Signature signature = this.samlFactory.buildObject(Signature.class, Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential((Credential)this.idp.getSigningCredential());
        signature.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        object.setSignature(signature);
        Element element = this.samlFactory.toDomElement((XMLObject)object);
        try {
            AccessController.doPrivileged(() -> {
                try (RestorableContextClassLoader ignore = new RestorableContextClassLoader(SignerProvider.class);){
                    Signer.signObject((Signature)signature);
                }
                catch (SignatureException e) {
                    throw new SecurityException("failed to sign SAML object " + object, e);
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw new SecurityException("failed to sign SAML object " + object, e);
        }
        return element;
    }
}

