/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.support;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.xpack.core.security.support.RestorableContextClassLoader;
import org.opensaml.core.config.InitializationService;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.impl.X509CertificateBuilder;
import org.slf4j.LoggerFactory;

public final class SamlInit {
    private static final AtomicBoolean INITIALISED = new AtomicBoolean(false);
    private static final Logger LOGGER = LogManager.getLogger();

    private SamlInit() {
    }

    public static void initialize() {
        if (INITIALISED.compareAndSet(false, true)) {
            LoggerFactory.getLogger(InitializationService.class);
            SpecialPermission.check();
            try {
                AccessController.doPrivileged(() -> {
                    LOGGER.debug("Initializing OpenSAML");
                    try (RestorableContextClassLoader ignore = new RestorableContextClassLoader(InitializationService.class);){
                        InitializationService.initialize();
                        X509Certificate x509Certificate = new X509CertificateBuilder().buildObject();
                    }
                    LOGGER.debug("Initialized OpenSAML");
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw new ElasticsearchSecurityException("failed to set context classloader for SAML IdP", (Exception)e, new Object[0]);
            }
        }
    }
}

