/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.query;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.script.ScoreScript;
import org.elasticsearch.xpack.vectors.query.DenseVectorScriptDocValues;

public class ScoreScriptUtils {

    public static final class CosineSimilarity
    extends DenseVectorFunction {
        public CosineSimilarity(ScoreScript scoreScript, List<Number> queryVector, String field) {
            super(scoreScript, queryVector, field, true);
        }

        public double cosineSimilarity() {
            this.setNextVector();
            return this.docValues.dotProduct(this.queryVector) / (double)this.docValues.getMagnitude();
        }
    }

    public static final class DotProduct
    extends DenseVectorFunction {
        public DotProduct(ScoreScript scoreScript, List<Number> queryVector, String field) {
            super(scoreScript, queryVector, field);
        }

        public double dotProduct() {
            this.setNextVector();
            return this.docValues.dotProduct(this.queryVector);
        }
    }

    public static final class L2Norm
    extends DenseVectorFunction {
        public L2Norm(ScoreScript scoreScript, List<Number> queryVector, String field) {
            super(scoreScript, queryVector, field);
        }

        public double l2norm() {
            this.setNextVector();
            return this.docValues.l2Norm(this.queryVector);
        }
    }

    public static final class L1Norm
    extends DenseVectorFunction {
        public L1Norm(ScoreScript scoreScript, List<Number> queryVector, String field) {
            super(scoreScript, queryVector, field);
        }

        public double l1norm() {
            this.setNextVector();
            return this.docValues.l1Norm(this.queryVector);
        }
    }

    public static class DenseVectorFunction {
        final ScoreScript scoreScript;
        final float[] queryVector;
        final DenseVectorScriptDocValues docValues;

        public DenseVectorFunction(ScoreScript scoreScript, List<Number> queryVector, String field) {
            this(scoreScript, queryVector, field, false);
        }

        public DenseVectorFunction(ScoreScript scoreScript, List<Number> queryVector, String field, boolean normalizeQuery) {
            this.scoreScript = scoreScript;
            this.docValues = (DenseVectorScriptDocValues)((Object)scoreScript.getDoc().get(field));
            if (this.docValues.dims() != queryVector.size()) {
                throw new IllegalArgumentException("The query vector has a different number of dimensions [" + queryVector.size() + "] than the document vectors [" + this.docValues.dims() + "].");
            }
            this.queryVector = new float[queryVector.size()];
            double queryMagnitude = 0.0;
            for (int i = 0; i < queryVector.size(); ++i) {
                float value;
                this.queryVector[i] = value = queryVector.get(i).floatValue();
                queryMagnitude += (double)(value * value);
            }
            queryMagnitude = Math.sqrt(queryMagnitude);
            if (normalizeQuery) {
                int dim = 0;
                while (dim < this.queryVector.length) {
                    int n = dim++;
                    this.queryVector[n] = (float)((double)this.queryVector[n] / queryMagnitude);
                }
            }
        }

        void setNextVector() {
            try {
                this.docValues.setNextDocId(this.scoreScript._getDocId());
            }
            catch (IOException e) {
                throw ExceptionsHelper.convertToElastic((Exception)e);
            }
            if (this.docValues.size() == 0) {
                throw new IllegalArgumentException("A document doesn't have a value for a vector field!");
            }
        }
    }
}

