/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.query;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.xpack.vectors.query.DenseVectorScriptDocValues;

public class KnnDenseVectorScriptDocValues
extends DenseVectorScriptDocValues {
    private final VectorValues in;
    private float[] vector;

    KnnDenseVectorScriptDocValues(VectorValues in, int dims) {
        super(dims);
        this.in = in;
    }

    public void setNextDocId(int docId) throws IOException {
        int currentDoc = this.in.docID();
        this.vector = (float[])(currentDoc == Integer.MAX_VALUE || docId < currentDoc ? null : (docId == currentDoc ? this.in.vectorValue() : (float[])((currentDoc = this.in.advance(docId)) == docId ? this.in.vectorValue() : null)));
    }

    private float[] getVectorChecked() {
        if (this.vector == null) {
            throw new IllegalArgumentException("A document doesn't have a value for a vector field!");
        }
        return this.vector;
    }

    @Override
    public float[] getVectorValue() {
        float[] vector = this.getVectorChecked();
        return Arrays.copyOf(vector, vector.length);
    }

    @Override
    public float getMagnitude() {
        float[] vector = this.getVectorChecked();
        double magnitude = 0.0;
        for (float elem : vector) {
            magnitude += (double)(elem * elem);
        }
        return (float)Math.sqrt(magnitude);
    }

    @Override
    public double dotProduct(float[] queryVector) {
        return VectorUtil.dotProduct((float[])this.getVectorChecked(), (float[])queryVector);
    }

    @Override
    public double l1Norm(float[] queryVector) {
        float[] vectorValue = this.getVectorChecked();
        double result = 0.0;
        for (int i = 0; i < queryVector.length; ++i) {
            result += (double)Math.abs(vectorValue[i] - queryVector[i]);
        }
        return result;
    }

    @Override
    public double l2Norm(float[] queryVector) {
        return Math.sqrt(VectorUtil.squareDistance((float[])this.getVectorValue(), (float[])queryVector));
    }

    public int size() {
        if (this.vector == null) {
            return 0;
        }
        return 1;
    }
}

