/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.v2;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;

class FieldValueFetcher {
    private static final Set<Class<?>> VALID_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Long.class, Double.class, BigInteger.class, String.class, BytesRef.class)));
    final String name;
    final MappedFieldType fieldType;
    final DocValueFormat format;
    final IndexFieldData<?> fieldData;
    final Function<Object, Object> valueFunc;

    protected FieldValueFetcher(String name, MappedFieldType fieldType, IndexFieldData<?> fieldData, Function<Object, Object> valueFunc) {
        this.name = name;
        this.fieldType = fieldType;
        this.format = fieldType.docValueFormat(null, null);
        this.fieldData = fieldData;
        this.valueFunc = valueFunc;
    }

    FormattedDocValues getLeaf(LeafReaderContext context) {
        final FormattedDocValues delegate = this.fieldData.load(context).getFormattedValues(DocValueFormat.RAW);
        return new FormattedDocValues(){

            public boolean advanceExact(int docId) throws IOException {
                return delegate.advanceExact(docId);
            }

            public int docValueCount() throws IOException {
                return delegate.docValueCount();
            }

            public Object nextValue() throws IOException {
                return FieldValueFetcher.this.valueFunc.apply(delegate.nextValue());
            }
        };
    }

    Object format(Object value) {
        if (value instanceof Long) {
            return this.format.format(((Long)value).longValue());
        }
        if (value instanceof Double) {
            return this.format.format(((Double)value).doubleValue());
        }
        if (value instanceof BytesRef) {
            return this.format.format((BytesRef)value);
        }
        if (value instanceof String) {
            return value.toString();
        }
        throw new IllegalArgumentException("Invalid type: [" + value.getClass() + "]");
    }

    static List<FieldValueFetcher> build(SearchExecutionContext context, String[] fields) {
        ArrayList<FieldValueFetcher> fetchers = new ArrayList<FieldValueFetcher>();
        for (String field : fields) {
            MappedFieldType fieldType = context.getFieldType(field);
            if (fieldType == null) {
                throw new IllegalArgumentException("Unknown field: [" + field + "]");
            }
            IndexFieldData fieldData = context.getForField(fieldType);
            fetchers.add(new FieldValueFetcher(field, fieldType, fieldData, FieldValueFetcher.getValidator(field)));
        }
        return Collections.unmodifiableList(fetchers);
    }

    static List<FieldValueFetcher> buildHistograms(SearchExecutionContext context, String[] fields, double interval) {
        ArrayList<FieldValueFetcher> fetchers = new ArrayList<FieldValueFetcher>();
        for (String field : fields) {
            MappedFieldType fieldType = context.getFieldType(field);
            if (fieldType == null) {
                throw new IllegalArgumentException("Unknown field: [" + field + "]");
            }
            IndexFieldData fieldData = context.getForField(fieldType);
            fetchers.add(new FieldValueFetcher(field, fieldType, fieldData, FieldValueFetcher.getIntervalValueFunc(field, interval)));
        }
        return Collections.unmodifiableList(fetchers);
    }

    static Function<Object, Object> getValidator(String field) {
        return value -> {
            if (!VALID_TYPES.contains(value.getClass())) {
                throw new IllegalArgumentException("Expected [" + VALID_TYPES + "] for field [" + field + "], got [" + value.getClass() + "]");
            }
            return value;
        };
    }

    static Function<Object, Object> getIntervalValueFunc(String field, double interval) {
        return value -> {
            if (!(value instanceof Number)) {
                throw new IllegalArgumentException("Expected [Number] for field [" + field + "], got [" + value.getClass() + "]");
            }
            double number = ((Number)value).doubleValue();
            return Math.floor(number / interval) * interval;
        };
    }
}

