/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.db;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.maxmind.db.InvalidDatabaseException;
import com.maxmind.db.NodeCache;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

final class Decoder {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int[] POINTER_VALUE_OFFSETS = new int[]{0, 0, 2048, 526336, 0};
    boolean POINTER_TEST_HACK = false;
    private final NodeCache cache;
    private final long pointerBase;
    private final CharsetDecoder utfDecoder = UTF_8.newDecoder();
    private final ByteBuffer buffer;
    private final NodeCache.Loader cacheLoader = new NodeCache.Loader(){

        @Override
        public JsonNode load(int key) throws IOException {
            return Decoder.this.decode(key);
        }
    };

    Decoder(NodeCache cache, ByteBuffer buffer, long pointerBase) {
        this.cache = cache;
        this.pointerBase = pointerBase;
        this.buffer = buffer;
    }

    JsonNode decode(int offset) throws IOException {
        if (offset >= this.buffer.capacity()) {
            throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data: pointer larger than the database.");
        }
        this.buffer.position(offset);
        return this.decode();
    }

    private JsonNode decode() throws IOException {
        int size;
        int ctrlByte = 0xFF & this.buffer.get();
        Type type = Type.fromControlByte(ctrlByte);
        if (type.equals((Object)Type.POINTER)) {
            int pointerSize = (ctrlByte >>> 3 & 3) + 1;
            int base = (byte)(pointerSize == 4 ? 0 : (byte)(ctrlByte & 7));
            int packed = this.decodeInteger(base, pointerSize);
            long pointer = (long)packed + this.pointerBase + (long)POINTER_VALUE_OFFSETS[pointerSize];
            if (this.POINTER_TEST_HACK) {
                return new LongNode(pointer);
            }
            int targetOffset = (int)pointer;
            int position = this.buffer.position();
            JsonNode node = this.cache.get(targetOffset, this.cacheLoader);
            this.buffer.position(position);
            return node;
        }
        if (type.equals((Object)Type.EXTENDED)) {
            byte nextByte = this.buffer.get();
            int typeNum = nextByte + 7;
            if (typeNum < 8) {
                throw new InvalidDatabaseException("Something went horribly wrong in the decoder. An extended type resolved to a type number < 8 (" + typeNum + ")");
            }
            type = Type.get(typeNum);
        }
        if ((size = ctrlByte & 0x1F) >= 29) {
            switch (size) {
                case 29: {
                    size = 29 + (0xFF & this.buffer.get());
                    break;
                }
                case 30: {
                    size = 285 + this.decodeInteger(2);
                    break;
                }
                default: {
                    size = 65821 + this.decodeInteger(3);
                }
            }
        }
        return this.decodeByType(type, size);
    }

    private JsonNode decodeByType(Type type, int size) throws IOException {
        switch (type) {
            case MAP: {
                return this.decodeMap(size);
            }
            case ARRAY: {
                return this.decodeArray(size);
            }
            case BOOLEAN: {
                return Decoder.decodeBoolean(size);
            }
            case UTF8_STRING: {
                return new TextNode(this.decodeString(size));
            }
            case DOUBLE: {
                return this.decodeDouble(size);
            }
            case FLOAT: {
                return this.decodeFloat(size);
            }
            case BYTES: {
                return new BinaryNode(this.getByteArray(size));
            }
            case UINT16: {
                return this.decodeUint16(size);
            }
            case UINT32: {
                return this.decodeUint32(size);
            }
            case INT32: {
                return this.decodeInt32(size);
            }
            case UINT64: 
            case UINT128: {
                return this.decodeBigInteger(size);
            }
        }
        throw new InvalidDatabaseException("Unknown or unexpected type: " + type.name());
    }

    private String decodeString(int size) throws CharacterCodingException {
        int oldLimit = this.buffer.limit();
        this.buffer.limit(this.buffer.position() + size);
        String s = this.utfDecoder.decode(this.buffer).toString();
        this.buffer.limit(oldLimit);
        return s;
    }

    private IntNode decodeUint16(int size) {
        return new IntNode(this.decodeInteger(size));
    }

    private IntNode decodeInt32(int size) {
        return new IntNode(this.decodeInteger(size));
    }

    private long decodeLong(int size) {
        long integer = 0L;
        for (int i = 0; i < size; ++i) {
            integer = integer << 8 | (long)(this.buffer.get() & 0xFF);
        }
        return integer;
    }

    private LongNode decodeUint32(int size) {
        return new LongNode(this.decodeLong(size));
    }

    private int decodeInteger(int size) {
        return this.decodeInteger(0, size);
    }

    private int decodeInteger(int base, int size) {
        return Decoder.decodeInteger(this.buffer, base, size);
    }

    static int decodeInteger(ByteBuffer buffer, int base, int size) {
        int integer = base;
        for (int i = 0; i < size; ++i) {
            integer = integer << 8 | buffer.get() & 0xFF;
        }
        return integer;
    }

    private BigIntegerNode decodeBigInteger(int size) {
        byte[] bytes = this.getByteArray(size);
        return new BigIntegerNode(new BigInteger(1, bytes));
    }

    private DoubleNode decodeDouble(int size) throws InvalidDatabaseException {
        if (size != 8) {
            throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data: invalid size of double.");
        }
        return new DoubleNode(this.buffer.getDouble());
    }

    private FloatNode decodeFloat(int size) throws InvalidDatabaseException {
        if (size != 4) {
            throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data: invalid size of float.");
        }
        return new FloatNode(this.buffer.getFloat());
    }

    private static BooleanNode decodeBoolean(int size) throws InvalidDatabaseException {
        switch (size) {
            case 0: {
                return BooleanNode.FALSE;
            }
            case 1: {
                return BooleanNode.TRUE;
            }
        }
        throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data: invalid size of boolean.");
    }

    private JsonNode decodeArray(int size) throws IOException {
        ArrayList<JsonNode> array = new ArrayList<JsonNode>(size);
        for (int i = 0; i < size; ++i) {
            JsonNode r = this.decode();
            array.add(r);
        }
        return new ArrayNode(OBJECT_MAPPER.getNodeFactory(), Collections.unmodifiableList(array));
    }

    private JsonNode decodeMap(int size) throws IOException {
        int capacity = (int)((float)size / 0.75f + 1.0f);
        HashMap<String, JsonNode> map = new HashMap<String, JsonNode>(capacity);
        for (int i = 0; i < size; ++i) {
            String key = this.decode().asText();
            JsonNode value = this.decode();
            map.put(key, value);
        }
        return new ObjectNode(OBJECT_MAPPER.getNodeFactory(), Collections.unmodifiableMap(map));
    }

    private byte[] getByteArray(int length) {
        return Decoder.getByteArray(this.buffer, length);
    }

    private static byte[] getByteArray(ByteBuffer buffer, int length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return bytes;
    }

    static enum Type {
        EXTENDED,
        POINTER,
        UTF8_STRING,
        DOUBLE,
        BYTES,
        UINT16,
        UINT32,
        MAP,
        INT32,
        UINT64,
        UINT128,
        ARRAY,
        CONTAINER,
        END_MARKER,
        BOOLEAN,
        FLOAT;

        static final Type[] values;

        static Type get(int i) {
            return values[i];
        }

        private static Type get(byte b) {
            return Type.get(b & 0xFF);
        }

        static Type fromControlByte(int b) {
            return Type.get((byte)((0xFF & b) >>> 5));
        }

        static {
            values = Type.values();
        }
    }
}

