/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.enrollment;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.CommandLineHttpClient;
import org.elasticsearch.xpack.core.security.EnrollmentToken;
import org.elasticsearch.xpack.core.security.HttpResponse;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.enrollment.BaseEnrollmentTokenGenerator;

public class ExternalEnrollmentTokenGenerator
extends BaseEnrollmentTokenGenerator {
    protected static final String ENROLL_API_KEY_EXPIRATION = "30m";
    private static final Logger logger = LogManager.getLogger(ExternalEnrollmentTokenGenerator.class);
    private final Environment environment;
    private final SSLService sslService;
    private final CommandLineHttpClient client;
    private final URL defaultUrl;

    public ExternalEnrollmentTokenGenerator(Environment environment) throws MalformedURLException {
        this(environment, new CommandLineHttpClient(environment));
    }

    protected ExternalEnrollmentTokenGenerator(Environment environment, CommandLineHttpClient client) throws MalformedURLException {
        this.environment = environment;
        this.sslService = new SSLService(environment);
        this.client = client;
        this.defaultUrl = new URL(client.getDefaultURL());
    }

    public EnrollmentToken createNodeEnrollmentToken(String user, SecureString password) throws Exception {
        return this.create(user, password, "cluster:admin/xpack/security/enroll/node");
    }

    public EnrollmentToken createKibanaEnrollmentToken(String user, SecureString password) throws Exception {
        return this.create(user, password, "cluster:admin/xpack/security/enroll/kibana");
    }

    protected EnrollmentToken create(String user, SecureString password, String action) throws Exception {
        if (!((Boolean)XPackSettings.ENROLLMENT_ENABLED.get(this.environment.settings())).booleanValue()) {
            throw new IllegalStateException("[xpack.security.enrollment.enabled] must be set to `true` to create an enrollment token");
        }
        String fingerprint = ExternalEnrollmentTokenGenerator.getHttpsCaFingerprint(this.sslService);
        String apiKey = this.getApiKeyCredentials(user, password, action);
        Tuple<List<String>, String> httpInfo = this.getNodeInfo(user, password);
        return new EnrollmentToken(apiKey, fingerprint, (String)httpInfo.v2(), (List)httpInfo.v1());
    }

    private HttpResponse.HttpResponseBuilder responseBuilder(InputStream is) throws IOException {
        HttpResponse.HttpResponseBuilder httpResponseBuilder = new HttpResponse.HttpResponseBuilder();
        if (is != null) {
            String responseBody = Streams.readFully((InputStream)is).utf8ToString();
            logger.debug(responseBody);
            httpResponseBuilder.withResponseBody(responseBody);
        } else {
            logger.debug("Error building http response body: null response");
        }
        return httpResponseBuilder;
    }

    protected URL createAPIKeyUrl() throws MalformedURLException, URISyntaxException {
        return new URL(this.defaultUrl, (this.defaultUrl.toURI().getPath() + "/_security/api_key").replaceAll("/+", "/"));
    }

    protected URL getHttpInfoUrl() throws MalformedURLException, URISyntaxException {
        return new URL(this.defaultUrl, (this.defaultUrl.toURI().getPath() + "/_nodes/_local/http").replaceAll("/+", "/"));
    }

    protected static List<String> getBoundAddresses(Map<?, ?> nodesInfo) {
        nodesInfo = (Map)nodesInfo.get("nodes");
        Map nodeInfo = (Map)nodesInfo.values().iterator().next();
        Map http = (Map)nodeInfo.get("http");
        ArrayList<String> addresses = new ArrayList<String>();
        addresses.addAll((Collection)http.get("bound_address"));
        addresses.add(ExternalEnrollmentTokenGenerator.getIpFromPublishAddress((String)http.get("publish_address")));
        return addresses;
    }

    static String getVersion(Map<?, ?> nodesInfo) {
        nodesInfo = (Map)nodesInfo.get("nodes");
        Map nodeInfo = (Map)nodesInfo.values().iterator().next();
        return nodeInfo.get("version").toString();
    }

    protected String getApiKeyCredentials(String user, SecureString password, String action) throws Exception {
        CheckedSupplier createApiKeyRequestBodySupplier = () -> {
            XContentBuilder xContentBuilder = JsonXContent.contentBuilder();
            xContentBuilder.startObject().field("name", "enrollment_token_API_key_" + UUIDs.base64UUID()).field("expiration", ENROLL_API_KEY_EXPIRATION).startObject("role_descriptors").startObject("create_enrollment_token").array("cluster", new String[]{action}).endObject().endObject().endObject();
            return Strings.toString((XContentBuilder)xContentBuilder);
        };
        URL createApiKeyUrl = this.createAPIKeyUrl();
        HttpResponse httpResponseApiKey = this.client.execute("POST", createApiKeyUrl, user, password, createApiKeyRequestBodySupplier, is -> this.responseBuilder((InputStream)is));
        int httpCode = httpResponseApiKey.getHttpStatus();
        if (httpCode != 200) {
            logger.error("Error " + httpCode + "when calling GET " + createApiKeyUrl + ". ResponseBody: " + httpResponseApiKey.getResponseBody());
            throw new IllegalStateException("Unexpected response code [" + httpCode + "] from calling POST " + createApiKeyUrl);
        }
        String apiKey = Objects.toString(httpResponseApiKey.getResponseBody().get("api_key"), "");
        String apiId = Objects.toString(httpResponseApiKey.getResponseBody().get("id"), "");
        if (Strings.isNullOrEmpty((String)apiKey) || Strings.isNullOrEmpty((String)apiId)) {
            throw new IllegalStateException("Could not create an api key.");
        }
        return apiId + ":" + apiKey;
    }

    protected Tuple<List<String>, String> getNodeInfo(String user, SecureString password) throws Exception {
        URL httpInfoUrl = this.getHttpInfoUrl();
        HttpResponse httpResponseHttp = this.client.execute("GET", httpInfoUrl, user, password, () -> null, is -> this.responseBuilder((InputStream)is));
        int httpCode = httpResponseHttp.getHttpStatus();
        if (httpCode != 200) {
            logger.error("Error " + httpCode + "when calling GET " + httpInfoUrl + ". ResponseBody: " + httpResponseHttp.getResponseBody());
            throw new IllegalStateException("Unexpected response code [" + httpCode + "] from calling GET " + httpInfoUrl);
        }
        List<String> addresses = ExternalEnrollmentTokenGenerator.getBoundAddresses(httpResponseHttp.getResponseBody());
        if (addresses == null || addresses.isEmpty()) {
            logger.error("No bound addresses found in response from calling GET " + httpInfoUrl + ". ResponseBody: " + httpResponseHttp.getResponseBody());
            throw new IllegalStateException("No bound addresses found in response from calling GET " + httpInfoUrl);
        }
        List<String> filteredAddresses = ExternalEnrollmentTokenGenerator.getFilteredAddresses(addresses);
        String stackVersion = ExternalEnrollmentTokenGenerator.getVersion(httpResponseHttp.getResponseBody());
        if (stackVersion == null || stackVersion.isEmpty()) {
            throw new IllegalStateException("Could not retrieve the version.");
        }
        return new Tuple(filteredAddresses, (Object)stackVersion);
    }
}

