/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.AliasesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexAbstractionResolver;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteConnectionStrategy;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authz.ResolvedIndices;

class IndicesAndAliasesResolver {
    static final String[] NO_INDICES_OR_ALIASES_ARRAY = new String[]{"*", "-*"};
    static final List<String> NO_INDICES_OR_ALIASES_LIST = Arrays.asList(NO_INDICES_OR_ALIASES_ARRAY);
    private final IndexNameExpressionResolver nameExpressionResolver;
    private final IndexAbstractionResolver indexAbstractionResolver;
    private final RemoteClusterResolver remoteClusterResolver;

    IndicesAndAliasesResolver(Settings settings, ClusterService clusterService, IndexNameExpressionResolver resolver) {
        this.nameExpressionResolver = resolver;
        this.indexAbstractionResolver = new IndexAbstractionResolver(resolver);
        this.remoteClusterResolver = new RemoteClusterResolver(settings, clusterService.getClusterSettings());
    }

    ResolvedIndices resolve(String action, TransportRequest request, Metadata metadata, Set<String> authorizedIndices) {
        if (request instanceof IndicesAliasesRequest) {
            ResolvedIndices.Builder resolvedIndicesBuilder = new ResolvedIndices.Builder();
            IndicesAliasesRequest indicesAliasesRequest = (IndicesAliasesRequest)request;
            for (IndicesRequest indicesRequest : indicesAliasesRequest.getAliasActions()) {
                ResolvedIndices resolved = this.resolveIndicesAndAliases(action, indicesRequest, metadata, authorizedIndices);
                resolvedIndicesBuilder.addLocal(resolved.getLocal());
                resolvedIndicesBuilder.addRemote(resolved.getRemote());
            }
            return resolvedIndicesBuilder.build();
        }
        if (!(request instanceof IndicesRequest)) {
            throw new IllegalStateException("Request [" + request + "] is not an Indices request, but should be.");
        }
        return this.resolveIndicesAndAliases(action, (IndicesRequest)request, metadata, authorizedIndices);
    }

    @Nullable
    ResolvedIndices tryResolveWithoutWildcards(String action, TransportRequest transportRequest) {
        if (!(transportRequest instanceof IndicesRequest)) {
            return null;
        }
        IndicesRequest indicesRequest = (IndicesRequest)transportRequest;
        if (this.requiresWildcardExpansion(indicesRequest)) {
            return null;
        }
        return this.resolveIndicesAndAliasesWithoutWildcards(action, indicesRequest);
    }

    private boolean requiresWildcardExpansion(IndicesRequest indicesRequest) {
        if (indicesRequest instanceof IndicesAliasesRequest) {
            return true;
        }
        return indicesRequest instanceof IndicesRequest.Replaceable;
    }

    ResolvedIndices resolveIndicesAndAliasesWithoutWildcards(String action, IndicesRequest indicesRequest) {
        assert (!this.requiresWildcardExpansion(indicesRequest)) : "request must not require wildcard expansion";
        Object[] indices = indicesRequest.indices();
        if (indices == null || indices.length == 0) {
            throw new IllegalArgumentException("the action " + action + " requires explicit index names, but none were provided");
        }
        if (IndexNameExpressionResolver.isAllIndices(Arrays.asList(indices))) {
            throw new IllegalArgumentException("the action " + action + " does not support accessing all indices; the provided index expression [" + Strings.arrayToCommaDelimitedString((Object[])indices) + "] is not allowed");
        }
        List wildcards = Stream.of(indices).filter(Regex::isSimpleMatchPattern).collect(Collectors.toList());
        if (!wildcards.isEmpty()) {
            throw new IllegalArgumentException("the action " + action + " does not support wildcards; the provided index expression(s) [" + Strings.collectionToCommaDelimitedString(wildcards) + "] are not allowed");
        }
        ArrayList<String> localIndices = new ArrayList<String>(indices.length);
        for (Object name : indices) {
            localIndices.add(this.nameExpressionResolver.resolveDateMathExpression((String)name));
        }
        return new ResolvedIndices(localIndices, List.of());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ResolvedIndices resolveIndicesAndAliases(String action, IndicesRequest indicesRequest, Metadata metadata, Set<String> authorizedIndices) {
        ResolvedIndices.Builder resolvedIndicesBuilder = new ResolvedIndices.Builder();
        boolean indicesReplacedWithNoIndices = false;
        if (indicesRequest instanceof PutMappingRequest && ((PutMappingRequest)indicesRequest).getConcreteIndex() != null) {
            assert (indicesRequest.indices() == null || indicesRequest.indices().length == 0) : "indices are: " + Arrays.toString(indicesRequest.indices());
            resolvedIndicesBuilder.addLocal(IndicesAndAliasesResolver.getPutMappingIndexOrAlias((PutMappingRequest)indicesRequest, authorizedIndices, metadata));
        } else if (indicesRequest instanceof IndicesRequest.Replaceable) {
            boolean replaceWildcards;
            IndicesRequest.Replaceable replaceable = (IndicesRequest.Replaceable)indicesRequest;
            IndicesOptions indicesOptions = indicesRequest.indicesOptions();
            boolean bl = replaceWildcards = indicesOptions.expandWildcardsOpen() || indicesOptions.expandWildcardsClosed();
            if (IndexNameExpressionResolver.isAllIndices(IndicesAndAliasesResolver.indicesList(indicesRequest.indices()))) {
                if (replaceWildcards) {
                    for (String authorizedIndex : authorizedIndices) {
                        if (!IndexAbstractionResolver.isIndexVisible((String)"*", (String)authorizedIndex, (IndicesOptions)indicesOptions, (Metadata)metadata, (IndexNameExpressionResolver)this.nameExpressionResolver, (boolean)indicesRequest.includeDataStreams())) continue;
                        resolvedIndicesBuilder.addLocal(authorizedIndex);
                    }
                }
            } else {
                ResolvedIndices split = replaceable.allowsRemoteIndices() ? this.remoteClusterResolver.splitLocalAndRemoteIndexNames(indicesRequest.indices()) : new ResolvedIndices(Arrays.asList(indicesRequest.indices()), Collections.emptyList());
                List replaced = this.indexAbstractionResolver.resolveIndexAbstractions((Iterable)split.getLocal(), indicesOptions, metadata, authorizedIndices, replaceWildcards, indicesRequest.includeDataStreams());
                resolvedIndicesBuilder.addLocal(replaced);
                resolvedIndicesBuilder.addRemote(split.getRemote());
            }
            if (resolvedIndicesBuilder.isEmpty()) {
                if (!indicesOptions.allowNoIndices()) throw new IndexNotFoundException(Arrays.toString(indicesRequest.indices()));
                replaceable.indices(NO_INDICES_OR_ALIASES_ARRAY);
                indicesReplacedWithNoIndices = true;
                resolvedIndicesBuilder.addLocal("-*");
            } else {
                replaceable.indices(resolvedIndicesBuilder.build().toArray());
            }
        } else {
            assert (false) : "Request [" + indicesRequest + "] is not a replaceable request, but should be.";
            return this.resolveIndicesAndAliasesWithoutWildcards(action, indicesRequest);
        }
        if (!(indicesRequest instanceof AliasesRequest)) return resolvedIndicesBuilder.build();
        AliasesRequest aliasesRequest = (AliasesRequest)indicesRequest;
        if (aliasesRequest.expandAliasesWildcards()) {
            List<String> aliases = this.replaceWildcardsWithAuthorizedAliases(aliasesRequest.aliases(), this.loadAuthorizedAliases(authorizedIndices, metadata));
            aliasesRequest.replaceAliases(aliases.toArray(new String[aliases.size()]));
        }
        if (indicesReplacedWithNoIndices) {
            if (!(indicesRequest instanceof GetAliasesRequest)) {
                throw new IllegalStateException(GetAliasesRequest.class.getSimpleName() + " is the only known request implementing " + AliasesRequest.class.getSimpleName() + " that may allow no indices. Found [" + indicesRequest.getClass().getName() + "] which ended up with an empty set of indices.");
            }
        } else {
            resolvedIndicesBuilder.addLocal(aliasesRequest.aliases());
        }
        if (!aliasesRequest.expandAliasesWildcards() || aliasesRequest.aliases().length != 0) return resolvedIndicesBuilder.build();
        aliasesRequest.replaceAliases(NO_INDICES_OR_ALIASES_ARRAY);
        return resolvedIndicesBuilder.build();
    }

    static String getPutMappingIndexOrAlias(PutMappingRequest request, Set<String> authorizedIndicesList, Metadata metadata) {
        String resolvedAliasOrIndex;
        String concreteIndexName = request.getConcreteIndex().getName();
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(concreteIndexName);
        if (indexAbstraction == null) {
            resolvedAliasOrIndex = concreteIndexName;
        } else {
            if (indexAbstraction.getType() != IndexAbstraction.Type.CONCRETE_INDEX) {
                throw new IllegalStateException("concrete index [" + concreteIndexName + "] is a [" + indexAbstraction.getType().getDisplayName() + "], but a concrete index is expected");
            }
            if (authorizedIndicesList.contains(concreteIndexName)) {
                resolvedAliasOrIndex = concreteIndexName;
            } else {
                ImmutableOpenMap foundAliases = metadata.findAllAliases(new String[]{concreteIndexName});
                List aliasMetadata = (List)foundAliases.get((Object)concreteIndexName);
                if (aliasMetadata != null) {
                    Optional<String> foundAlias = aliasMetadata.stream().map(AliasMetadata::alias).filter(authorizedIndicesList::contains).filter(aliasName -> {
                        IndexAbstraction alias = (IndexAbstraction)metadata.getIndicesLookup().get(aliasName);
                        List indices = alias.getIndices();
                        if (indices.size() == 1) {
                            return true;
                        }
                        assert (alias.getType() == IndexAbstraction.Type.ALIAS);
                        Index writeIndex = alias.getWriteIndex();
                        return writeIndex != null && writeIndex.getName().equals(concreteIndexName);
                    }).findFirst();
                    resolvedAliasOrIndex = foundAlias.orElse(concreteIndexName);
                } else {
                    resolvedAliasOrIndex = concreteIndexName;
                }
            }
        }
        return resolvedAliasOrIndex;
    }

    private List<String> loadAuthorizedAliases(Set<String> authorizedIndices, Metadata metadata) {
        ArrayList<String> authorizedAliases = new ArrayList<String>();
        SortedMap existingAliases = metadata.getIndicesLookup();
        for (String authorizedIndex : authorizedIndices) {
            IndexAbstraction indexAbstraction = (IndexAbstraction)existingAliases.get(authorizedIndex);
            if (indexAbstraction == null || indexAbstraction.getType() != IndexAbstraction.Type.ALIAS) continue;
            authorizedAliases.add(authorizedIndex);
        }
        return authorizedAliases;
    }

    private List<String> replaceWildcardsWithAuthorizedAliases(String[] aliases, List<String> authorizedAliases) {
        ArrayList<String> finalAliases = new ArrayList<String>();
        if (aliases.length == 0) {
            finalAliases.addAll(authorizedAliases);
        }
        for (String aliasExpression : aliases) {
            boolean include = true;
            if (aliasExpression.charAt(0) == '-') {
                include = false;
                aliasExpression = aliasExpression.substring(1);
            }
            if ("_all".equals(aliasExpression) || Regex.isSimpleMatchPattern((String)aliasExpression)) {
                HashSet<String> resolvedAliases = new HashSet<String>();
                for (String authorizedAlias : authorizedAliases) {
                    if (!"_all".equals(aliasExpression) && !Regex.simpleMatch((String)aliasExpression, (String)authorizedAlias)) continue;
                    resolvedAliases.add(authorizedAlias);
                }
                if (include) {
                    finalAliases.addAll(resolvedAliases);
                    continue;
                }
                finalAliases.removeAll(resolvedAliases);
                continue;
            }
            if (include) {
                finalAliases.add(aliasExpression);
                continue;
            }
            finalAliases.remove(aliasExpression);
        }
        return finalAliases;
    }

    private static List<String> indicesList(String[] list) {
        return list == null ? null : Arrays.asList(list);
    }

    private static class RemoteClusterResolver
    extends RemoteClusterAware {
        private final CopyOnWriteArraySet<String> clusters;

        private RemoteClusterResolver(Settings settings, ClusterSettings clusterSettings) {
            super(settings);
            this.clusters = new CopyOnWriteArraySet(RemoteClusterResolver.getEnabledRemoteClusters((Settings)settings));
            this.listenForUpdates(clusterSettings);
        }

        protected void updateRemoteCluster(String clusterAlias, Settings settings) {
            if (RemoteConnectionStrategy.isConnectionEnabled((String)clusterAlias, (Settings)settings)) {
                this.clusters.add(clusterAlias);
            } else {
                this.clusters.remove(clusterAlias);
            }
        }

        ResolvedIndices splitLocalAndRemoteIndexNames(String ... indices) {
            Map map = super.groupClusterIndices(this.clusters, indices);
            List local = (List)map.remove("");
            List remote = map.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> (String)e.getKey() + ":" + v)).collect(Collectors.toList());
            return new ResolvedIndices(local == null ? Collections.emptyList() : local, remote);
        }
    }
}

