/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.support.DLSRoleQueryValidator;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.service.ServiceAccount;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public class ApiKeyGenerator {
    private final ApiKeyService apiKeyService;
    private final CompositeRolesStore rolesStore;
    private final NamedXContentRegistry xContentRegistry;

    public ApiKeyGenerator(ApiKeyService apiKeyService, CompositeRolesStore rolesStore, NamedXContentRegistry xContentRegistry) {
        this.apiKeyService = apiKeyService;
        this.rolesStore = rolesStore;
        this.xContentRegistry = xContentRegistry;
    }

    public void generateApiKey(Authentication authentication, CreateApiKeyRequest request, ActionListener<CreateApiKeyResponse> listener) {
        if (authentication == null) {
            listener.onFailure((Exception)new ElasticsearchSecurityException("no authentication available to generate API key", new Object[0]));
            return;
        }
        this.apiKeyService.ensureEnabled();
        ActionListener roleDescriptorsListener = ActionListener.wrap(roleDescriptors -> {
            for (RoleDescriptor rd : roleDescriptors) {
                try {
                    DLSRoleQueryValidator.validateQueryField((RoleDescriptor.IndicesPrivileges[])rd.getIndicesPrivileges(), (NamedXContentRegistry)this.xContentRegistry);
                }
                catch (IllegalArgumentException | ElasticsearchException e) {
                    listener.onFailure((Exception)e);
                    return;
                }
            }
            this.apiKeyService.createApiKey(authentication, request, (Set<RoleDescriptor>)roleDescriptors, listener);
        }, arg_0 -> listener.onFailure(arg_0));
        if ("_service_account".equals(authentication.getSourceRealm().getName())) {
            ServiceAccount serviceAccount = ServiceAccountService.getServiceAccounts().get(authentication.getUser().principal());
            if (serviceAccount == null) {
                roleDescriptorsListener.onFailure((Exception)new ElasticsearchSecurityException("the authentication is created by a service account that does not exist: [" + authentication.getUser().principal() + "]", new Object[0]));
            } else {
                roleDescriptorsListener.onResponse(Set.of(serviceAccount.roleDescriptor()));
            }
        } else {
            this.rolesStore.getRoleDescriptors(new HashSet<String>(Arrays.asList(authentication.getUser().roles())), (ActionListener<Set<RoleDescriptor>>)roleDescriptorsListener);
        }
    }
}

